<?php

use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_check_out extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_woo_check_out';
    }

    public function get_title() {
        return esc_html__('check out', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_check_out';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_style_section_1() {
        $this->start_controls_section(
            'woocommerce-coupon-form-input',
            [
                'label' => __( 'input', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control(
			'woocommerce-coupon-form-body',
			[ 
				'label' => esc_html__( 'body', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'checkout-woocommerce-checkout', '.checkout.woocommerce-checkout .billing-and-shipping' );

		$this->add_control(
			'woocommerce-coupon-form-label',
			[ 
				'label' => esc_html__( 'inputs', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('woocommerce-coupon-form-input',  'input');

        $this->add_control(
			'woocommerce-coupon-form-label',
			[
				'label' => esc_html__( 'labels', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('woocommerce-coupon-form-label',  'label', $align=false);
        
        $this->end_controls_section();
    }

    protected function register_style_section_2() {
        $this->start_controls_section(
            'woocommerce-billing-fields',
		    [
			    'label' => esc_html__('billing fields', THEME_NAME),
			    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		    ]
	    );
        $this->register_container_style('woocommerce-billing-fields',  '.woocommerce-billing-fields', $align=false);
        $this->end_controls_section();
    }

    protected function register_style_section_3() {
        $this->start_controls_section(
            'woocommerce-shipping-fields',
		    [
			    'label' => esc_html__('shipping fields', THEME_NAME),
			    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		    ]
	    );
        $this->register_container_style('woocommerce-shipping-fields',  '.woocommerce-shipping-fields', $align=false);
        $this->end_controls_section();
    }

    protected function register_style_section_4() {
        $this->start_controls_section(
            'woocommerce-coupon-fields',
		    [
			    'label' => esc_html__('coupon fields', THEME_NAME),
			    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		    ]
	    );

		$this->register_container_style( 'woocommerce-form-coupon-body', '.coupon-container', $align = false );

		$this->add_control(
			'woocommerce-form-coupon-body',
			[ 
				'label' => esc_html__( 'coupon body', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'woocommerce-form-coupon-toggle-body', '.woocommerce-form-coupon-toggle', $align = false );

        $this->add_control(
			'woocommerce-form-coupon-text',
			[ 
				'label' => esc_html__( 'coupon text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'woocommerce-form-coupon-toggle', '.woocommerce-info', $align = false );

		$this->add_control(
			'woocommerce-form-coupon-text',
			[ 
				'label' => esc_html__( 'text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'woocommerce-form-coupon-toggle-icon', '.woocommerce-info', $align = false );

		$this->add_control(
			'woocommerce-form-coupon-icon',
			[ 
				'label' => esc_html__( 'icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'woocommerce-form-coupon-toggle-text', '.woocommerce-info::before', $align = false );

		$this->add_control(
			'woocommerce-form-coupon-toggle',
			[ 
				'label' => esc_html__( 'toggle', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'woocommerce-form-coupon-toggle-a', '.woocommerce-info a', $align = false );

		$this->add_control(
			'woocommerce-form-coupon',
			[ 
				'label' => esc_html__( 'form', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_container_style('woocommerce-form-coupon',  '.woocommerce-form-coupon', $align=false);

		$this->add_control(
			'woocommerce-form-coupon-input',
			[ 
				'label' => esc_html__( 'form input', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'woocommerce-form-coupon', '.woocommerce-form-coupon input', $align = false );

		$this->add_control(
			'woocommerce-form-coupon-btn',
			[ 
				'label' => esc_html__( 'button', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'woocommerce-form-coupon-toggle-btn-body', '.coupon-container button', $align = false );
		$this->register_text_style( 'woocommerce-form-coupon-toggle-btn', '.coupon-container button', $align = false );
        $this->end_controls_section();
    }

    protected function register_style_section_5() {
        $this->start_controls_section(
            'button',
		    [
			    'label' => esc_html__('button ', THEME_NAME),
			    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		    ]
	    );

        $this->register_text_style('button',  'button', $align=false);
        $this->end_controls_section();
    }

    protected function register_style_section_6() {
        $this->start_controls_section(
            'woocommerce-additional-fields',
		    [
			    'label' => esc_html__('additional fields', THEME_NAME),
			    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		    ]
	    );

        $this->register_container_style('woocommerce-additional-fields', '.woocommerce-additional-fields');

		$this->add_control(
			'mega_menu_sep_icon_normal',
			[ 
				'label' => esc_html__( 'texterea', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->register_text_style( 'order_comments', '#order_comments', $align = false );

        $this->end_controls_section();
    } 

    protected function register_style_section_7() {
        $this->start_controls_section(
            'payment',
		    [
			    'label' => esc_html__('payment', THEME_NAME),
			    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		    ]
	    );

        $this->register_container_style('woocommerce-checkout-payment', '#order_review');

		$this->add_control(
			'payment-title',
			[ 
				'label' => esc_html__( 'title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'payment-title', '#order_review_heading', $align = false );


		$this->start_controls_tabs( 'tabs-item' );

        // Tab 1: normal
        $this->start_controls_tab(
            'normal',
            [
                'label' => esc_html__( 'normal', THEME_NAME ),
            ]
        );

        $this->register_text_style('mega-menu-tabs-normal-label',  '.wc_payment_method label', $align=false);

        $this->add_control(
            'mega_menu_sep_icon_normal',
            [
                'label' => esc_html__( 'icon', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        ); 
        $this->register_text_style('mega-menu-tabs-normal-icon', '.wc_payment_method input[type="radio"] + label::before', $align=false);

        $this->add_control(
            'mega_menu_sep_body_normal',
            [
                'label' => esc_html__( 'body', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        ); 

        $this->register_text_style('mega-menu-tabs-normal-body',  'li p', $align=false);

        $this->end_controls_tab();

        // Tab 2: active
        $this->start_controls_tab(
            'hover',
            [
                'label' => esc_html__( 'active', THEME_NAME ),
            ]
        );

        $this->register_text_style('mega-menu-tabs-hover-icon',  '.wc_payment_method input[type="radio"]:checked + label', $align=false);

        $this->add_control(
            'mega_menu_sep_icon_hover',
            [
                'label' => esc_html__( 'icon', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        ); 
        $this->register_text_style('mega-menu-tabs-active-icon',  '.wc_payment_method input[type="radio"]:checked + label::before', $align=false);

        $this->end_controls_tab();


        $this->end_controls_tabs();

		$this->add_control(
			'privacy-policy-seperator',
			[ 
				'label' => esc_html__( 'privacy policy', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'woocommerce-privacy-policy-text', '.woocommerce-privacy-policy-text' );

		$this->add_control(
			'privacy-policy-link-seperator',
			[ 
				'label' => esc_html__( 'privacy policy link', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style( 'woocommerce-privacy-policy-a', '.woocommerce-privacy-policy-text a' );

        $this->end_controls_section();
    } 

    protected function register_controls() {

        $this->register_style_section_1();
        $this->register_style_section_2();
        $this->register_style_section_3();
        $this->register_style_section_4();
        $this->register_style_section_5();
        $this->register_style_section_6();
        $this->register_style_section_7();

    }
    protected function add_coupon($content, $form_class=''){
        ob_start();
        ?>
        <form class="<?php echo esc_attr($form_class)?>" action="<?php echo esc_url( wc_get_cart_url() ); ?>" method="post">
            <?php echo $content?>
        </form>
        <?php 
        return apply_filters('dhwc_elementor_cart_form_wapper_output', ob_get_clean());
    }
    protected function render(){
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
        if ( $this->theme_is_edit_mode()) {
            ?>
            <div class="elementor-widget-container">
                <div class="coupon-container">
                    <div class="woocommerce-form-coupon-toggle">
                        <div class="woocommerce-info">
                            کد تخفیف دارید؟ <a href="#" class="showcoupon">برای نوشتن کد اینجا کلیک کنید</a> </div>
                    </div>
                    <form class="checkout_coupon woocommerce-form-coupon" method="post" style="display: none;">
                        <p class="form-row form-row-first">
                            <label for="coupon_code">کدتخفیف:</label>
                            <input type="text" name="coupon_code" class="input-text" placeholder="کد تخفیف" id="coupon_code" value="">
                        </p>
                        <p class="form-row form-row-last text-left d-flex flex-row-reverse">
                            <button type="submit" class="button" name="apply_coupon" value="اعمال کدتخفیف">اعمال کدتخفیف</button>
                        </p>

                        <div class="clear"></div>
                    </form>
                </div>
                <form name="checkout" method="post" class="checkout woocommerce-checkout" action="http://mega.test/checkout/" enctype="multipart/form-data" novalidate="novalidate">
                    <div class="row billing-and-shipping">
                        <div class="col-12 col-md-6">
                            <div class="woocommerce-billing-fields">
                                <h3>جزئیات صورتحساب</h3>
                                <div class="woocommerce-billing-fields__field-wrapper">
                                    <p class="form-row form-row-first validate-required" id="billing_first_name_field" data-priority="1"><label for="billing_first_name" class="">نام و نام خانوادگی&nbsp;<abbr class="required" title="ضروری">*</abbr></label><span class="woocommerce-input-wrapper"><input type="text" class="input-text " name="billing_first_name" id="billing_first_name" placeholder="" value="ادمین" autocomplete="given-name"></span></p>
                                    <p class="form-row form-row-wide validate-required validate-phone" id="billing_phone_field" data-priority="2"><label for="billing_phone" class="">تلفن همراه&nbsp;<abbr class="required" title="ضروری">*</abbr></label><span class="woocommerce-input-wrapper"><input type="tel" class="input-text " name="billing_phone" id="billing_phone" placeholder="" value="09391234456" autocomplete="tel"></span></p>
                                    <p class="form-row form-row-wide validate-required validate-email" id="billing_email_field" data-priority="3"><label for="billing_email" class="">ایمیل&nbsp;<abbr class="required" title="ضروری">*</abbr></label><span class="woocommerce-input-wrapper"><input type="email" class="input-text " name="billing_email" id="billing_email" placeholder="" value="test@local.com" autocomplete="email username"></span></p>
                                    <p class="form-row form-row-wide address-field validate-required validate-state" id="billing_state_field" data-priority="4"><label for="billing_state" class="">استان&nbsp;<abbr class="required" title="ضروری">*</abbr></label><span class="woocommerce-input-wrapper"><select name="billing_state" id="billing_state" class="state_select select2-hidden-accessible" autocomplete="address-level1" data-placeholder="یک گزینه انتخاب نمائید…" data-input-classes="" data-label="استان" tabindex="-1" aria-hidden="true">
                                    <option value="">یک گزینه انتخاب نمائید…</option><option value="KHZ">خوزستان</option><option value="THR">تهران</option><option value="ILM">ایلام</option><option value="BHR">بوشهر</option><option value="ADL">اردبیل</option><option value="ESF" selected="selected">اصفهان</option><option value="YZD">یزد</option><option value="KRH">کرمانشاه</option><option value="KRN">کرمان</option><option value="HDN">همدان</option><option value="GZN">قزوین</option><option value="ZJN">زنجان</option><option value="LRS">لرستان</option><option value="ABZ">البرز</option><option value="EAZ">آذربایجان شرقی</option><option value="WAZ">آذربایجان غربی</option><option value="CHB">چهارمحال و بختیاری</option><option value="SKH">خراسان جنوبی</option><option value="RKH">خراسان رضوی</option><option value="NKH">خراسان شمالی</option><option value="SMN">سمنان</option><option value="FRS">فارس</option><option value="QHM">قم</option><option value="KRD">کردستان</option><option value="KBD">کهگیلویه و بویراحمد</option><option value="GLS">گلستان</option><option value="GIL">گیلان</option><option value="MZN">مازندران</option><option value="MKZ">مرکزی</option><option value="HRZ">هرمزگان</option><option value="SBN">سیستان و بلوچستان</option></select><span class="select2 select2-container select2-container--default" dir="rtl" style="width: 100%;"><span class="selection"><span class="select2-selection select2-selection--single" aria-haspopup="true" aria-expanded="false" tabindex="0" aria-label="استان" role="combobox"><span class="select2-selection__rendered" id="select2-billing_state-container" role="textbox" aria-readonly="true" title="اصفهان">اصفهان</span>
                                    <span class="select2-selection__arrow" role="presentation"><b role="presentation"></b></span>
                                        </span>
                                        </span><span class="dropdown-wrapper" aria-hidden="true"></span></span>
                                        </span>
                                        </p>
                                        <p class="form-row form-row-wide address-field validate-required" id="billing_city_field" data-priority="5"><label for="billing_city" class="">شهر&nbsp;<abbr class="required" title="ضروری">*</abbr></label><span class="woocommerce-input-wrapper"><input type="text" class="input-text " name="billing_city" id="billing_city" placeholder="" value="اصفهان" autocomplete="address-level2"></span></p>
                                        <p class="form-row form-row-wide address-field validate-required validate-postcode" id="billing_postcode_field" data-priority="6"><label for="billing_postcode" class="">کدپستی (بدون فاصله و با اعداد انگلیسی)&nbsp;<abbr class="required" title="ضروری">*</abbr></label><span class="woocommerce-input-wrapper"><input type="text" class="input-text " name="billing_postcode" id="billing_postcode" placeholder="" value="123456" autocomplete="postal-code"></span></p>
                                        <p class="form-row form-row-wide address-field validate-required" id="billing_address_1_field" data-priority="7"><label for="billing_address_1" class="">آدرس خیابان&nbsp;<abbr class="required" title="ضروری">*</abbr></label><span class="woocommerce-input-wrapper"><input type="text" class="input-text " name="billing_address_1" id="billing_address_1" placeholder="نام خیابان و پلاک خانه" value="ادرس تست" autocomplete="address-line1"></span></p>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 col-md-6">
                            <div class="woocommerce-shipping-fields">
                                <h3 id="ship-to-different-address">
                                    <label class="woocommerce-form__label woocommerce-form__label-for-checkbox checkbox">
                                        <input id="ship-to-different-address-checkbox" class="woocommerce-form__input woocommerce-form__input-checkbox input-checkbox" checked="checked" type="checkbox" name="ship_to_different_address" value="1"> <span>حمل و نقل به یک آدرس متفاوت؟</span>
                                    </label>
                                </h3>
                                <div class="shipping_address" style="">
                                    <div class="woocommerce-shipping-fields__field-wrapper">
                                        <p class="form-row form-row-first validate-required" id="shipping_first_name_field" data-priority=""><label for="shipping_first_name" class="">نام و نام خانوداگی&nbsp;<abbr class="required" title="ضروری">*</abbr></label><span class="woocommerce-input-wrapper"><input type="text" class="input-text " name="shipping_first_name" id="shipping_first_name" placeholder="" value="ادمین" autocomplete="given-name"></span></p>
                                        <p class="form-row form-row-wide address-field validate-required validate-state" id="shipping_state_field" data-priority=""><label for="shipping_state" class="">استان&nbsp;<abbr class="required" title="ضروری">*</abbr></label><span class="woocommerce-input-wrapper"><select name="shipping_state" id="shipping_state" class="state_select select2-hidden-accessible" autocomplete="address-level1" data-placeholder="یک گزینه انتخاب نمائید…" data-input-classes="" data-label="استان" tabindex="-1" aria-hidden="true">
                                        <option value="">یک گزینه انتخاب نمائید…</option><option value="KHZ">خوزستان</option><option value="THR">تهران</option><option value="ILM">ایلام</option><option value="BHR">بوشهر</option><option value="ADL">اردبیل</option><option value="ESF" selected="selected">اصفهان</option><option value="YZD">یزد</option><option value="KRH">کرمانشاه</option><option value="KRN">کرمان</option><option value="HDN">همدان</option><option value="GZN">قزوین</option><option value="ZJN">زنجان</option><option value="LRS">لرستان</option><option value="ABZ">البرز</option><option value="EAZ">آذربایجان شرقی</option><option value="WAZ">آذربایجان غربی</option><option value="CHB">چهارمحال و بختیاری</option><option value="SKH">خراسان جنوبی</option><option value="RKH">خراسان رضوی</option><option value="NKH">خراسان شمالی</option><option value="SMN">سمنان</option><option value="FRS">فارس</option><option value="QHM">قم</option><option value="KRD">کردستان</option><option value="KBD">کهگیلویه و بویراحمد</option><option value="GLS">گلستان</option><option value="GIL">گیلان</option><option value="MZN">مازندران</option><option value="MKZ">مرکزی</option><option value="HRZ">هرمزگان</option><option value="SBN">سیستان و بلوچستان</option></select><span class="select2 select2-container select2-container--default" dir="rtl" style="width: 100%;"><span class="selection"><span class="select2-selection select2-selection--single" aria-haspopup="true" aria-expanded="false" tabindex="0" aria-label="استان" role="combobox"><span class="select2-selection__rendered" id="select2-shipping_state-container" role="textbox" aria-readonly="true" title="اصفهان">اصفهان</span>
                                        <span class="select2-selection__arrow" role="presentation"><b role="presentation"></b></span></span>
                                        </span><span class="dropdown-wrapper" aria-hidden="true"></span></span>
                                        </span>
                                        </p>
                                        <p class="form-row form-row-wide address-field validate-required" id="shipping_city_field" data-priority=""><label for="shipping_city" class="">شهر&nbsp;<abbr class="required" title="ضروری">*</abbr></label><span class="woocommerce-input-wrapper"><input type="text" class="input-text " name="shipping_city" id="shipping_city" placeholder="" value="اصفهان" autocomplete="address-level2"></span></p>
                                        <p class="form-row form-row-wide address-field validate-required" id="shipping_address_1_field" data-priority=""><label for="shipping_address_1" class="">آدرس&nbsp;<abbr class="required" title="ضروری">*</abbr></label><span class="woocommerce-input-wrapper"><input type="text" class="input-text " name="shipping_address_1" id="shipping_address_1" placeholder="نام خیابان و پلاک خانه" value="ادرس تست" autocomplete="address-line1"></span></p>
                                        <p class="form-row form-row-wide address-field validate-required validate-postcode" id="shipping_postcode_field" data-priority=""><label for="shipping_postcode" class="">کدپستی (بدون فاصله و با اعداد انگلیسی)&nbsp;<abbr class="required" title="ضروری">*</abbr></label><span class="woocommerce-input-wrapper"><input type="text" class="input-text " name="shipping_postcode" id="shipping_postcode" placeholder="" value="123456" autocomplete="postal-code"></span></p>
                                    </div>
                                </div>
                            </div>
                            <div class="woocommerce-additional-fields">
                                <div class="woocommerce-additional-fields__field-wrapper">
                                    <p class="form-row notes" id="order_comments_field" data-priority=""><label for="order_comments" class="">توضیحات سفارش&nbsp;<span class="optional">(اختیاری)</span></label><span class="woocommerce-input-wrapper"><textarea name="order_comments" class="input-text " id="order_comments" placeholder="یادداشت‌ها درباره سفارش شما، برای مثال نکات مهم درباره نحوه تحویل سفارش" rows="2" cols="5"></textarea></span></p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <wc-order-attribution-inputs><input type="hidden" name="wc_order_attribution_source_type" value="typein"><input type="hidden" name="wc_order_attribution_referrer" value="http://mega.test/dup-installer/main.installer.php"><input type="hidden" name="wc_order_attribution_utm_campaign" value="(none)"><input type="hidden" name="wc_order_attribution_utm_source" value="(direct)"><input type="hidden" name="wc_order_attribution_utm_medium" value="(none)"><input type="hidden" name="wc_order_attribution_utm_content" value="(none)">
                        <input type="hidden" name="wc_order_attribution_utm_id" value="(none)"><input type="hidden" name="wc_order_attribution_utm_term" value="(none)"><input type="hidden" name="wc_order_attribution_session_entry" value="http://mega.test/login/"><input type="hidden" name="wc_order_attribution_session_start_time" value="2024-05-28 08:50:42">
                        <input type="hidden" name="wc_order_attribution_session_pages" value="9"><input type="hidden" name="wc_order_attribution_session_count" value="2"><input type="hidden" name="wc_order_attribution_user_agent" value="Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:127.0) Gecko/20100101 Firefox/127.0"></wc-order-attribution-inputs>
                    <div id="order_review" class="woocommerce-checkout-review-order">
                        <h3 id="order_review_heading">روش پرداخت خود را انتخاب کنید</h3>
                        <table class="shop_table woocommerce-checkout-review-order-table">
                            <thead>
                                <tr>
                                    <th class="product-name">محصول</th>
                                    <th class="product-total">جمع جزء</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr class="cart_item">
                                    <td class="product-name">
                                        برند سازی&nbsp; <strong class="product-quantity">×&nbsp;2</strong> </td>
                                    <td class="product-total">
                                        <span class="woocommerce-Price-amount amount"><bdi>2،000،000&nbsp;<span class="woocommerce-Price-currencySymbol">تومان</span></bdi>
                                        </span>
                                    </td>
                                </tr>
                                <tr class="cart_item">
                                    <td class="product-name">
                                        آموزش هوش تجاری&nbsp; <strong class="product-quantity">×&nbsp;2</strong> </td>
                                    <td class="product-total">
                                        <span class="woocommerce-Price-amount amount"><bdi>0&nbsp;<span class="woocommerce-Price-currencySymbol">تومان</span></bdi>
                                        </span>
                                    </td>
                                </tr>
                            </tbody>
                            <tfoot>
                                <tr class="cart-subtotal">
                                    <th>جمع جزء</th>
                                    <td><span class="woocommerce-Price-amount amount"><bdi>2،000،000&nbsp;<span class="woocommerce-Price-currencySymbol">تومان</span></bdi>
                                        </span>
                                    </td>
                                </tr>
                                <tr class="woocommerce-shipping-totals shipping">
                                    <th>حمل و نقل</th>
                                    <td data-title="حمل و نقل">
                                        <ul id="shipping_method" class="woocommerce-shipping-methods">
                                            <li>
                                                <input type="radio" name="shipping_method[0]" data-index="0" id="shipping_method_0_free_shipping1" value="free_shipping:1" class="shipping_method" checked="checked"><label for="shipping_method_0_free_shipping1">حمل و نقل رایگان</label>                                    </li>
                                            <li>
                                                <input type="radio" name="shipping_method[0]" data-index="0" id="shipping_method_0_flat_rate2" value="flat_rate:2" class="shipping_method"><label for="shipping_method_0_flat_rate2">نرخ ثابت: <span class="woocommerce-Price-amount amount"><bdi>50،000&nbsp;<span class="woocommerce-Price-currencySymbol">تومان</span></bdi></span></label>                                    </li>
                                            <li>
                                                <input type="radio" name="shipping_method[0]" data-index="0" id="shipping_method_0_local_pickup3" value="local_pickup:3" class="shipping_method"><label for="shipping_method_0_local_pickup3">تحویل محلی</label> </li>
                                        </ul>
                                    </td>
                                </tr>
                                <tr class="order-total">
                                    <th>مجموع</th>
                                    <td><strong><span class="woocommerce-Price-amount amount"><bdi>2،000،000&nbsp;<span class="woocommerce-Price-currencySymbol">تومان</span></bdi></span></strong> </td>
                                </tr>
                            </tfoot>
                        </table>

                        <div id="payment" class="woocommerce-checkout-payment">
                            <ul class="wc_payment_methods payment_methods methods">
                                <li class="wc_payment_method payment_method_bacs">
                                    <input id="payment_method_bacs" type="radio" class="input-radio" name="payment_method" value="bacs" checked="checked" data-order_button_text="">
                                    <label for="payment_method_bacs">انتقال مستقیم بانکی 	</label>
                                    <div class="payment_box payment_method_bacs">
                                        <p>پرداخت خود را مستقیما به حساب بانکی ما واریز کنید.خواهشمندیم شماره سفارش خود را بعنوان کد ارجاع پرداخت استفاده کنید.سفارش شما تا زمانی که وجوه به حساب ما وارد نشود ارسال نخواهد شد.</p>
                                    </div>
                                </li>
                                <li class="wc_payment_method payment_method_cheque">
                                    <input id="payment_method_cheque" type="radio" class="input-radio" name="payment_method" value="cheque" data-order_button_text="">
                                    <label for="payment_method_cheque"> پرداخت با چک 	</label>
                                    <div class="payment_box payment_method_cheque" style="display:none;">
                                        <p>لطفا چک خود را به نام فروشگاه، خیابان فروشگاه، شهر فروشگاه، ایالت/کشور فروشگاه، کدپستی فروشگاه بفرستید.</p>
                                    </div>
                                </li>
                                <li class="wc_payment_method payment_method_cod">
                                    <input id="payment_method_cod" type="radio" class="input-radio" name="payment_method" value="cod" data-order_button_text="">
                                    <label for="payment_method_cod"> پرداخت هنگام دریافت 	</label>
                                    <div class="payment_box payment_method_cod" style="display:none;">
                                        <p>پرداخت نقدی پس از تحویل</p>
                                    </div>
                                </li>
                            </ul>
                            <div class="form-row place-order">
                                <noscript>
                                    به دلیل اینکه مرورگر شما جاوا اسکریپت را پشتیبانی نمی کند ، یا غیر فعال است ، لطفا کلیک کنید روی <em>بروزرسانی جمع </em>  قبل از اینکه سفارش خود را ثبت کنید.در صورتیکه این کار را نکنید ممکن است مبلغ قابل پرداخت شما بیش از چیزی که در بالا مشخص شده است باشد			<br/><button type="submit" class="button alt" name="woocommerce_checkout_update_totals" value="به روز رسانی جمع کل">به روز رسانی جمع کل</button>
                                </noscript>
                                <div class="woocommerce-terms-and-conditions-wrapper">
                                    <div class="woocommerce-privacy-policy-text">
                                        <p>اطلاعات شخصی شما برای پردازش سفارش شما، پشتیبانی از تجربه شما در سراسر این وب سایت و برای اهدافی که در <a href="http://mega.test/?page_id=3" class="woocommerce-privacy-policy-link" target="_blank">سیاست حفظ حریم خصوصی</a> ذکر
                                            شده است استفاده می شود.</p>
                                    </div>
                                </div>
                                <button type="submit" class="button alt" name="woocommerce_checkout_place_order" id="place_order" value="ثبت سفارش" data-value="ثبت سفارش">ثبت سفارش</button>
                                <input type="hidden" id="woocommerce-process-checkout-nonce" name="woocommerce-process-checkout-nonce" value="fa4f3a95c5"><input type="hidden" name="_wp_http_referer" value="/?wc-ajax=update_order_review"> </div>
                        </div>
                    </div>
                </form>
            </div>
            <?php
        }
        else{
            if ( isset( $_GET['key'] ) ) {
                $order_id = wc_get_order_id_by_order_key( $_GET['key'] );
                $order = wc_get_order( $order_id ); 
            }
            else {
                $checkout = WC()->checkout();
				wc_get_template(
					'checkout/form-login.php',
					array(
						'checkout' => WC()->checkout(),
					)
				);
                
                // If checkout registration is disabled and not logged in, the user cannot checkout.
                if ( ! $checkout->is_registration_enabled() && $checkout->is_registration_required() && ! is_user_logged_in() ) {
                    echo esc_html( apply_filters( 'woocommerce_checkout_must_be_logged_in_message', __( 'You must be logged in to checkout.', 'woocommerce' ) ) );
                    return;
                }

                ?>
                <div class="coupon-container">

                    <div class="woocommerce-form-coupon-toggle">
                        <?php wc_print_notice( apply_filters( 'woocommerce_checkout_coupon_message', esc_html__( 'Have a coupon?', 'woocommerce' ) . ' <a href="#" class="showcoupon">' . esc_html__( 'Click here to enter your code', 'woocommerce' ) . '</a>' ), 'notice' ); ?>
                    </div>
                    
                    <form class="checkout_coupon woocommerce-form-coupon" method="post" style="display:none">
                    
                    
                        <p class="form-row form-row-first">
                            <label for="coupon_code"><?php esc_html_e( 'Coupon:', 'woocommerce' ); ?></label>
                            <input type="text" name="coupon_code" class="input-text"
                                placeholder="<?php esc_attr_e( 'Coupon code', 'woocommerce' ); ?>" id="coupon_code" value="" />
                        </p>
                    
                        <p class="form-row form-row-last text-left d-flex flex-row-reverse">
                            <button type="submit"
                                class="button<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>"
                                name="apply_coupon"
                                value="<?php esc_attr_e( 'Apply coupon', 'woocommerce' ); ?>"><?php esc_html_e( 'Apply coupon', 'woocommerce' ); ?></button>
                        </p>
                    
                        <div class="clear"></div>
                    </form>
                </div>

                <form name="checkout" method="post" class="checkout woocommerce-checkout" action="<?php echo esc_url( wc_get_checkout_url() ); ?>" enctype="multipart/form-data">

                    <?php if ( $checkout->get_checkout_fields() ) : ?>

                        <?php do_action( 'woocommerce_checkout_before_customer_details' ); ?>
                        <div class="row billing-and-shipping">
                            <div class="col-12 col-md-6">
                                <?php do_action( 'woocommerce_checkout_billing' ); ?>
                            </div>
                            <div class="col-12 col-md-6">
                                <?php do_action( 'woocommerce_checkout_shipping' ); ?>
                            </div>
                        </div>

                        <?php do_action( 'woocommerce_checkout_after_customer_details' ); ?>

                    <?php endif; ?>
                    
                    <?php do_action( 'woocommerce_checkout_before_order_review_heading' ); ?>
                    
                    <?php do_action( 'woocommerce_checkout_before_order_review' ); ?>
                    
                    <div id="order_review" class="woocommerce-checkout-review-order">

                        <h3 id="order_review_heading"><?php esc_html_e( 'choose your payment method', THEME_NAME ); ?></h3>

                        <?php do_action( 'woocommerce_checkout_order_review' ); ?>
                    </div>

                    <?php do_action( 'woocommerce_checkout_after_order_review' ); ?>

                </form>
                
                <?php do_action( 'woocommerce_after_checkout_form', $checkout );
            }

        }
	}
}