<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_cart_count extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_woo_cart_count';
    }

    public function get_title() {
        return esc_html__('cart count', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_cart_count';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_style_section_1() {
        $this->start_controls_section(
            'cart-count-section',
            [
                'label' => esc_html__( 'cart count', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('cart-count',  '.cart-count');

        $this->end_controls_section();
    } 


    protected function register_controls() {

        $this->register_style_section_1();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
        if ($this->theme_is_edit_mode()) {
            echo '<p class="cart-count">3</p>';
            
        } else {
            $cart_count = 0;
			foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
				$cart_count += 1;
			}
			echo '<p class="cart-count">' . $cart_count . '</p>';
        }
    }

}