<?php

use handler\basic_element;

class ar_social extends \Elementor\Widget_Base {

	use basic_element;

	public function get_name() {
		return 'ar_social';
	}

	public function get_title() {
		return esc_html__( 'social', THEME_NAME );
	}

	public function get_icon() {
		return 'ar_social';
	}

	public function get_categories() {
        return ['core-elementor-elements'];
    }

	protected function register_content_section_1() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'social', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
            'name',
            [
                'label' => __( 'name', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );

		$this->add_control(
            'description',
            [
                'label' => __( 'description', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );

		$this->add_control(
			'link',
			[ 
				'label' => __( 'link', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::URL,
			]
		);


		$this->add_control(
			'icon-1',
			[ 
				'label' => esc_html__( 'first Icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::ICONS,
			]
		);

		$this->add_control(
			'icon-2',
			[ 
				'label' => esc_html__( 'sec Icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::ICONS,
			]
		);


		$this->end_controls_section();
	}

	protected function register_style_section_1() {
		$this->start_controls_section(
			'container',
			[
				'label' => esc_html__( 'style', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->start_controls_tabs(
			'style_tabs'
		);

		$this->start_controls_tab(
			'style_normal_tab',
			[ 
				'label' => esc_html__( 'normal', THEME_NAME ),
			]
		);

		$this->register_container_style('container',  '.social-container');

		$this->add_control(
			'text_heading',
			[ 
				'label' => esc_html__( 'name', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style('name',  '.name');

		$this->add_control(
		    'description_heading',
		    [
			    'label'     => esc_html__( 'description', THEME_NAME ),
			    'type'      => \Elementor\Controls_Manager::HEADING,
			    'separator' => 'before',
		    ]
	    );

		$this->register_text_style( 'description', '.description' );

		$this->add_control(
			'icon_1_heading',
			[ 
				'label' => esc_html__( 'first icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'icon', '.icon-1' );

		$this->add_control(
			'icon_2_heading',
			[ 
				'label' => esc_html__( 'sec icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'icon2', '.icon-2' );

		$this->end_controls_tab();

		$this->start_controls_tab(
			'style_hover_tab',
			[ 
				'label' => esc_html__( 'hover', THEME_NAME ),
			]
		);

		$this->register_container_style( 'container_hover', '.social-container:hover' );

		$this->add_control(
			'text_heading_hover',
			[ 
				'label' => esc_html__( 'text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'name_hover', '.social-container:hover .name' );

		$this->add_control(
			'description_heading_hover',
			[ 
				'label' => esc_html__( 'description', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'description_hover', '.social-container:hover .description' );

		$this->add_control(
			'icon_1_heading_hover',
			[ 
				'label' => esc_html__( 'first icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'icon_hover', '.social-container:hover .icon-1' );

		$this->add_control(
			'icon_2_heading_hover',
			[ 
				'label' => esc_html__( 'sec icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'icon2_hover', '.social-container:hover .icon-2' );

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();
	}

    protected function register_controls() {
		
		$this->register_content_section_1();

        $this->register_style_section_1();
	}


	protected function render() {
		$settings = $this->get_settings();
		?>
		<a href = "<?php echo esc_html( $settings['link']['url'] ); ?>" >
			<div class="row social-container align-items-center">
				<div class="col-2 d-flex">
					<div class="icon-1 d-flex align-items-center justify-content-center">
						<?php \Elementor\Icons_Manager::render_icon( $settings['icon-1'], [ 'aria-hidden' => 'true' ] ); ?>
					</div>
				</div>
				<div class="col-8">
					<p class="name">
						<?php echo esc_html($settings['name']) ;?>
					</p>
					<p class="description">
						<?php echo esc_html( $settings['description'] ); ?>
					</p>
				</div>
				<div class="col-2 d-flex">
					<div class="icon-2 d-flex align-items-center justify-content-center">
					<?php \Elementor\Icons_Manager::render_icon( $settings['icon-2'], [ 'aria-hidden' => 'true' ] ); ?>
					</div>
				</div>
			</div>
		</a>
		<?php 
	}
}