<?php

use handler\basic_element;

class ar_register extends \Elementor\Widget_Base {

    use basic_element;

    public function get_name() {
        return 'ar_register';
    }

    public function get_title() {
        return __('register Widget', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_register';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_content_section_1(){
        $this->start_controls_section(
            'login_form_labels_section',
            [
                'label' => __( 'register Form Labels', THEME_NAME ),
            ]
        );

        $this->add_control(
            'username_label',
            [
                'label' => __( 'Username Label', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Username', THEME_NAME ),
            ]
        );

        $this->add_control(
            'email_label',
            [
                'label' => __( 'email Label', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'email', THEME_NAME ),
            ]
        );

		$this->add_control(
			'registered_text',
			[ 
				'label' => __( 'registered text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'didnt register?', THEME_NAME ),
			]
		);

		$this->add_control(
			'register_text',
			[ 
				'label' => __( 'login text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'register', THEME_NAME ),
			]
		);

		$this->add_control(
			'login_link',
			[ 
				'label' => __( 'login link', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::URL,
				'options' => [ 'url', 'is_external', 'nofollow' ],
			]
		);

        $this->end_controls_section();
    }


    protected function register_style_section_1() {
        $this->start_controls_section(
            'login_form_style_section',
            [
                'label' => __( 'register Form Styles', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('inputs',  'input');

        $this->add_control(
			'labels',
			[
				'label' => esc_html__( 'labels', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('labels',  'label', $align=false);
        
        $this->end_controls_section();
    }

	protected function register_style_section_2() {
		$this->start_controls_section(
			'other_form_style_section',
			[ 
				'label' => __( 'other text Styles', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'links',
			[ 
				'label' => esc_html__( 'links', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->register_text_style( 'login_link', '.login-link', $align = false );

		$this->add_control(
			'texts',
			[ 
				'label' => esc_html__( 'texts', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'login_text', '.login-text', $align = false );

		$this->add_control(
			'btn',
			[ 
				'label' => esc_html__( 'buttom', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'login_btn', '.button', $align = false );

		$this->end_controls_section();
	}

    protected function register_controls() {

        $this->register_content_section_1();

        $this->register_style_section_1();
		$this->register_style_section_2();

    }

    
    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <form id="registerform" action="<?php echo esc_url( wp_registration_url() ); ?>" method="post">
            <p>
                <label for="user_login"><?php echo esc_html( $settings['username_label'] ); ?></label><br />
                <input type="text" name="user_login" id="user_login" class="input" value="" size="20" />
            </p>
            <p>
                <label for="user_email"><?php echo esc_html( $settings['email_label'] ); ?></label><br />
                <input type="email" name="user_email" id="user_email" class="input" value="" size="25" />
            </p>
            <input type="hidden" name="redirect_to" value="<?php echo esc_url( home_url() ); ?>" />
            <?php do_action( 'register_form' ); ?>

            <div class="form-register">
                <?php if ( $settings['registered_text'] ) { ?>
					<p class="login-text">
						<?php echo esc_attr( $settings['registered_text'] ); ?>
					</p>
				<?php }
				if ( $settings['login_link'] ) { ?>
					<a class="login-link"
						href="<?php echo esc_attr( $settings['login_link']['url'] ); ?>"><?php echo esc_attr( $settings['register_text'] ); ?></a>
				<?php } ?>
            </div>

            <p class="submit">
                <input type="submit" name="submit" class="button button-primary" value="<?php esc_attr_e( 'register', THEME_NAME ); ?>" />
            </p>
        </form>
        <?php
    }
}