<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_post_tags extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_post_tags';
    }

    public function get_title() {
        return esc_html__('post tags', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_post_tags';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }


    protected function register_style_section_1() {
        $this->start_controls_section(
            'post_price_style_section',
            [
                'label' => esc_html__( 'tags', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'show_comma',
            [
                'label'     => esc_html__( 'Show comma', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SWITCHER,
                'default'   => 'yes',
                'separator' => 'before'
            ]
        );

        $this->register_text_style('post_tags',  'a', $align=false);

        $this->end_controls_section();

    } 

    protected function register_controls() {

        $this->register_style_section_1();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        if ($this->theme_is_edit_mode()) {
            ?>
            <a href="#">برچسب 1</a><?php if($settings['show_comma']){echo ',';}?>
            <a href="#">برچسب 2</a><?php if($settings['show_comma']){echo ',';}?>
            <a href="#">برچسب 3</a>
            <?php
        } else {
			global $post;
            $post_id = get_the_ID();
			$post_tags = get_the_tags( $post_id );
			if ( $post_tags ) {
				$tags_list = array();
				foreach ( $post_tags as $tag ) {
					$tags_list[] = '<a href="' . esc_url( get_tag_link( $tag->term_id ) ) . '">' . esc_html( $tag->name ) . '</a>';
				}
				if ( $settings['show_comma'] ) {
					// Output tags separated by commas
					echo implode( ', ', $tags_list );
				} else {
					// Output each tag as a separate link
					foreach ( $tags_list as $tag_link ) {
						echo $tag_link . ' ';
					}
				}
			}

		}
    }
}