<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_post_read_time extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_post_read_time';
    }

    public function get_title() {
        return esc_html__('post read time', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_post_read_time';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }


    protected function register_style_section_1() {
        $this->start_controls_section(
            'post_style_section',
            [
                'label' => esc_html__( 'style', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('post_categories',  '.reading-time');

        $this->end_controls_section();

    } 

    protected function register_controls() {

        $this->register_style_section_1();
    }

    protected function render() {
        if ($this->theme_is_edit_mode()) {
            echo '<p class="reading-time">';
            echo 'زمان مطالعه: 5 دقیقه';
            echo '</p>';
        } else {
            ?>
            <p class="reading-time">
            <?php
            $mins = calc_read_time();
            printf( esc_html( _n( 'One Min Read', '%d  Mins Read', $mins, THEME_NAME  ) ), $mins );
            ?>
            </p>
            <?php
        }
    }


}