<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_post_publish_date extends \Elementor\Widget_Base {

    use basic_element;

    public function get_name() {
        return 'ar_post_publish_date';
    }

    public function get_title() {
        return esc_html__('post publish date', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_post_publish_date';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }


    protected function register_style_section_1() {
        $this->start_controls_section(
            'post_price_style_section',
            [
                'label' => esc_html__( 'date', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('post_categories',  '.post-dates');

        $this->end_controls_section();

    } 

    protected function register_controls() {

        $this->register_style_section_1();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        if ($this->theme_is_edit_mode()) {
            echo '<p class="post-dates">';
			echo convert_date( get_the_date(), 'j F Y' );
            echo '</p>';
        } else {
            global $post;
            $post_slug = $post->post_name;
            $post = get_page_by_path($post_slug, OBJECT, 'post');

            if ($post) {
                echo '<p class="post-dates">';
				echo convert_date( get_the_date(), 'j F Y' );
                echo'</p>';                
            }
        }
    }


}