<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_post_link extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_post_link';
    }

    public function get_title() {
        return esc_html__('post link', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_post_link';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }


    protected function register_style_section_1() {
        $this->start_controls_section(
            'post_style_section',
            [
                'label' => esc_html__( 'text', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('post_link',  'a p');

        $this->end_controls_section();

    }


	protected function register_controls() {

        $this->register_style_section_1();
    }

	protected function render() {
		$post_kind = get_post_type();
		$selected_attribute_key = $post_kind . '_single_link_url';
		$selected_attribute_key_2 = $post_kind . '_single_link_title';
		$selected_attribute_value = '';
		$selected_attribute_value_2 = '';

		if ( $this->theme_is_edit_mode() ) {
			$selected_attribute_value = __( "#", THEME_NAME );
			$selected_attribute_value_2 = __( "link text", THEME_NAME );
		} else {
			if ( ! empty( $selected_attribute_key ) ) {
				$selected_attribute_value = get_post_meta( get_the_ID(), $selected_attribute_key, true );
				$selected_attribute_value_2 = get_post_meta( get_the_ID(), $selected_attribute_key_2, true );
			}
		}
		// Check if the URL is not empty before rendering the link
		if ( ! empty( $selected_attribute_value ) ) {
			echo '<a href="' . esc_url( $selected_attribute_value ) . '" class="selected_attribute_value"><p>' . esc_html( $selected_attribute_value_2 ) . '</p></a>';
		}
	}


}