<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_post_comments_count extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_post_comments_count';
    }

    public function get_title() {
        return esc_html__('post comments count', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_post_comments_count';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_content_section_1() {
        $this->start_controls_section(
            'section_general',
            [
                'label' => esc_html__( 'text', THEME_NAME ),
            ]
        );

        $this->add_control(
            'text',
            [
                'label' => esc_html__( 'Text', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->end_controls_section();

    } 
    protected function register_style_section_1() {
        $this->start_controls_section(
            'post_price_style_section',
            [
                'label' => esc_html__( 'comment', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('comment_count',  '.comment-count');

        $this->end_controls_section();

    } 

    protected function register_controls() {

        $this->register_content_section_1();
        $this->register_style_section_1();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        if ($this->theme_is_edit_mode()) { 
            echo '<p class="comment-count"> 3' . $settings['text'] . '</p>';
        } else {
            global $post;
            $post_slug = $post->post_name;
            $post = get_page_by_path($post_slug, OBJECT, 'post');
            if ($post) {
                $post_id = get_the_ID();
                $comment_count = get_comments_number($post_id); // Get the total number of comments (including reviews) for the post
                echo '<p class="comment-count">' . $comment_count . $settings['text'] . '</p>';
            }
        }
    }


}