<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_post_comments extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_post_comments';
    }

    public function get_title() {
        return esc_html__('post comments', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_post_comments';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }


    protected function register_style_section_1() {
        $this->start_controls_section(
            'author_image_section',
            [
                'label' => esc_html__( 'author image', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_image_style('author_image',  '.comment-list .comment-author img');

        $this->end_controls_section();

    } 

    protected function register_style_section_2() {
        $this->start_controls_section(
            'author_title_section',
            [
                'label' => esc_html__( 'author name', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('author_title',  '.comment-list .comment-author .fn, .comment-list .comment-author a');

        $this->end_controls_section();

    } 

    protected function register_style_section_3() {
        $this->start_controls_section(
            'date_section',
            [
                'label' => esc_html__( 'date', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('date',  '.comment-metadata');

        $this->end_controls_section();
    }
    
    protected function register_style_section_4() {
        $this->start_controls_section(
            'body_section',
            [
                'label' => esc_html__( 'body', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('body',  '.comment-content');

        $this->end_controls_section();
    }

    protected function register_style_section_5() {
        $this->start_controls_section(
            'btn_section',
            [
                'label' => esc_html__( 'button', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('btn',  '.comment-reply-link');

        $this->end_controls_section();
    }

     protected function register_style_section_6() {
        $this->start_controls_section(
            'container_section',
            [
                'label' => esc_html__( 'container', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

		$this->register_container_style( 'comments-list', '.comment-list' );

		$this->add_control(
			'first-level-comment',
			[ 
				'label' => esc_html__( 'first level comment', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

        $this->register_container_style('container',  '.comment-body');

		$this->add_control(
			'children-comment',
			[ 
				'label' => esc_html__( 'children comment', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_container_style( 'children', 'ol.children' );

        $this->end_controls_section();
    }

	protected function register_style_section_7() {
		$this->start_controls_section(
			'add-comment_section',
			[ 
				'label' => esc_html__( 'add comment', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_text_style( 'add-comment', '.comment-reply-title' );

		$this->add_control(
			'heading-span',
			[ 
				'label' => esc_html__( 'title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'add-comment-span', '.comment-reply-title span' );

		$this->end_controls_section();
	}

	protected function register_style_section_8() {
		$this->start_controls_section(
			'add-comment_body_section',
			[ 
				'label' => esc_html__( 'add comment body', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_container_style( 'custom-form-comment-body', '.custom-form' );

		$this->add_control(
			'form-body',
			[ 
				'label' => esc_html__( 'form body', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_container_style( 'add-comment-body', 'form' );

		$this->end_controls_section();
	}

	protected function register_style_section_9() {
		$this->start_controls_section(
			'add-comment_label_section',
			[ 
				'label' => esc_html__( 'add comment label', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_text_style( 'add-comment-label', 'label', $align = false );

		$this->end_controls_section();
	}

	protected function register_style_section_10() {
		$this->start_controls_section(
			'add-comment_input_section',
			[ 
				'label' => esc_html__( 'add comment input', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_text_style( 'add-comment-input', 'input', $align = false );

		$this->end_controls_section();
	}

	protected function register_style_section_11() {
		$this->start_controls_section(
			'add-comment_icon_section',
			[ 
				'label' => esc_html__( 'add comment icon', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_container_style( 'add-comment-icon', 'svg' );

		$this->end_controls_section();
	}

	protected function register_style_section_12() {
		$this->start_controls_section(
			'add-comment_score_section',
			[ 
				'label' => esc_html__( 'add comment score', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_text_style( 'add-comment-star', '.star-continaner', $align = false );

		$this->end_controls_section();
	}

	protected function register_style_section_13() {
		$this->start_controls_section(
			'add-comment_textarea_section',
			[ 
				'label' => esc_html__( 'add comment textarea', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_text_style( 'add-comment-textarea', 'textarea', $align = false );

		$this->end_controls_section();
	}

	protected function register_style_section_14() {
		$this->start_controls_section(
			'add-comment_submit_section',
			[ 
				'label' => esc_html__( 'submit', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_text_style( 'add-comment-submit', 'input[name="submit"][type="submit"].submit#submit', $align = false );

		$this->end_controls_section();
	}

	protected function register_controls() {

        $this->register_style_section_1();
        $this->register_style_section_2();
        $this->register_style_section_3();
        $this->register_style_section_4();
        $this->register_style_section_5();
        $this->register_style_section_6();
		$this->register_style_section_7();
		$this->register_style_section_8();
		$this->register_style_section_9();
		$this->register_style_section_10();
		$this->register_style_section_11();
		$this->register_style_section_12();
		$this->register_style_section_13();
		$this->register_style_section_14();
    }

    protected function render() {
        if ($this->theme_is_edit_mode()) {
            // Display comments of the first post in edit mode
            $first_post = get_posts(array(
                'post_type'      => 'post',
                'posts_per_page' => 1,
                'orderby'        => 'ID',
                'order'          => 'ASC',
                'fields'         => 'ids',
            ));
            $first_post_id = $first_post[0];
            $comments_args = array(
                'post_id' => $first_post_id, // Specify the post ID of the first post
            );
            $comments = get_comments($comments_args);
            if ($comments) {
                echo '<div class="comments-container">';
                echo '<ol class="comment-list">';
                // Output each top-level comment
                wp_list_comments(array(
                    'style'      => 'ol',
                    'avatar_size' => 60,
                    'max_depth'  => 3, // Set the maximum depth of nested comments
                ), $comments);
                echo '</ol>';
                echo '</div>';
            }
			?>
			<div class="custom-form">
                        	<div id="respond" class="comment-respond">
		<h2 id="reply-title" class="comment-reply-title"><span> دیدگاه</span>شما <small><a rel="nofollow" id="cancel-comment-reply-link" href="/2024/03/18/%d8%aa%d8%a8%d9%84%db%8c%d8%ba%d8%a7%d8%aa-%d8%a7%d8%b3%d8%aa%d8%b1%d8%a7%d8%aa%da%98%db%8c%da%a9/#respond" style="display:none;">لغو پاسخ</a></small></h2><form action="http://mega.test/wp-comments-post.php" method="post" id="commentform" class="comment-form"><p class="comment-notes"><span id="email-notes">نشانی ایمیل شما منتشر نخواهد شد.</span> <span class="required-field-message">بخش‌های موردنیاز علامت‌گذاری شده‌اند <span class="required">*</span></span></p><div class="comment-input-container full-width"><textarea id="comment" name="comment" rows="6" class="form-textarea" placeholder="متن شما" required=""></textarea></div><div class="top"><div class="comment-input-container half-width">
                    <label for="author">نام و نام خانوادگی</label>
                    <input class="form-author" id="author" name="author" type="text" size="30" maxlength="245" placeholder="نام *" value="" required="">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                        <path d="M15.0006 22.75H9.00063C7.68063 22.75 6.58063 22.62 5.65063 22.34C5.31063 22.24 5.09063 21.91 5.11063 21.56C5.36063 18.57 8.39063 16.22 12.0006 16.22C15.6106 16.22 18.6306 18.56 18.8906 21.56C18.9206 21.92 18.7006 22.24 18.3506 22.34C17.4206 22.62 16.3206 22.75 15.0006 22.75ZM6.72063 21.06C7.38063 21.19 8.13063 21.25 9.00063 21.25H15.0006C15.8706 21.25 16.6206 21.19 17.2806 21.06C16.7506 19.14 14.5606 17.72 12.0006 17.72C9.44063 17.72 7.25063 19.14 6.72063 21.06Z" fill="#FED275"></path>
                        <path d="M15 2H9C4 2 2 4 2 9V15C2 18.78 3.14 20.85 5.86 21.62C6.08 19.02 8.75 16.97 12 16.97C15.25 16.97 17.92 19.02 18.14 21.62C20.86 20.85 22 18.78 22 15V9C22 4 20 2 15 2ZM12 14.17C10.02 14.17 8.42 12.56 8.42 10.58C8.42 8.60002 10.02 7 12 7C13.98 7 15.58 8.60002 15.58 10.58C15.58 12.56 13.98 14.17 12 14.17Z" stroke="#FED275" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                        <path d="M11.9999 14.92C9.60992 14.92 7.66992 12.97 7.66992 10.58C7.66992 8.19002 9.60992 6.25 11.9999 6.25C14.3899 6.25 16.3299 8.19002 16.3299 10.58C16.3299 12.97 14.3899 14.92 11.9999 14.92ZM11.9999 7.75C10.4399 7.75 9.16992 9.02002 9.16992 10.58C9.16992 12.15 10.4399 13.42 11.9999 13.42C13.5599 13.42 14.8299 12.15 14.8299 10.58C14.8299 9.02002 13.5599 7.75 11.9999 7.75Z" fill="#FED275"></path>
                    </svg>
                </div>
<div class="comment-input-container half-width">
                    <label for="email">پست الکترونیک</label>
                    <input class="form-email" id="email" name="email" type="email" size="30" maxlength="200" placeholder="پست الکترونیک *" value="" required="">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                        <path d="M3.02878 8L8.48356 11.645C9.76421 12.4963 10.4045 12.9219 11.0964 13.0873C11.7078 13.2335 12.3451 13.2335 12.9565 13.0873C13.6483 12.9219 14.2887 12.4963 15.5693 11.645L20.9736 8.04005M7.8 19H16.2C17.8802 19 18.7202 19 19.362 18.673C19.9265 18.3854 20.3854 17.9265 20.673 17.362C21 16.7202 21 15.8802 21 14.2V9.8C21 8.11984 21 7.27976 20.673 6.63803C20.3854 6.07354 19.9265 5.6146 19.362 5.32698C18.7202 5 17.8802 5 16.2 5H7.8C6.11984 5 5.27976 5 4.63803 5.32698C4.07354 5.6146 3.6146 6.07354 3.32698 6.63803C3 7.27976 3 8.11984 3 9.8V14.2C3 15.8802 3 16.7202 3.32698 17.362C3.6146 17.9265 4.07354 18.3854 4.63803 18.673C5.27976 19 6.11984 19 7.8 19Z" stroke="#FED275" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                    </svg>
                </div></div>
<p class="comment-form-cookies-consent"><input id="wp-comment-cookies-consent" name="wp-comment-cookies-consent" type="checkbox" value="yes"> <label for="wp-comment-cookies-consent">ذخیره نام، ایمیل و وبسایت من در مرورگر برای زمانی که دوباره دیدگاهی می‌نویسم.</label></p>
<p class="form-submit" style="display: none;"></p><div class="comment-submit full-width"><input name="submit" type="submit" id="submit" class="submit" value="ارسال دیدگاه"></div> <input type="hidden" name="comment_post_ID" value="539" id="comment_post_ID">
<input type="hidden" name="comment_parent" id="comment_parent" value="0">
<p></p></form>	</div><!-- #respond -->
	                    </div>
			<?php
			return;

        } else {
            ?>

            <?php
            $comments_args = array(
                'post_id' => get_the_ID(), // Specify the post ID of the current post
            );
            $comments = get_comments($comments_args);
            if ($comments) {
                echo '<div class="comments-container">';
                echo '<ol class="comment-list">';
                // Output each top-level comment
                wp_list_comments(array(
                    'style'      => 'ol',
                    'avatar_size' => 60,
                    'max_depth'  => 3, // Set the maximum depth of nested comments
                ), $comments);
                echo '</ol>';
                
            }
            if ( ! comments_open() ) : ?>
                    <p class="comments-closed"><?php esc_html_e( 'Comments are closed.', THEME_NAME ); ?></p>
                <?php endif; ?>
                <?php
				$commenter = wp_get_current_commenter();

				$req = get_option( 'require_name_email' );
				$aria_req = $req ? ' required' : '';
				$req_sign = $req ? ' *' : '';

				$fields = array(
					'author' => '<div class="top"><div class="comment-input-container half-width">
                    <label for="author">' . esc_attr__( 'first and last name', THEME_NAME ) . '</label>
                    <input class="form-author" id="author" name="author" type="text" size="30" maxlength="245" placeholder="' . esc_attr__( 'Name', THEME_NAME ) . $req_sign . '" value="' . esc_attr( $commenter['comment_author'] ) . '" ' . $aria_req . '>
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                        <path d="M15.0006 22.75H9.00063C7.68063 22.75 6.58063 22.62 5.65063 22.34C5.31063 22.24 5.09063 21.91 5.11063 21.56C5.36063 18.57 8.39063 16.22 12.0006 16.22C15.6106 16.22 18.6306 18.56 18.8906 21.56C18.9206 21.92 18.7006 22.24 18.3506 22.34C17.4206 22.62 16.3206 22.75 15.0006 22.75ZM6.72063 21.06C7.38063 21.19 8.13063 21.25 9.00063 21.25H15.0006C15.8706 21.25 16.6206 21.19 17.2806 21.06C16.7506 19.14 14.5606 17.72 12.0006 17.72C9.44063 17.72 7.25063 19.14 6.72063 21.06Z" fill="#FED275"/>
                        <path d="M15 2H9C4 2 2 4 2 9V15C2 18.78 3.14 20.85 5.86 21.62C6.08 19.02 8.75 16.97 12 16.97C15.25 16.97 17.92 19.02 18.14 21.62C20.86 20.85 22 18.78 22 15V9C22 4 20 2 15 2ZM12 14.17C10.02 14.17 8.42 12.56 8.42 10.58C8.42 8.60002 10.02 7 12 7C13.98 7 15.58 8.60002 15.58 10.58C15.58 12.56 13.98 14.17 12 14.17Z" stroke="#FED275" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M11.9999 14.92C9.60992 14.92 7.66992 12.97 7.66992 10.58C7.66992 8.19002 9.60992 6.25 11.9999 6.25C14.3899 6.25 16.3299 8.19002 16.3299 10.58C16.3299 12.97 14.3899 14.92 11.9999 14.92ZM11.9999 7.75C10.4399 7.75 9.16992 9.02002 9.16992 10.58C9.16992 12.15 10.4399 13.42 11.9999 13.42C13.5599 13.42 14.8299 12.15 14.8299 10.58C14.8299 9.02002 13.5599 7.75 11.9999 7.75Z" fill="#FED275"/>
                    </svg>
                </div>',
					'email' => '<div class="comment-input-container half-width">
                    <label for="email">' . esc_attr__( 'Email', THEME_NAME ) . '</label>
                    <input class="form-email" id="email" name="email" type="email" size="30" maxlength="200" placeholder="' . esc_attr__( 'Email', THEME_NAME ) . $req_sign . '" value="' . esc_attr( $commenter['comment_author_email'] ) . '" ' . $aria_req . '>
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                        <path d="M3.02878 8L8.48356 11.645C9.76421 12.4963 10.4045 12.9219 11.0964 13.0873C11.7078 13.2335 12.3451 13.2335 12.9565 13.0873C13.6483 12.9219 14.2887 12.4963 15.5693 11.645L20.9736 8.04005M7.8 19H16.2C17.8802 19 18.7202 19 19.362 18.673C19.9265 18.3854 20.3854 17.9265 20.673 17.362C21 16.7202 21 15.8802 21 14.2V9.8C21 8.11984 21 7.27976 20.673 6.63803C20.3854 6.07354 19.9265 5.6146 19.362 5.32698C18.7202 5 17.8802 5 16.2 5H7.8C6.11984 5 5.27976 5 4.63803 5.32698C4.07354 5.6146 3.6146 6.07354 3.32698 6.63803C3 7.27976 3 8.11984 3 9.8V14.2C3 15.8802 3 16.7202 3.32698 17.362C3.6146 17.9265 4.07354 18.3854 4.63803 18.673C5.27976 19 6.11984 19 7.8 19Z" stroke="#FED275" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div></div>',
				);

				$fields = apply_filters( 'comment_form_default_fields', $fields );

				$comments_args = array(
					'comment_field' => '<div class="comment-input-container full-width"><textarea id="comment" name="comment" rows="6" class="form-textarea" placeholder="' . esc_attr__( 'your text', THEME_NAME ) . '" required></textarea></div>',
					'fields' => $fields,
					'format' => 'xhtml',
					'class_form' => 'comment-form',
					'class_submit' => 'submit',
					'title_reply' => __( 'your', THEME_NAME ),
					'title_reply_before' => '<h2 id="reply-title" class="comment-reply-title"><span> '.__('reply', THEME_NAME) .'</span>',
					'title_reply_after' => '</h2>',
					'submit_button' => '<div class="comment-submit full-width"><input name="submit" type="submit" id="submit" class="submit" value="' . esc_attr__( 'Post Comment', THEME_NAME ) . '"></div>',
				);

                    
				?>
                    <div class="custom-form">
                        <?php comment_form( $comments_args ); ?>
                    </div>
                    <script>
                        document.addEventListener('DOMContentLoaded', function() {
                            var form = document.getElementById('commentform');
                            var loggedInAs = form.querySelector('.logged-in-as');
                            var formSubmit = form.querySelector('.form-submit');

                            if (!loggedInAs) {
                                formSubmit.style.display = 'none';
                            }
                            else{
                                form.style.display = 'block';
                            }
                        });
                    </script>
            <?php


        }
    }


}