<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_post_body extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_post_body';
    }

    public function get_title() {
        return esc_html__('post body', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_post_body';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }


    protected function register_style_section_1() {
        $this->start_controls_section(
            'post_style_section_h1',
            [
                'label' => esc_html__( 'h1', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('h1',  'h1');

        $this->end_controls_section();
    } 

    protected function register_style_section_2() {
        $this->start_controls_section(
            'post_style_section_h2',
            [
                'label' => esc_html__( 'h2', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('h2',  'h2');

        $this->end_controls_section();
    }
    
    protected function register_style_section_3() {
        $this->start_controls_section(
            'post_style_section_h3',
            [
                'label' => esc_html__( 'h3', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('h3',  'h3');

        $this->end_controls_section();
    }

    protected function register_style_section_4() {
        $this->start_controls_section(
            'post_style_section_h4',
            [
                'label' => esc_html__( 'h4', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('h4',  'h4');

        $this->end_controls_section();
    }

    protected function register_style_section_5() {
        $this->start_controls_section(
            'post_style_section_h5',
            [
                'label' => esc_html__( 'h5', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('h5',  'h5');

        $this->end_controls_section();
    }

    protected function register_style_section_6() {
        $this->start_controls_section(
            'post_style_section_h6',
            [
                'label' => esc_html__( 'h6', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('h6',  'h6');

        $this->end_controls_section();
    }

    protected function register_style_section_7() {
        $this->start_controls_section(
            'post_style_section_p',
            [
                'label' => esc_html__( 'p', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('p',  'p');

        $this->end_controls_section();
    }

    protected function register_style_section_8() {
        $this->start_controls_section(
            'post_style_section_link',
            [
                'label' => esc_html__( 'link', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('a',  'a', $align=false);

        $this->end_controls_section();
    }

    protected function register_style_section_9() {
        $this->start_controls_section(
            'post_style_section_ul',
            [
                'label' => esc_html__( 'ul', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_container_style('ul',  'ul');

        $this->end_controls_section();
    }

    protected function register_style_section_10() {
        $this->start_controls_section(
            'post_style_section_ul_li',
            [
                'label' => esc_html__( 'ul li', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('ul_li',  'ul li');

        $this->end_controls_section();
    }

    protected function register_style_section_11() {
        $this->start_controls_section(
            'post_style_section_ol',
            [
                'label' => esc_html__( 'ol', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_container_style('ol',  'ol');

        $this->end_controls_section();
    }

    protected function register_style_section_12() {
        $this->start_controls_section(
            'post_style_section_ol_li',
            [
                'label' => esc_html__( 'ol li', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('ol_li',  'ol li');
        $this->end_controls_section();
    }

    protected function register_style_section_13() {
        $this->start_controls_section(
            'post_style_section_strong',
            [
                'label' => esc_html__( 'strong', THEME_NAME , $align=false),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('strong',  'strong');

        $this->end_controls_section();
    }

    protected function register_style_section_14() {
        $this->start_controls_section(
            'post_style_section_em',
            [
                'label' => esc_html__( 'em', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('em',  'em', $align=false);

        $this->end_controls_section();
    }

    protected function register_style_section_15() {
        $this->start_controls_section(
            'post_style_section_blockquote',
            [
                'label' => esc_html__( 'blockquote', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('blockquote',  'blockquote');

        $this->end_controls_section();
    }

    protected function register_style_section_16() {
        $this->start_controls_section(
            'post_style_section_pre',
            [
                'label' => esc_html__( 'pre', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('pre',  'pre');

        $this->end_controls_section();
    }

    protected function register_style_section_17() {
        $this->start_controls_section(
            'post_style_section_code',
            [
                'label' => esc_html__( 'code', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('code',  'code' , $align=false);

        $this->end_controls_section();
    }

    protected function register_style_section_18() {
        $this->start_controls_section(
            'post_style_section_hr',
            [
                'label' => esc_html__( 'hr', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('hr',  'hr');

        $this->end_controls_section();
    }

    protected function register_style_section_19() {
        $this->start_controls_section(
            'post_style_section_img',
            [
                'label' => esc_html__( 'image', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_image_style('img',  'img');

        $this->end_controls_section();
    }

    protected function register_style_section_20() {
        $this->start_controls_section(
            'post_style_section_iframe',
            [
                'label' => esc_html__( 'iframe', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_image_style('iframe',  'iframe');

        $this->end_controls_section();
    }

    protected function register_style_section_21() {
        $this->start_controls_section(
            'post_style_section_audio',
            [
                'label' => esc_html__( 'audio', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_image_style('audio',  'audio');

        $this->end_controls_section();
    }

    protected function register_style_section_22() {
        $this->start_controls_section(
            'post_style_section_video',
            [
                'label' => esc_html__( 'video', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_image_style('video',  'video');

        $this->end_controls_section();
    }

    protected function register_style_section_23() {
        $this->start_controls_section(
            'post_style_section_table',
            [
                'label' => esc_html__( 'table', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_table_style('table',  'table');

        $this->end_controls_section();
    }

    protected function register_style_section_24() {
        $this->start_controls_section(
            'post_style_section_form',
            [
                'label' => esc_html__( 'form', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('form_lable',  'label', $align=false);
        $this->register_text_style('form_input',  'input');
        $this->register_text_style('form_btn',  'form button');

        $this->end_controls_section();
    }
    

    protected function register_controls() {

        $this->register_style_section_1();
        $this->register_style_section_2();
        $this->register_style_section_3();
        $this->register_style_section_4();
        $this->register_style_section_5();
        $this->register_style_section_6();
        $this->register_style_section_7();
        $this->register_style_section_8();
        $this->register_style_section_9();
        $this->register_style_section_10();
        $this->register_style_section_11();
        $this->register_style_section_12();
        $this->register_style_section_13();
        $this->register_style_section_14();
        $this->register_style_section_15();
        $this->register_style_section_16();
        $this->register_style_section_17();
        $this->register_style_section_18();
        $this->register_style_section_19();
        $this->register_style_section_20();
        $this->register_style_section_21();
        $this->register_style_section_22();
        $this->register_style_section_23();
        $this->register_style_section_24();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        if ($this->theme_is_edit_mode()) { 
            echo '<h1>' . esc_html__('Title h1', THEME_NAME) . '</h1>';
            echo '<h2>' . esc_html__('Title h2', THEME_NAME) . '</h2>';
            echo '<h3>' . esc_html__('Title h3', THEME_NAME) . '</h3>';
            echo '<h4>' . esc_html__('Title h4', THEME_NAME) . '</h4>';
            echo '<h5>' . esc_html__('Title h5', THEME_NAME) . '</h5>';
            echo '<h6>' . esc_html__('Title h6', THEME_NAME) . '</h6>';
            echo '<p>' . esc_html__('Paragraph', THEME_NAME) . '</p>';
            echo '<a href="#">' . esc_html__('Link', THEME_NAME) . '</a>';
            echo '<ul>';
            echo '<li>' . esc_html__('List item 1', THEME_NAME) . '</li>';
            echo '<li>' . esc_html__('List item 2', THEME_NAME) . '</li>';
            echo '</ul>';
            echo '<ol>';
            echo '<li>' . esc_html__('Ordered list item 1', THEME_NAME) . '</li>';
            echo '<li>' . esc_html__('Ordered list item 2', THEME_NAME) . '</li>';
            echo '</ol>';
            echo '<strong>' . esc_html__('Strong text', THEME_NAME) . '</strong>';
            echo '<em>' . esc_html__('Emphasized text', THEME_NAME) . '</em>';
            echo '<blockquote>' . esc_html__('Blockquote', THEME_NAME) . '</blockquote>';
            echo '<pre>' . esc_html__('Preformatted text', THEME_NAME) . '</pre>';
            echo '<code>' . esc_html__('Code block', THEME_NAME) . '</code>';
            echo '<hr>';
            echo '<img src="'.  \Elementor\Utils::get_placeholder_image_src() .'" alt="' . esc_html__('Image', THEME_NAME) . '">';
            echo '<iframe src="https://neshan.org/maps/@32.675051,51.654265,15z,0p/places/_bZD07exaQLT"></iframe>';
            echo '<audio controls><source src="https://example.com/audio.mp3" type="audio/mpeg"></audio>';
            echo '<video controls><source src="https://example.com/video.mp4" type="video/mp4"></video>';
            echo '<table><tr><th>' . esc_html__('Table Heading', THEME_NAME) . '</th><th>' . esc_html__('Table Heading', THEME_NAME) . '</th></tr><tr><td>' . esc_html__('Table Data', THEME_NAME) . '</td><td>' . esc_html__('Table Data', THEME_NAME) . '</td></tr></table>';
            echo '<form action="#"><label>'. esc_html__('label', THEME_NAME) .'</lable><input type="text" placeholder="Text Input"><button type="submit">' . esc_html__('Submit', THEME_NAME) . '</button></form>';
        } else {
            // Show current post body outside edit mode
            global $post;
            if ($post) {
                setup_postdata($post);
                the_content();
                wp_reset_postdata();
            }
        }

    }

}