<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_post_author extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_post_author';
    }

    public function get_title() {
        return esc_html__('post author', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_post_author';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }


    protected function register_style_section_1() {
        $this->start_controls_section(
            'post_style_section',
            [
                'label' => esc_html__( 'style', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('post_categories',  '.post-author a', $algin=false);

        $this->end_controls_section();

    } 

    protected function register_controls() {

        $this->register_style_section_1();
    }

    protected function render() {
        if ($this->theme_is_edit_mode()) {
            echo '<div class="post-author">';
            echo '<a href="#">'. __('admin', THEME_NAME).'</a>';
            echo '</div>';
        } else {
            global $post;
            $author_id = $post->post_author;
            $author_name = get_the_author_meta('display_name', $author_id);

            echo '<div class="post-author">';
            echo '<a href="' . esc_url(get_author_posts_url($author_id)) . '">' . esc_html($author_name) . '</a>';
            echo '</div>';
        }
    }

}