<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_modal extends \Elementor\Widget_Base {

    use basic_element;

    public function get_name() {
        return 'ar_modal';
    }

    public function get_title() {
        return esc_html__('show modal', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_modal';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

	protected function get_template() {
		$attributes = array();

		$post_type_name = 'theme-other';

		$args = array(
			'post_type' => $post_type_name,
			'posts_per_page' => -1, // Retrieve all posts of this post type
			'post_status' => 'publish',
		);

		$query = new WP_Query( $args );

		if ( $query->have_posts() ) {
			while ( $query->have_posts() ) {
				$query->the_post();
				$post_id = get_the_ID();
				$post_title = get_the_title();

				// Add post attributes to the array
				$attributes[ $post_id ] = esc_html( $post_title );
			}
			wp_reset_postdata(); // Restore global post data
		}

		return $attributes;
	}

	protected function register_content_section_1() {
		$this->start_controls_section(
			'post_style_section',
			[ 
				'label' => esc_html__( 'template', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'template_id',
			[ 
				'label' => esc_html__( 'template', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => $this->get_template(),
				'default' => 'post',
			]
		);

		$this->add_control(
			'label',
			[ 
				'label' => __( 'Label', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);

		$this->end_controls_section();

	}

	protected function register_style_section_1() {
        $this->start_controls_section(
            'button_style_section',
            [
                'label' => esc_html__( 'button', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

		$this->register_text_style( 'them-modal-button', '.them-modal-button', $align = false );

        $this->end_controls_section();

    }

	protected function register_style_section_2() {
		$this->start_controls_section(
			'theme-modal_style_section',
			[ 
				'label' => esc_html__( 'modal body', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_container_style( 'them-modal-button', '.theme-modal' );

		$this->end_controls_section();

	}

	protected function register_style_section_3() {
		$this->start_controls_section(
			'theme-modal-content_style_section',
			[ 
				'label' => esc_html__( 'modal body', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_container_style( 'them-modal-button-content', '.theme-modal-content' );

		$this->end_controls_section();

	}

	protected function register_style_section_4() {
		$this->start_controls_section(
			'close-btn_style_section',
			[ 
				'label' => esc_html__( 'close button', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_text_style( 'close-btn', '.close-btn' );

		$this->end_controls_section();

	}

	protected function register_controls() {

        $this->register_content_section_1();
		$this->register_style_section_1();
		$this->register_style_section_2();
		$this->register_style_section_3();
		$this->register_style_section_4();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
		$template = show_template( $settings['template_id'] );
		$element_id = intval($template);
		?>
		<button class="them-modal-button" id="<?php echo $element_id?>"><?php echo esc_attr( $settings['label'] ); ?></button>

		<div class="theme-modal" id="<?php echo $element_id ?>-Modal">
			<span class="close-btn">&times;</span>
			<div class="theme-modal-content">
				<?php
				echo ( $template );
				?>
			</div>
		</div>
		<script>
			jQuery(document).ready(function($) {
				const openModalBtn = document.getElementById('<?php echo $element_id ?>');
				const modal = document.getElementById('<?php echo $element_id ?>-Modal');
				const closeBtn = modal.querySelector('.close-btn');

				openModalBtn.addEventListener('click', function() {
					modal.classList.add('open');
				});

				closeBtn.addEventListener('click', function() {
					modal.classList.remove('open');
				});

				modal.addEventListener('click', function(event) {
					if (event.target === modal) {
						modal.classList.remove('open');
					}
				});
			});

		</script>
		<?php
    }

}