<?php



if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_menu extends \Elementor\Widget_Base {

    public function get_name() {
        return 'ar_menu';
    }

    public function get_title() {
        return esc_html__('menu', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_menu';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    private function get_menus(){
        $menus   = wp_get_nav_menus();
        $options = [];

        if (empty($menus)) {
            return $options;
        }

        foreach ($menus as $menu) {
            $options[$menu->term_id] = $menu->name;
        }

        return $options;
    }

    protected function register_content_section_1() {
        $this->start_controls_section(
            'section_settings',
            [
                'label' => esc_html__('settings', THEME_NAME),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'menu',
            [
                'label'       => esc_html__('Select Menu', THEME_NAME),
                'description' => sprintf(esc_html__('Go to the %s Menu screen %s to manage your menus.', THEME_NAME), '<a href="' . admin_url('nav-menus.php') . '" target="_blank">', '</a>'),
                'type'        => \Elementor\Controls_Manager::SELECT,
                'label_block' => false,
                'options'     =>  $this->get_menus(),
                'default'     => array_keys( $this->get_menus())[0],
            ]
        );

        $this->add_control(
            'menu_type',
            [
                'label' => esc_html__( 'Menu Type', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'horizontal',
                'options' => [
                    'horizontal'  => esc_html__( 'Horizontal', THEME_NAME ),
                    'vertical' => esc_html__( 'Vertical', THEME_NAME ),
                ],
            ]
        );

        $this->add_responsive_control(
            'H_menu_align', [
                'label' => esc_html__('Alignment', THEME_NAME),
                'condition' => ['menu_type' => 'horizontal'],
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'flex-end' => [
                        'title' => esc_html__('End', THEME_NAME),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', THEME_NAME),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'flex-start' => [
                        'title' => esc_html__('Start', THEME_NAME),
                        'icon' => 'eicon-text-align-left',
                    ],
                    
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .theme-header-nav' => 'justify-content: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function register_style_section_1() {
        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Style', THEME_NAME),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'menu_section',
            [
                'label' => esc_html__( 'main menu', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::HEADING,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'menu_typography',
                'label' => esc_html__( 'Typography', THEME_NAME ),
                'selector' => '{{WRAPPER}} .theme-header-nav > li.menu-item > a, {{WRAPPER}} .header-vertical-nav > li.menu-item > a',
            ]
        );
        
        $this->add_control(
            'menu_item_margin',
            [
                'label' => esc_html__('margin', THEME_NAME),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .menu-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );
        
        $this->add_control(
            'submenu_section',
            [
                'label' => esc_html__( 'Submenu', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'submenu_typography',
                'label' => esc_html__( 'Typography', THEME_NAME ),
                'selector' => '{{WRAPPER}} .theme-header-nav .sub-menu li.menu-item a, {{WRAPPER}} .header-vertical-nav .sub-menu li.menu-item a',
            ]
        );

        $this->add_control(
            'h_submenu_bg',
            [
                'label' => esc_html__('Background', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => ['menu_type' => 'horizontal'],
                'selectors' => [
                    '{{WRAPPER}} .theme-header-nav .sub-menu' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'h_submenu_radius',
            [
                'label' => esc_html__( 'Border Radius', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'condition' => ['menu_type' => 'horizontal'],
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .theme-header-nav .sub-menu' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'h_submenu_box_shadow',
                'label' => esc_html__( 'Box Shadow', THEME_NAME ),
                'condition' => ['menu_type' => 'horizontal'],
                'selector' => '{{WRAPPER}} .theme-header-nav .sub-menu',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'h_submenu_border',
                'label' => esc_html__( 'Border', THEME_NAME ),
                'condition' => ['menu_type' => 'horizontal'],
                'selector' => '{{WRAPPER}} .theme-header-nav .sub-menu',
            ]
        );

        $this->add_control(
            'color_section',
            [
                'label' => esc_html__( 'Color', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->start_controls_tabs('menu_color_tabs');
        # Normal State Tab
        $this->start_controls_tab(
            'menu_color_tab_normal_state',
            [
                'label' => esc_html__('Normal', THEME_NAME),
            ]
        );

        $this->add_control(
            'menu_color',
            [
                'label' => esc_html__('Item Color', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .theme-header-nav li.menu-item > a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .header-vertical-nav li.menu-item > a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'submenu_color',
            [
                'label' => esc_html__('Submenu Item Color', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .theme-header-nav .sub-menu li.menu-item > a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .header-vertical-nav .sub-menu li.menu-item > a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        # Hover State Tab
        $this->start_controls_tab(
            'menu_color_tab_hover_state',
            [
                'label' => esc_html__('Hover', THEME_NAME),
            ]
        );

        $this->add_control(
            'menu_color_hover',
            [
                'label' => esc_html__('Item Color', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .theme-header-nav li.menu-item > a:hover, {{WRAPPER}} .theme-header-nav li.current-menu-item > a, {{WRAPPER}} .theme-header-nav li.current-menu-ancestor > a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .header-vertical-nav li.menu-item > a:hover, {{WRAPPER}} .header-vertical-nav li.current-menu-item > a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'submenu_color_hover',
            [
                'label' => esc_html__('Submenu Item Color', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .theme-header-nav .sub-menu li.menu-item > a:hover, {{WRAPPER}} .theme-header-nav .sub-menu li.current-menu-item > a, {{WRAPPER}} .theme-header-nav .sub-menu li.current-menu-ancestor > a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .header-vertical-nav .sub-menu li.menu-item a:hover, {{WRAPPER}} .header-vertical-nav .sub-menu li.current-menu-item > a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'h_menu_hover_shape',
            [
                'label' => esc_html__( 'Hover Shape', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'condition' => ['menu_type' => 'horizontal'],
                'options' => [
                    'hover-style-1'  => esc_html__( 'Style 1', THEME_NAME ),
                    'hover-style-2'  => esc_html__( 'Style 2', THEME_NAME ),
                    'hover-style-3'  => esc_html__( 'Style 3', THEME_NAME ),
                    'hover-style-4'  => esc_html__( 'Style 4', THEME_NAME ),
                    'hover-style-5'  => esc_html__( 'Style 5', THEME_NAME ),
                ],
            ]
        );

        $this->add_control(
            'h_menu_hover_shape_color',
            [
                'label' => esc_html__('Hover Shape Color', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => ['menu_type' => 'horizontal'],
                'selectors' => [
                    '{{WRAPPER}} .theme-header-nav > li.menu-item > a::before' => 'background: {{VALUE}}',
					'{{WRAPPER}} .theme-header-nav-wrapper.hover-style-4 > ul > li.menu-item > a:hover, {{WRAPPER}} .theme-header-nav-wrapper.hover-style-4 > ul > li.current-menu-item > a, {{WRAPPER}} .theme-header-nav-wrapper.hover-style-4 > ul > li.current-menu-ancestor > a' => 'background: {{VALUE}}',
					'{{WRAPPER}} .theme-header-nav-wrapper.hover-style-6 > ul > li.menu-item > a:hover, {{WRAPPER}} .theme-header-nav-wrapper.hover-style-6 > ul > li.current-menu-item > a, {{WRAPPER}} .theme-header-nav-wrapper.hover-style-4 > ul > li.current-menu-ancestor > a' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_control(
            'icon_section',
            [
                'label' => esc_html__( 'icon', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'menu_icon_margin',
            [
                'label' => esc_html__('margin', THEME_NAME),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .menu-item span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function register_controls() {
        $this->register_content_section_1();

        $this->register_style_section_1();       
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        if( !empty($settings['menu']) ) {

            if( $settings['menu_type'] == 'vertical' ) { // Vertical Menu

                echo '<nav class="header-vertical-nav">';
                wp_nav_menu( array(
                    'menu' => $settings['menu'],
                    'link_before' => '<span>',
                    'link_after'=>'</span>',
                    'fallback_cb' => false,
                    'container' => false,
                ) );
                echo '</nav>';

            }
            else { // Horizontal Menu

                $hover_shape = !empty($settings['h_menu_hover_shape']) ? $settings['h_menu_hover_shape'] : '';

                echo '<nav class="theme-header-nav-wrapper ' . $hover_shape . '">';
                wp_nav_menu( array(
                    'menu' => $settings['menu'],
                    'link_before' => '<span>',
                    'link_after'=>'</span>',
                    'fallback_cb' => false,
                    'container' => false,
                    'menu_class' => 'theme-header-nav',
                ) );
                echo '</nav>';

            }
        }
    }


}