<?php

use handler\basic_element;

class ar_faqs extends \Elementor\Widget_Base {

	use basic_element;

	public function get_name() {
		return 'ar_faqs';
	}

	public function get_title() {
		return esc_html__( 'faqs', THEME_NAME );
	}

	public function get_icon() {
		return 'ar_faqs';
	}

	public function get_categories() {
        return ['core-elementor-elements'];
    }

	protected function register_content_section_1() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'questions', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
            'question',
            [
                'label' => __( 'question', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
            ]
        );

		$repeater->add_control(
            'answer',
            [
                'label' => __( 'answer', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
            ]
        );

		$this->add_control(
            'faq',
            [
                'label'       => esc_html__( 'questions', THEME_NAME ),
                'type'        => \Elementor\Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{ question }}}',
            ]
        );

		$this->end_controls_section();
	}

	protected function register_style_section_1() {
		$this->start_controls_section(
			'question_styles',
			[
				'label' => esc_html__( 'question', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->register_text_style('question',  '.faq .question');

		$this->end_controls_section();
	}

	protected function register_style_section_2() {
		$this->start_controls_section(
			'answers_styles',
			[
				'label' => esc_html__( 'answers', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->register_text_style('answers',  '.faq .answers');

		$this->end_controls_section();
	}

	protected function register_style_section_3() {
		$this->start_controls_section(
			'box_styles',
			[
				'label' => esc_html__( 'box', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->register_container_style('box',  '.faq-body');

		$this->end_controls_section();
	}

    protected function register_controls() {
		
		$this->register_content_section_1();

        $this->register_style_section_1();
        $this->register_style_section_2();
        $this->register_style_section_3();
	}


	protected function render() {
		$settings = $this->get_settings();
		$index = 0;
		if (empty($settings['faq'])) {
			return;
		}
		?>
		<div class="faq">
			<?php foreach ($settings['faq'] as $faq_item) : ?>
				<div class="faq-body">
					<input type="checkbox" id="question<?php echo esc_attr($index + 1); ?>" class="questions">
					<label for="question<?php echo esc_attr($index + 1); ?>" class="question">
						<?php echo esc_html($faq_item['question']); ?>
					</label>
					<div class="answers">
						<?php echo esc_html($faq_item['answer']); ?>
					</div>
				</div>
			<?php $index += 1;
			 endforeach; ?>
		</div>
		<?php
	}
}