<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_counter_down extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_counter_down';
    }

    public function get_title() {
        return esc_html__('counter down', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_counter_down';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_content_section_1() {
        $this->start_controls_section(
            'login_form_labels_section',
            [
                'label' => __( 'date', THEME_NAME ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,

            ]
        );

		$this->add_control(
			'event_date',
			[ 
				'label' => __( 'choose date', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::DATE_TIME,
			]
		);
        $this->end_controls_section();
    } 

    protected function register_style_section_1(){
		$this->start_controls_section(
			'cart_text',
			[ 
				'label' => esc_html__( 'text', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_text_style( 'card', '.card b' );

		$this->add_responsive_control(
			'text_align', [ 
				'label' => esc_html__( 'Alignment', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [ 
					'column' => [ 
						'title' => esc_html__( 'column', THEME_NAME ),
					],
					'column-reverse' => [ 
						'title' => esc_html__( 'column reverse', THEME_NAME ),
					],
					'row' => [ 
						'title' => esc_html__( 'row', THEME_NAME ),
					],
					'row-reverse' => [ 
						'title' => esc_html__( 'row reverse', THEME_NAME ),
					],
				],
				'default' => '',
				'selectors' => [ 
					'{{WRAPPER}} .flip-clock' => 'flex-direction: {{VALUE}};',
				],
			]
		);


		$this->end_controls_section();
    }

	protected function register_style_section_2() {
		$this->start_controls_section(
			'card__top',
			[ 
				'label' => esc_html__( 'card top', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_container_style( 'card__top', '.card__top' );

		$this->end_controls_section();
	}

	protected function register_style_section_3() {
		$this->start_controls_section(
			'card__bottom',
			[ 
				'label' => esc_html__( 'card bottom', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_container_style( 'card__bottom', '.card__bottom' );

		$this->end_controls_section();
	}

    protected function register_controls() {

        $this->register_content_section_1();
		$this->register_style_section_1();
		$this->register_style_section_2();
		$this->register_style_section_3();
	}
    
    protected function render() {
        $settings = $this->get_settings_for_display();
		$id = $this->get_id();
        ?>
        <div id="counter_down<?php echo $id ?>"></div>
        <script>

            function CountdownTracker(label, value){

                var el = document.createElement('span');

                el.className = 'flip-clock__piece';
                el.innerHTML = '<b class="flip-clock__card card"><b class="card__top"></b><b class="card__bottom"></b><b class="card__back"><b class="card__bottom"></b></b></b>';

                this.el = el;

                var top = el.querySelector('.card__top'),
                    bottom = el.querySelector('.card__bottom'),
                    back = el.querySelector('.card__back'),
                    backBottom = el.querySelector('.card__back .card__bottom');

                this.update = function(val){
                    val = ( '0' + val ).slice(-2);
                    if ( val !== this.currentValue ) {
                    
                    if ( this.currentValue >= 0 ) {
                        back.setAttribute('data-value', this.currentValue);
                        bottom.setAttribute('data-value', this.currentValue);
                    }
                    this.currentValue = val;
                    top.innerText = this.currentValue;
                    backBottom.setAttribute('data-value', this.currentValue);

                    this.el.classList.remove('flip');
                    void this.el.offsetWidth;
                    this.el.classList.add('flip');
                    }
                }
                
                this.update(value);
            }

            function getTimeRemaining(endtime) {
                var t = Date.parse(endtime) - Date.parse(new Date());
                return {
                    'Total': t,
                    'Days': Math.floor(t / (1000 * 60 * 60 * 24)),
                    'Hours': Math.floor((t / (1000 * 60 * 60)) % 24),
                    'Minutes': Math.floor((t / 1000 / 60) % 60),
                    'Seconds': Math.floor((t / 1000) % 60)
                };
            }

            function getTime() {
                var t = new Date();
                return {
                    'Total': t,
                    'Hours': t.getHours() % 12,
                    'Minutes': t.getMinutes(),
                    'Seconds': t.getSeconds()
                };
            }

            function Clock(countdown,callback) {
            
                countdown = countdown ? new Date(Date.parse(countdown)) : false;
                callback = callback || function(){};
                
                var updateFn = countdown ? getTimeRemaining : getTime;

                this.el = document.createElement('div');
                this.el.className = 'flip-clock';

                var trackers = {},
                    t = updateFn(countdown),
                    key, timeinterval;

                for ( key in t ){
                    if ( key === 'Total' ) { continue; }
                    trackers[key] = new CountdownTracker(key, t[key]);
                    this.el.appendChild(trackers[key].el);
                }

                var i = 0;
                function updateClock() {
                    timeinterval = requestAnimationFrame(updateClock);
                    
                    // throttle so it's not constantly updating the time.
                    if ( i++ % 10 ) { return; }
                    
                    var t = updateFn(countdown);
                    if ( t.Total < 0 ) {
                    cancelAnimationFrame(timeinterval);
                    for ( key in trackers ){
                        trackers[key].update( 0 );
                    }
                    callback();
                    return;
                    }
                    
                    for ( key in trackers ){
                    trackers[key].update( t[key] );
                    }
                }

                setTimeout(updateClock,500);
            }

            var deadline<?php echo $id ?> = new Date("<?php echo esc_html( $settings['event_date'] ); ?>");
            var counter_down_body<?php echo $id ?> = document.getElementById('counter_down<?php echo $id ?>');
            var c<?php echo $id ?> = new Clock(deadline<?php echo $id ?>, function(){});
            counter_down_body<?php echo $id ?>.appendChild(c<?php echo $id ?>.el);

        </script>
        <?php
    }

}