<?php
namespace handler;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) { exit; } 


trait Post_skin_base {

    protected function render_date() {
        $settings = $this->get_settings_for_display();
        if (!$settings['show_date']) {
            return;
        }
        ?>
        <div class="date">
            <i class="ri-calendar-line"></i>
            <?php if ($settings['human_diff_time'] == 'yes') {
                printf( esc_html__( '%s ago', THEME_NAME ), human_time_diff( get_the_time('U'), current_time('timestamp') ) );
            } else {
				echo convert_date( get_the_date(), 'j F Y' );
            } ?>
        </div>

        <?php if ($settings['show_time']) : ?>
            <div class="time">
                <i class="isax isax-clock"></i>
                <?php echo get_the_time(); ?>
            </div>
        <?php endif; ?>
        <?php
    }

    protected function render_terms() {
        $settings = $this->get_settings_for_display();
        if (!$settings['show_terms'] || !$settings['terms_taxonomy']) {
            return;
        }
        $terms = get_the_terms( get_the_ID(), $settings['terms_taxonomy'] );
        if(!empty($terms)) {
            echo '<div class="terms-wrapper">';

            $term_limit = max(1, $settings['term_limit']);
            $i = 0;

            foreach ($terms as $term) {
                if($i >= $term_limit) break; $i++;
                $bg = '';
                if($settings['term_multi_background']) {
                    $term_bg = get_term_meta($term->term_id, 'theme_term_color', true);
                    if($term_bg) {
                        $bg = 'style="background-color: ' . esc_html($term_bg) . '"';
                    }
                }
                echo '<a class="term-item" href="' . esc_url(get_term_link($term->term_id)) . '" ' . $bg . '>' . esc_html($term->name) . '</a>';
            }

            echo '</div>';
        }

    }

    protected function render_title() {
        $settings = $this->get_settings_for_display();
        ?>
        <<?php echo esc_attr($settings['title_tag']); ?> class="title">
        <a href="<?php echo esc_url(get_permalink()) ?>" class="title-animation-<?php echo esc_attr($settings['title_hover_style']); ?>" title="<?php echo esc_html(get_the_title()) ?>">
            <?php echo get_the_title();  ?>
        </a>
        </<?php echo esc_attr($settings['title_tag']); ?>>
        <?php
    }

    protected function render_excerpt() {
        $settings = $this->get_settings_for_display();
        if (!$settings['show_excerpt']) {
            return;
        }
        $excerpt = get_the_excerpt();
        if ($excerpt) {
            $excerpt = wp_strip_all_tags($excerpt);
            $excerpt = substr($excerpt, 0, absint($settings['excerpt_length']));
            $result = substr($excerpt, 0, strrpos($excerpt, ' '));
            $result .= '...';
            echo '<p class="excerpt">' . $result . '</p>';
        }
    }

    protected function render_read_more() {
        $settings = $this->get_settings_for_display();
        if (!$settings['show_read_more']) {
            return;
        }

        $read_more_text = $settings['read_more_text'];

		$btn_cls = "theme-read-more style-" . $settings['read_more_style'];
        if($settings['read_more_icon'] != 'none') {
			$btn_cls .= " icon-" . $settings['read_more_icon_position'];
        }

        if($settings['read_more_style'] == '1') {
			$btn_cls .= " shape-" . $settings['read_more_shape_position'];
        }			
		
        ?>
        <div class="theme-read-more-wrapper">
            <a href="<?php the_permalink(); ?>" class="<?php echo esc_attr($btn_cls); ?>">
                <span class="read-more-title"><?php echo esc_html($read_more_text); ?></span>
                <?php if($settings['read_more_icon'] != 'none'): ?>
                    <i class="<?php echo esc_attr($settings['read_more_icon']); ?>"></i>
                <?php endif; ?>
            </a>
        </div>
        <?php

    }

    protected function render_post_format_icon() {
        $settings = $this->get_settings_for_display();

        $post_format = get_post_format() ? : 'standard';
        switch ($post_format) {
            case 'gallery':
                $post_format_icon = 'isax isax-picture-frame';
                break;
            case 'video':
                $post_format_icon = 'isax isax-video';
                break;
            case 'audio':
                $post_format_icon = 'isax isax-voice-square';
                break;
            case 'link':
                $post_format_icon = 'isax isax-link';
                break;
            case 'quote':
                $post_format_icon = 'isax isax-quote-up';
                break;
            default:
                $post_format_icon = 'isax isax-document-text';
        }
        if($settings['show_post_format_icon']){

        ?>
        <div class="post-format-icon theme-position-<?php echo esc_html($settings['post_format_icon_position']) ?>">
            <i class="<?php echo esc_html($post_format_icon) ?>"></i>
        </div>
        <?php
        }
    }
}

