
    const cacheName = 'brand-man-v1';
    const staticAssets = [
        '/',
        '/wp-content/themes/brand-man/assets/css/bootstrap.css',
        '/wp-content/themes/brand-man/assets/css/main.css',
        '/wp-content/themes/brand-man/elementor/assets/css/main.css',
        '/wp-content/themes/brand-man/assets/js/main.js',
        '/wp-content/themes/brand-man/assets/js/swiper.js',
    ];

    self.addEventListener('install', async (event) => {
        const cache = await caches.open(cacheName);
        await cache.addAll(staticAssets);
    });

    self.addEventListener('activate', (event) => {
        event.waitUntil(
            caches.keys().then((cacheNames) => {
                return Promise.all(
                    cacheNames.filter((name) => {
                        return name !== cacheName;
                    }).map((name) => {
                        return caches.delete(name);
                    })
                );
            })
        );
    } );

    self.addEventListener('fetch', (event) => {
        const req = event.request;
        event.respondWith(cacheFirst(req));
    });

    async function cacheFirst(req) {
        const cache = await caches.open(cacheName);
        const cachedResponse = await cache.match(req);
        return cachedResponse || fetch(req);
    }
        