<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 8.6.0
 */

$template_id = option_value( 'page-shop-product-template' );
if ( function_exists( 'is_product_category' ) && is_product_category() ) {
	$current_category = get_queried_object();
	$template_id_category = get_term_meta( $current_category->term_id, 'category-archive', true );

	if ( ! empty( $template_id_category ) && $template_id_category !== '0' ) {
		$template_id = $template_id_category;
	}
}

get_header( 'shop' );
if ( $template_id ) {
	$sidebar_position = option_value( 'woocommerce-archive-sidebar-position' );
	$sidebar_sticky = option_value( 'woocommerce-archive-sticky-sidebar' );
	if ( empty( $sidebar_position ) ) {
		$sidebar_position = intval( option_value( 'general-sidebar-template' ) );
	}
	// Check Sidebar For Content
	if ( in_array( $sidebar_position, [ 'left', 'right' ] ) ) {
		$sidebar_template_id = get_layout( 'sidebar' );
		if ( ! $sidebar_template_id ) {
			$sidebar_position = 'none';
		}
	}

	?>
	<main class="main-wrapper">
		<div class="content-wrapper">
			<?php
			get_template_part( "template-parts/archive/archive-title" );
			$template = show_template( $template_id );
			if ( $template && $sidebar_position == 'none' ) {
				echo ( $template );
			} else {
				?>
				<div class="container">
					<div class="page-content-wrapper <?php echo 'sidebar-' . $sidebar_position; ?>">
						<div class="content-container archive-content-container">
							<?php
							if ( $template ) {
								echo ( $template );
							} else {
								get_template_part( "template-parts/archive/archive-default" );
							}
							?>
						</div>
						<?php
						$template_id = option_value( 'archive-bottom-content-template' );
						$template = show_template( $template_id );
						if ( $template_id ) {
							echo $template;
						}

						if ( $sidebar_position == 'left' || $sidebar_position == 'right' ) : ?>
							<aside class="sidebar-container <?php if ( $sidebar_sticky )
								echo 'sticky'; ?>">
								<?php get_sidebar(); ?>
							</aside>
						<?php endif; ?>
					</div>
				</div>
				<?php
			}

			?>
		</div>
	</main>
	<?php

} else {
	/**
	 * Hook: woocommerce_before_main_content.
	 *
	 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
	 * @hooked woocommerce_breadcrumb - 20
	 * @hooked WC_Structured_Data::generate_website_data() - 30
	 */
	do_action( 'woocommerce_before_main_content' );

	/**
	 * Hook: woocommerce_shop_loop_header.
	 *
	 * @since 8.6.0
	 *
	 * @hooked woocommerce_product_taxonomy_archive_header - 10
	 */
	do_action( 'woocommerce_shop_loop_header' );

	if ( woocommerce_product_loop() ) {

		/**
		 * Hook: woocommerce_before_shop_loop.
		 *
		 * @hooked woocommerce_output_all_notices - 10
		 * @hooked woocommerce_result_count - 20
		 * @hooked woocommerce_catalog_ordering - 30
		 */
		do_action( 'woocommerce_before_shop_loop' );

		woocommerce_product_loop_start();

		if ( wc_get_loop_prop( 'total' ) ) {
			while ( have_posts() ) {
				the_post();

				/**
				 * Hook: woocommerce_shop_loop.
				 */
				do_action( 'woocommerce_shop_loop' );

				wc_get_template_part( 'content', 'product' );
			}
		}

		woocommerce_product_loop_end();

		/**
		 * Hook: woocommerce_after_shop_loop.
		 *
		 * @hooked woocommerce_pagination - 10
		 */
		do_action( 'woocommerce_after_shop_loop' );
	} else {
		/**
		 * Hook: woocommerce_no_products_found.
		 *
		 * @hooked wc_no_products_found - 10
		 */
		do_action( 'woocommerce_no_products_found' );
	}

	/**
	 * Hook: woocommerce_after_main_content.
	 *
	 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
	 */
	do_action( 'woocommerce_after_main_content' );

	/**
	 * Hook: woocommerce_sidebar.
	 *
	 * @hooked woocommerce_get_sidebar - 10
	 */
	do_action( 'woocommerce_sidebar' );
}
get_footer( 'shop' );
?>