<?php

Redux::set_section( $opt_name, array(
    'title'            => esc_html__('Performance', THEME_NAME),
    'id'               => 'performance_section',
    'desc'             => esc_html__('Performance settings', THEME_NAME),
    'subsection'       => false,
    'icon'             => 'isax isax-speedometer',
    'fields'           => array(
        array(
            'id'       => 'disable-elementor-google-font',
            'type'     => 'switch',
            'title'    => esc_html__('Disable Load Elementor Google Font', THEME_NAME),
            'desc'     => esc_html__('If you don\'t use google fonts from the elementor, enable this option to prevent loading unused google fonts.', THEME_NAME),
        ),

        array(
            'id'       => 'minify-css',
            'type'     => 'switch',
            'title'    => esc_html__('minify custom css', THEME_NAME),
        ),

		array(
			'id' => 'merge-css',
			'type' => 'switch',
			'title' => esc_html__( 'merge css', THEME_NAME ),
		),

        array(
            'id'       => 'disable-emojis',
            'type'     => 'switch',
            'title'    => esc_html__('Disable Emojis', THEME_NAME),
            'desc'     => esc_html__('If you don\'t use emojis, enable this option to disable emojis.', THEME_NAME),
        ),

		array(
			'id' => 'jdatetime',
			'type' => 'switch',
			'title' => esc_html__( 'enable jalali date', THEME_NAME ),
			'desc' => esc_html__( 'If you want to use jalali date anable this', THEME_NAME ),
		),

        array(
            'id'       => 'disable-extendify',
            'type'     => 'switch',
            'title'    => esc_html__('Disable Extendify Gutenberg Assets', THEME_NAME),
            'desc'     => esc_html__('If you don\'t use Extendify templates in gutenberg (from Redux Framework), enable this option to disable its assets.', THEME_NAME),
        ),

        array(
            'id'       => 'disable-woocommerce-assets-out-of-shop',
            'type'     => 'switch',
            'title'    => esc_html__('Disable Woocommerce Assets out Of Shop', THEME_NAME),
            'desc'     => esc_html__('By default woocommerce css/js load on entire site. Enable this option to load them just on woocommerce pages.', THEME_NAME),
        ),

        array(
            'id'       => 'disable-woocommerce-blocks-assets',
            'type'     => 'switch',
            'title'    => esc_html__('Disable Woocommerce Blocks Assets', THEME_NAME),
            'desc'     => esc_html__('Disable Woocommerce gutenberg blocks assets.', THEME_NAME),
        ),

        array(
            'id'       => 'disable-gutenberg-assets',
            'type'     => 'switch',
            'title'    => esc_html__('Disable Gutenberg Assets Out of Posts', THEME_NAME),
            'desc'     => esc_html__('By default gutenberg css load on entire site. Enable this option to disable load them from homepage, category & tag archives and pages build with Elementor.', THEME_NAME),
        ),

        array(
            'id'       => 'disable-jquery-migrate',
            'type'     => 'switch',
            'title'    => esc_html__('Disable Jquery Migrate', THEME_NAME),
            'desc'     => esc_html__('By default Wordpress load Jquery Migrate. Enable this option to disable load it.', THEME_NAME),
        ),

        array(
            'id'      => 'disable-xmlrpc',
            'type'    => 'switch',
            'title'   => esc_html__('Disable XML-RPC + Pingback', THEME_NAME),
            'desc'    => esc_html__('Disable support for third-party application access.', THEME_NAME),
        ),

        array(
            'id'      => 'disable-rsdlink',
            'type'    => 'switch',
            'title'   => esc_html__('Disable RSD', THEME_NAME),
            'desc'    => esc_html__('Disable the Really Simple Discovery (RSD) tag. If you edit your site from your browser then you do not need it.', THEME_NAME),
        ),

        array(
            'id'      => 'disable-shortlink',
            'type'    => 'switch',
            'title'   => esc_html__('Disable Short Link', THEME_NAME),
            'desc'    => esc_html__('Disable the Short Link from the head.', THEME_NAME),
        ),

        array(
            'id'      => 'disable-rssfeeds',
            'type'    => 'switch',
            'title'   => esc_html__('Disable RSS Feeds', THEME_NAME),
            'desc'    => esc_html__('Disable the RSS feed links and disable it.', THEME_NAME),
        ),

        array(
            'id'      => 'disable-generator-tag',
            'type'    => 'switch',
            'title'   => esc_html__('Disable Generator Tag', THEME_NAME),
            'desc'    => esc_html__('Disable the generator tag.', THEME_NAME),
        ),
    )
) );