<?php

$tags = theme_title_tag();
$typography_fields = array();

$typography_fields[] = array(
    'id'             => 'typography-custom-fonts',
    'type'           => 'custom_fonts',
    'title'          => esc_html__('Custom Fonts', THEME_NAME),
    'section_id'     => 'typography',
    'subsection'     => false, 
);

foreach ($tags as $tag => $tag_name) {
    $typography_fields[] = array(
        'id'          => "typography-$tag_name",
        'type'        => 'typography',
        'all_styles'  => true,
        'google'      => false,
        'line-height' => false,
        'title'       => esc_html__("$tag_name", THEME_NAME),
    );
}

Redux::set_section( $opt_name, array(
    'title'          => esc_html__('Typography', THEME_NAME),
    'id'             => 'typography',
    'desc'           => esc_html__('Typography settings', THEME_NAME),
    'subsection'     => false,
    'icon'           => 'isax isax-document-text',
    'fields'         => $typography_fields,
) );