<?php

$post_type_fields = array();

$post_type_fields[] = array(
    'id'       => 'site-footer',
    'type'     => 'select',
    'title'    => esc_html__('default Site Footer', THEME_NAME),
    'subtitle' => esc_html__('Select default footer for the site.', THEME_NAME),
    'data'     => 'callback',
    'args'     => 'get_all_footer_template',
    'desc'     => sprintf(esc_html__('create your template in %1$s footer Templates %2$s', THEME_NAME), '<a target="_blank" href="' . admin_url("edit.php?post_type=theme-footer") . '"><b>', '</b></a>'),
    'default'  => '0',
    'select2'  => array( 'allowClear' => false ),
);

$post_type_fields[] = array(
    'id'       => 'scroll-up',
    'type'     => 'switch',
    'title'    => esc_html__('Back to Top Button', THEME_NAME),
    'subtitle' => esc_html__('Enable or disable back to top button.', THEME_NAME),
    'desc'     => '',
    'default'  => false,
);

$post_type_fields[] = array(
    'id'          => 'scroll-up-style',
    'type'        => 'select',
    'required'    => array('scroll-up', '=', '1' ),
    'title'       => esc_html__('Back to Top Button Style', THEME_NAME),
    'desc'        => '',
    'default'     => 'isax-arrow-square-up',
    'options'     => array(
        'isax-arrow-square-up'  => __('style 1', THEME_NAME),
        'isax-arrow-up-1'       => __('style 2', THEME_NAME),
        'isax-arrow-circle-up'  => __('style 3', THEME_NAME),
        'isax-arrow-up-2'       => __('style 4', THEME_NAME),
        'isax-arrow-up-3'       => __('style 5', THEME_NAME),
        'isax-direct-up'        => __('style 6', THEME_NAME),
		'isax-arrow-up-14'      => __('style 7', THEME_NAME),
    ),
);


$post_type_fields[] = array(
    'id'          => 'scroll-up-bg',
    'type'        => 'color',
    'required'    => array('scroll-up', '=', '1' ),
    'transparent' => false,
    'title'       => esc_html__('Back to Top Button Background', THEME_NAME),
    'desc'        => '',
    'default'     => '',
    'validate'    => 'color',
);

$post_type_fields[] = array(
    'id'          => 'scroll-up-icon-color',
    'type'        => 'color',
    'required'    => array('scroll-up', '=', '1' ),
    'transparent' => false,
    'title'       => esc_html__('Back to Top Button icon color', THEME_NAME),
    'desc'        => '',
    'default'     => '',
    'validate'    => 'color',
);

$post_type_fields[] = array(
    'id'          => 'scroll-up-position',
    'type'        => 'select',
    'required'    => array('scroll-up', '=', '1' ),
    'title'       => esc_html__('Back to Top position', THEME_NAME),
    'desc'        => '',
    'default'     => 'left',
    'options'     => array(
        'left'      => esc_html__('left', THEME_NAME),
        'right'     => esc_html__('right', THEME_NAME),
    ),
);

$post_type_fields[] = array(
    'id'          => 'scroll-up-margin',
    'type'        => 'spinner',
    'title'       => esc_html__('Back to Top Button Margin', THEME_NAME),
    'desc'        => esc_html__('Enter the margin for the back to top button.', THEME_NAME),
    'default'     => '30',
    'validate'    => 'numeric',
    'step'        => '1',
    'min'         => '0',
    'max'         => '100',
);

$post_types_theme = theme_post_type();
foreach ($post_types_theme as $post_type) {
	if ( $post_type['name'] ) {

		$post_type_fields[] = array(
			'id' => 'subtitle-footer-' . $post_type['name'],
			'type' => 'raw',
			'full_width' => true,
			'content' => '<h4>' . sprintf( esc_html__( '%1$s footer', THEME_NAME ), $post_type['title'] ) . '</h4>',
		);

		$post_type_fields[] = array(
			'id' => $post_type['name'] . '-archive-footer',
			'type' => 'select',
			'title' => sprintf( esc_html__( '%1$s footer archive', THEME_NAME ), $post_type['title'] ),
			'data' => 'callback',
			'args' => 'get_all_footer_template',
			'desc' => sprintf( esc_html__( 'create your template in %1$s footer Templates %2$s', THEME_NAME ), '<a target="_blank" href="' . admin_url( "edit.php?post_type=theme-footer" ) . '"><b>', '</b></a>' ),
			'default' => '0',
			'select2' => array( 'allowClear' => false ),
		);


		$post_type_fields[] = array(
			'id' => $post_type['name'] . '-footer',
			'type' => 'select',
			'title' => sprintf( esc_html__( '%1$s footer', THEME_NAME ), $post_type['title'] ),
			'data' => 'callback',
			'args' => 'get_all_footer_template',
			'desc' => sprintf( esc_html__( 'create your template in %1$s footer Templates %2$s', THEME_NAME ), '<a target="_blank" href="' . admin_url( "edit.php?post_type=theme-footer" ) . '"><b>', '</b></a>' ),
			'default' => '0',
			'select2' => array( 'allowClear' => false ),
		);
	}
}

$post_types = get_post_types(array('public' => true,), 'objects');
$excluded_post_types = array('attachment', 'elementor_library', 'e-landing-page');

// Filter out excluded post types
foreach ($excluded_post_types as $exclude_type) {
    if (isset($post_types[$exclude_type])) {
        unset($post_types[$exclude_type]);
    }
}

foreach ($post_types as $post_type) {

    $post_type_fields[] = array(
        'id'         => 'subtitle-footer-'. $post_type->name,
        'type'       => 'raw',
        'full_width' => true,
        'content'    => '<h4>' . sprintf(esc_html__('%1$s footer', THEME_NAME), $post_type->labels->name) . '</h4>',
    );
    if($post_type->name != 'page'){ 
        $post_type_fields[] = array(
            'id'       => $post_type->name .'-archive-footer',
            'type'     => 'select',
            'title'    => sprintf(esc_html__('%1$s footer archive', THEME_NAME), $post_type->labels->name),
            'data'     => 'callback',
            'args'     => 'get_all_footer_template',
            'desc'     => sprintf(esc_html__('create your template in %1$s footer Templates %2$s', THEME_NAME), '<a target="_blank" href="' . admin_url("edit.php?post_type=theme-footer") . '"><b>', '</b></a>'),
            'default'  => '0',
            'select2'  => array( 'allowClear' => false ),
        );
    }


    $post_type_fields[] = array(
        'id'       => $post_type->name .'-footer',
        'type'     => 'select',
        'title'    => sprintf(esc_html__('%1$s footer', THEME_NAME), $post_type->labels->name),
        'data'     => 'callback',
        'args'     => 'get_all_footer_template',
        'desc'     => sprintf(esc_html__('create your template in %1$s footer Templates %2$s', THEME_NAME), '<a target="_blank" href="' . admin_url("edit.php?post_type=theme-footer") . '"><b>', '</b></a>'),
        'default'  => '0',
        'select2'  => array( 'allowClear' => false ),
    );
}

Redux::set_section( $opt_name, array(
    'title'        =>  esc_html__('Footer', THEME_NAME),
    'id'           => 'footer_section',
    'desc'         =>  esc_html__('General settings for footer', THEME_NAME),
    'icon'         => 'isax isax-sidebar-bottom',
    'fields'       => $post_type_fields,
) );