<?php

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

class theme_Admin_Setup {

    function __construct() {

        add_action( 'enqueue_block_editor_assets', array( $this, 'editor_scripts' ), 90 );
        add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ) );
        add_filter( 'ocdi/plugin_intro_text', array( $this, 'ocdi_plugin_intro_text') );
		add_filter( 'ocdi/register_plugins', array( $this, 'ocdi_register_plugins' ) );
        add_filter( 'ocdi/import_files', array( $this, 'import_demo_config' ) );
		add_filter( 'upload_mimes', array( $this, 'add_fonts_to_allowed_mimes' ) );
		add_action( 'init', array( $this, 'get_admin_custom_style' ) );
        add_action( 'redux/options/theme_settings/saved', array( $this, 'get_admin_custom_style') );
		// add_action( 'redux/options/theme_settings/saved', array( $this, 'load_color_in_elementor' ) );
		// add_action( 'redux/construct', array( $this, 'update_font_in_redux_after_elementor_save' ) );
    }

	function update_font_in_redux_after_elementor_save() {
		$file_path = WP_CONTENT_DIR . '/uploads/elementor/css/post-6152.css';
		if ( file_exists( $file_path ) ) {
			$css_content = file_get_contents( $file_path );

			// Get the theme colors
			$theme_colors = theme_colors();

			// Parse the CSS to get current color values
			preg_match_all( '/--e-global-color-([\w-]+):\s*#([\dA-Fa-f]{6});/', $css_content, $matches, PREG_SET_ORDER );

			// Create an associative array of current colors in the CSS
			$current_colors = [];
			foreach ( $matches as $match ) {
				$current_colors[ $match[1] ] = '#' . $match[2];
			}

			// Compare and update Redux options
			foreach ( $theme_colors as $key => $color ) {
				$color_id = str_replace( 'theme-', '', $color['id'] );
				if ( isset( $current_colors[ $color_id ] ) && $current_colors[ $color_id ] !== $color['value'] ) {
                    Redux::setOption( 'theme_settings', $key, $current_colors[ $color_id ] );
				}
                else{
					Redux::setOption( 'theme_settings', $key, $color['value'] );
                }
			}
		}
	}
	function load_color_in_elementor() {
		$file_path = WP_CONTENT_DIR . '/uploads/elementor/css/post-6152.css';
		// if ( ! file_exists( $file_path ) ) {
		// 	// Handle the case where the file does not exist
		// 	return;
		// }
		$post_id = 6;
		$meta_key = '_elementor_page_settings';

		// Get the existing meta value
		$meta_value = get_post_meta( $post_id, '_elementor_page_settings', true );
        
        // Ensure the meta_value is an array
        if ( is_string( $meta_value ) ) {
            $meta_value = maybe_unserialize( $meta_value );
        }
        
        if ( ! is_array( $meta_value ) || ! isset( $meta_value['custom_colors'] ) ) {
            return;
        }

		$theme_default_colors = theme_defualt_colors();
		$new_colors = theme_colors();

		foreach ( $new_colors as $color_key => $color ) {
			// Check if the color value is not set
			if ( empty( $color['value'] ) ) {
				// Get the default value from theme_default_colors array
				$default_color_value = $theme_default_colors[ $color_key ]['value'];
				// Set the default value to the color
				$new_colors[ $color_key ]['value'] = $default_color_value;
			}
		}

        $custom_colors = $meta_value['custom_colors'];
        $max_index = -1;
        foreach ( $custom_colors as $index => $color ) {
            if ( $index > $max_index ) {
                $max_index = $index;
            }
        }
		
		$css_content = file_get_contents( $file_path );

		// Remove lines related to $new_colors
		foreach ( $new_colors as $color ) {
			$pattern = '/^\s*--e-global-color-' . $color['id'] . ':.*?;\s*$/m';
			$css_content = preg_replace( $pattern, '', $css_content );
		}

		// Save the modified CSS file content
		file_put_contents( $file_path, $css_content );

		// Remove entries from 'custom_colors'
		$meta_value['custom_colors'] = array_filter( $meta_value['custom_colors'], function ($existing_color) use ($new_colors) {
			foreach ( $new_colors as $color ) {
				if ( $existing_color['color'] === $color['value'] || $existing_color['_id'] === $color['id'] ) {
					return false;
				}
			}
			return true;
		} );

		// Update the post meta
		update_post_meta( 6, '_elementor_page_settings', $meta_value );

		// Read the content of post-6.css
        $file_path = WP_CONTENT_DIR . '/uploads/elementor/css/post-6152.css';
        $css_content = file_get_contents( $file_path );
		$new_css_content = '';
        // Find the last --e-global-color- variable
        preg_match_all( '/--e-global-color-(\S+): #(\S+)/', $css_content, $matches );
        $last_variable = end( $matches[0] );
		// Append new colors to the custom_colors array with unique _id
		$custom_colors = $meta_value['custom_colors'];

		foreach ( $new_colors as $key => $color ) {
            $max_index++;
			$color_exists = false;
			foreach ( $custom_colors as $existing_color ) {
				if ( $existing_color['color'] === $color['value'] ) {
                    $color_exists = true;
					break;
				}
			}

			if ( ! $color_exists ) {
                $custom_colors[ $max_index ] = array(
                    '_id' => $color['id'],
					'title' => $color['name'],
					'color' => $color['value'],
				);
				$unique_id = $color['id'];
				$new_css_content .= "\n--e-global-color-$unique_id: {$color['value']};\n";
			}
        }
		$new_css_content = $last_variable . $new_css_content;
		$css_content = str_replace( $last_variable, $new_css_content, $css_content );
		// var_dump( $new_colors );

		file_put_contents( $file_path, $css_content );
        $meta_value['custom_colors'] = $custom_colors;
		// var_dump( $meta_value );
        update_post_meta( $post_id, $meta_key, ( $meta_value ) ); // Replace '_your_meta_key' with the actual meta key
    }
	// Load Gutenberg assets
	function editor_scripts( $hook ) {
		wp_enqueue_style( 'theme-editor-style', THEME_URL . '/admin/assets/css/editor.css', array(), null );
		wp_add_inline_style( 'theme-editor-style', $this->get_gutenberg_custom_style() );
	}

    // Load admin assets in pages we need
    function admin_scripts($hook) {
        wp_enqueue_style( 'iconsax', THEME_URL . '/elementor/assets/css/iconsax.css', array(), false );
        wp_enqueue_style( 'theme-admin-style', THEME_URL . '/admin/assets/css/editor.css', array(), null);
        wp_enqueue_style( 'custom-admin-style', THEME_URL . '/admin/assets/css/custom-admin-style.css', array(), null);
    }

    // Admin custom style
    function get_admin_custom_style () {
		$custom_css = '';
        include_once THEME_DIR . '/admin/assets/css/custom-admin-style.php';
        $css_file_path = get_stylesheet_directory() . '/admin/assets/css/custom-admin-style.css';

        // Check if the CSS file exists
        if (file_exists($css_file_path)) {
            // Delete the CSS file
            unlink($css_file_path);
        }
        // Write custom CSS content to the file
        file_put_contents($css_file_path, $custom_css);

        $custom_css = '';
        include_once THEME_DIR . '/admin/assets/css/custom-elementor-style.php';
        $css_file_path = get_stylesheet_directory() . '/elementor/assets/css/admin/custom-elementor-style.css';

        // Check if the CSS file exists
        if (file_exists($css_file_path)) {
            // Delete the CSS file
            unlink($css_file_path);
        }
        // Write custom CSS content to the file
        file_put_contents($css_file_path, $custom_css);
    }

    // Admin editor custom style
    function get_gutenberg_custom_style () {
        $custom_css = '';
        include_once THEME_DIR . '/admin/assets/css/custom-style-editor.php';
        return $custom_css;
    }
    
    function ocdi_plugin_intro_text( $default_text ) {
        $default_text .='<div class="ocdi__intro-text">
                            <p>پیشنهاد میشود قبل از اجرا درون ریز راهنما زیر را مطالعه کنید:</p>
                            <a style="background-color: #F14647; color: white; padding: 10px; border-radius: 10px; text-decoration: auto;" href="https://brand-man.armanhub.ir/doc/docs/install/"> مشاهده اموزش</a>
                            <a style="border: 1px solid #F14647; color: #F14647; padding: 10px; margin-right: 20px; border-radius: 10px; text-decoration: auto;" href="../wp-content/themes/brand-man/admin/demo/elementor-kit.zip">دریافت فایل کیت</a><br><br><br>
                        </div>';
    
        return $default_text;
    }

	function ocdi_register_plugins( $plugins ) {
		$theme_plugins = [ 
			[ // A WordPress.org plugin repository example.
				'name' => 'elementor', // Name of the plugin.
				'slug' => 'elementor', // Plugin slug - the same as on WordPress.org plugin repository.
				'required' => true,                     // If the plugin is required or not.
			],
			[ // A WordPress.org plugin repository example.
				'name' => 'woocommerce', // Name of the plugin.
				'slug' => 'woocommerce', // Plugin slug - the same as on WordPress.org plugin repository.
				'required' => true,                     // If the plugin is required or not.
			],
		];

		return array_merge( $plugins, $theme_plugins );
	}
    
    // Demo importer config. One Click Demo Import plugin
    function import_demo_config() {
        return [
            [
                'import_file_name'             => __('demo', THEME_NAME),
                'local_import_file'            => THEME_DIR . '/admin/demo/content.xml',
                'local_import_redux'           => [
                    [
                        'file_path'   => THEME_DIR . '/admin/demo/redux.json',
                        'option_name' => 'theme_settings',
                    ],
                ],
                'import_preview_image_url'     => THEME_URL . '/admin/demo/screenshot.png',
                'preview_url'                  => 'https://brand-man.armanhub.ir/demo/',
            ],
        ];
    }


    public function add_fonts_to_allowed_mimes( $mimes ) {
		$mimes['woff']  = 'application/x-font-woff';
		$mimes['woff2'] = 'application/x-font-woff2';
		$mimes['ttf']   = 'application/x-font-ttf';
		$mimes['svg']   = 'image/svg+xml';
		$mimes['eot']   = 'application/vnd.ms-fontobject';
		$mimes['otf']   = 'font/otf';

		return $mimes;
	}
}

// Call theme_Admin_Setup
new theme_Admin_Setup();


// Plugins installer
include_once THEME_DIR . '/admin/plugins-installer.php';


// Redux Framework Config
include_once THEME_DIR . '/admin/redux-config.php';