<?php
/**
 * Template part for displaying page 404
 */

get_header();
?>
    <main class="main-wrapper">
        <div class="content-wrapper">
            <?php
            $template_id = get_layout('404');
            $template = show_template($template_id);

            if($template) {
                echo ($template);
            }
            else {
                ?>
                <div class="container">
                    <div class="page-content-wrapper">
                        <div class="content-container">
                            <div class="page-content page-404" >
                                <h1>404</h1>
                                <p>
                                    <?php esc_html__('It looks like nothing was found at this location.', THEME_NAME); ?>
                                    <a href="<?php echo home_url('/'); ?>"><?php esc_html_e('Return to Home Page', THEME_NAME); ?></a>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
            }
            ?>
        </div>
    </main>
<?php
get_footer();

