<?php
/**
 * Template part for displaying single post
 */

get_header();

$sidebar_position = option_value( 'post-sidebar-position' );
$sidebar_sticky = option_value( 'post-sticky-sidebar' );

$post_kind = get_post_type();

if ( $sidebar_position == 'none') {
    $sidebar_position = intval(option_value('general-sidebar-position'));
}

// Default Sidebar Position for the post
$valid_positions = ['left', 'right', 'none', 'none-narrow', 'elementor'];
$sidebar_position = in_array($sidebar_position, $valid_positions) ? $sidebar_position : 'right';

// Check Sidebar For Content
if( in_array($sidebar_position, ['left', 'right']) ) {
    $sidebar_template_id = get_layout('sidebar');
    if(!$sidebar_template_id) {
        $sidebar_position = 'none';
    }
}

$template_id = get_layout( 'single' );

global $post;

$post_categories = get_the_category();
if ( ! empty( $post_categories ) ) {
	$first_category = $post_categories[0];
	$template_id_category = get_term_meta( $first_category->term_id, 'category-single', true );

	if ( ! empty( $template_id_category ) && $template_id_category !== '0' ) {
		$template_id = $template_id_category;
	}
}

?>
	<main class="main-wrapper">
		<?php
		while ( have_posts() ) :
			the_post();
            if($sidebar_position == 'elementor') { ?>
                <div class="content-wrapper">
                    <?php the_content(); ?>
                </div>   
            <?php }
            else {
                get_template_part('template-parts/post/content-top');
                get_template_part('template-parts/post/single-hero-outside');?>
                <div class="content-wrapper">
                    <div class="container">
                        <div class="page-content-wrapper <?php echo 'sidebar-' . $sidebar_position; ?>">
                            <div class="content-container">
                                <?php if(! intval( option_value( 'single-' . $post_kind ) )){?>
                                    
                                    <?php get_template_part('template-parts/post/single-hero-inside'); ?>
                                    <article id="post-<?php the_ID(); ?>" <?php post_class( 'single-content' ); ?> >
                                        <?php the_content(); ?>
                                        <?php wp_link_pages(); ?>
                                        <?php
                                        if(!option_value('disable-tags') && get_the_tags($post->ID)) {
                                            ?>
                                            <div class="clear"></div>
                                            <div class="single-post-tags">
                                            <h4><?php esc_html__('Tags:', THEME_NAME) ?></h4>
                                            <?php the_tags('', '', ''); ?>
                                            </div>
                                        <?php } ?>
                                    </article>
                                    <?php get_template_part('template-parts/post/author-box'); ?>
                                    <?php get_template_part('template-parts/post/share'); ?>
                                    <?php get_template_part('template-parts/post/next-prev-posts'); ?>
                                    <?php comments_template(); ?>
                                <?php }
                                    else {
                                        $template = show_template($template_id);
                                        if($template_id) {
                                            echo $template;
                                        }
                                    }?>
                            </div>
                            <?php if($sidebar_position == 'left' || $sidebar_position == 'right'): ?>
                                <aside class="sidebar-container <?php if($sidebar_sticky) echo 'sticky'; ?>">
                                    <?php get_sidebar(); ?>
                                </aside>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php get_template_part('template-parts/post/content-bottom'); ?>
                <?php
            }
		endwhile; 
		?>
        <?php if(option_value('post-reading-progress-indicator')){ ?>
            <div class="post-reading-progress-indicator"><span></span></div>         
        <?php } ?>
	</main>
<?php
get_footer();
