<?php
/**
 * Template part for displaying archive
 */

get_header();
// Default Sidebar Position for the archive
$post_kind = get_post_type();

$sidebar_position = option_value( $post_kind . 'archive-sidebar-position' );
$sidebar_sticky = option_value( $post_kind . '-archive-sticky-sidebar' );

if ( empty( $sidebar_position ) ) {
	$sidebar_position = intval( option_value( 'general-sidebar-template' ) );
}

// Check Sidebar For Content
if ( in_array( $sidebar_position, [ 'left', 'right' ] ) ) {
	$sidebar_template_id = get_layout( 'sidebar' );
	if ( ! $sidebar_template_id ) {
		$sidebar_position = 'none';
	}
}

?>
<main class="main-wrapper">
	<div class="content-wrapper">
		<?php
		get_template_part( "template-parts/archive/archive-title" );
		$template_id = get_layout( 'search' );
		$template = show_template( $template_id );
		if ( $template && $sidebar_position == 'none' ) {
			echo ( $template );
		} else {
			?>
			<div class="container">
				<div class="page-content-wrapper <?php echo 'sidebar-' . $sidebar_position; ?>">
					<div class="content-container archive-content-container">
						<?php
						if ( $template ) {
							echo ( $template );
						} else {
							get_template_part( "template-parts/archive/archive-default" );
						}
						?>
					</div>
					<?php
					$template_id = option_value( 'archive-bottom-content-template' );
					$template = show_template( $template_id );
					if ( $template_id ) {
						echo $template;
					}
					if ( $sidebar_position == 'left' || $sidebar_position == 'right' ) : ?>
						<aside class="sidebar-container <?php if ( $sidebar_sticky )
							echo 'sticky'; ?>">
							<?php get_sidebar(); ?>
						</aside>
					<?php endif; ?>
				</div>
			</div>
			<?php
		}

		?>
	</div>
</main>
<?php
get_footer();
