<?php
/**
 * Template part for displaying single page
 */

get_header();

// Default Sidebar Position for the page
$sidebar_position = option_value('page-sidebar-position');
$sidebar_sticky = option_value( 'page-sticky-sidebar' );

$post_kind = get_post_type();

if ( $sidebar_position == 'none' ) {
	$sidebar_position = intval( option_value( 'general-sidebar-position' ) );
}

// Default Sidebar Position for the post
$valid_positions = [ 'left', 'right', 'none', 'none-narrow', 'elementor' ];
$sidebar_position = in_array( $sidebar_position, $valid_positions ) ? $sidebar_position : 'right';

// Check Sidebar For Content
if ( in_array( $sidebar_position, [ 'left', 'right' ] ) ) {
	$sidebar_template_id = get_layout( 'sidebar' );
	if ( ! $sidebar_template_id ) {
		$sidebar_position = 'none';
	}
}


?>
    <main class="main-wrapper">
        <?php
        /* Start the Loop */
        while ( have_posts() ) :
            
			the_post();
            
            if($sidebar_position == 'elementor') {
                ?>
                <div class="content-wrapper">
                    <?php the_content(); ?>
                </div>
                <?php
            }
            else {
                ?>
                <div class="content-wrapper">
                    <div class="container">
                        <div class="page-content-wrapper <?php echo 'sidebar-' . $sidebar_position; ?>">
                            <div class="content-container">
                                <article id="post-<?php the_ID(); ?>" <?php post_class( 'single-content' ); ?> >
                                    <?php the_content(); ?>
                                    <?php wp_link_pages(); ?>
                                </article>
                                <?php comments_template(); ?>
                            </div>
                            <?php if($sidebar_position == 'left' || $sidebar_position == 'right'): ?>
                                <aside class="sidebar-container <?php if(option_value('sticky-sidebar')) echo 'sticky'; ?>">
                                    <?php get_sidebar(); ?>
                                </aside>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php
            }
        endwhile; // End of the loop.
        ?>
    </main>
<?php
get_footer();
