<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly
class setup_theme {

	function __construct() {

		add_action( 'init', array( $this, 'register_post_type_header' ) );
		add_action( 'init', array( $this, 'register_post_type_footer' ) );
		add_action( 'init', array( $this, 'register_post_type_side_bar' ) );
		add_action( 'init', array( $this, 'register_post_type_blog' ) );
		add_action( 'init', array( $this, 'register_post_type_other' ) );
		add_action( 'init', array( $this, 'custom_login_page_redirect' ) );
		add_action( 'init', array( $this, 'active_classic_editor' ) );
		add_action( 'template_redirect', array( $this, 'redirect_woocommerce_login' ) );

		add_action( 'init', array( $this, 'register_theme_category_taxonomy' ) );
		add_action( 'init', array( $this, 'register_theme_post_types' ) );

		add_action( 'wp_head', array( $this, 'change_favicon' ) );
		add_action( 'after_setup_theme', array( $this, 'theme_setup' ) );
		add_action( 'wp_enqueue_scripts', array( $this, 'theme_scripts' ) );
		add_action( 'wp_enqueue_scripts', array( $this, 'elementor_styles' ) );
		add_action( 'widgets_init', array( $this, 'theme_sidebars' ) );
		add_action( 'wp_logout', array( $this, 'custom_logout_redirect' ) );
		add_action( 'manage_posts_custom_column', array( $this, 'posts_custom_column_views' ), 5, 2 );
		add_action( 'admin_menu', array( $this, 'remove_redux_options_page' ), 999 );
		add_action( 'init', array( $this, 'get_custom_style' ) );
		add_action( 'redux/options/theme_settings/saved', array( $this, 'get_custom_style' ) );
		add_action( 'admin_init', array( $this, 'enable_rich_editor_for_all_users' ) );
		add_action( 'init', array( $this, 'customize_woocommerce_profile' ) );

		add_filter( 'login_redirect', array( $this, 'custom_login_redirect' ), 10, 3 );
		add_filter( 'manage_posts_columns', array( $this, 'posts_column_views' ) );
		add_filter( 'get_comment_date', array( $this, 'convert_to_shamsi_date' ) );
		add_filter( 'woocommerce_checkout_fields', array( $this, 'customize_woocommerce_billing_fields' ) );
		add_action( 'wp', array( $this, 'custom_handle_add_to_cart' ) );
		add_action( 'wp_head', array( $this, 'add_manifest_link' ) );
		add_action( 'wp_footer', array( $this, 'register_service_worker' ) );
		add_action( 'redux/options/theme_settings/saved', array( $this, 'generate_manifest_file' ) );
	}

	function register_post_type_header() {
		$labels = array(
			'name' => __( 'headers', THEME_NAME ),
			'singular_name' => __( 'header', THEME_NAME ),
			'menu_name' => __( 'header', THEME_NAME ),
			'add_new' => __( 'Add header', THEME_NAME ),
			'add_new_item' => __( 'Add New header', THEME_NAME ),
			'new_item' => __( 'New header', THEME_NAME ),
			'edit_item' => __( 'Edit header', THEME_NAME ),
			'view_item' => __( 'View header', THEME_NAME ),
			'all_items' => __( 'headers', THEME_NAME ),
			'search_items' => __( 'Search headers', THEME_NAME ),
			'not_found' => __( 'Not found', THEME_NAME ),
			'not_found_in_trash' => __( 'Not found anythings in the trash', THEME_NAME ),
		);

		$args = array(
			'labels' => $labels,
			'public' => true,
			'exclude_from_search' => true,
			'show_in_menu' => true,
			'menu_position' => 10,
			'show_in_nav_menus' => false,
			'show_in_admin_bar' => true,
			'show_ui' => true,
			'show_in_rest' => true,
			'rewrite' => false,
			'menu_icon' => THEME_URL . '/assets/img/header.png',
			'has_archive' => false,
			'capability_type' => 'post',
			'hierarchical' => false,
			'supports' => array( 'title', 'editor' )
		);

		register_post_type( 'theme-header', $args );
	}

	function register_post_type_footer() {
		$labels = array(
			'name' => __( 'footers', THEME_NAME ),
			'singular_name' => __( 'footer', THEME_NAME ),
			'menu_name' => __( 'footer', THEME_NAME ),
			'add_new' => __( 'Add footer', THEME_NAME ),
			'add_new_item' => __( 'Add New footer', THEME_NAME ),
			'new_item' => __( 'New footer', THEME_NAME ),
			'edit_item' => __( 'Edit footer', THEME_NAME ),
			'view_item' => __( 'View footer', THEME_NAME ),
			'all_items' => __( 'footer', THEME_NAME ),
			'search_items' => __( 'Search footer', THEME_NAME ),
			'not_found' => __( 'Not found', THEME_NAME ),
			'not_found_in_trash' => __( 'Not found anythings in the trash', THEME_NAME ),
		);

		$args = array(
			'labels' => $labels,
			'public' => true,
			'exclude_from_search' => true,
			'show_in_menu' => true,
			'menu_position' => 10,
			'show_in_nav_menus' => false,
			'show_in_admin_bar' => true,
			'show_ui' => true,
			'show_in_rest' => true,
			'rewrite' => false,
			'menu_icon' => THEME_URL . '/assets/img/footer.png',
			'has_archive' => false,
			'capability_type' => 'post',
			'hierarchical' => false,
			'supports' => array( 'title', 'editor' )
		);

		register_post_type( 'theme-footer', $args );
	}

	function register_post_type_side_bar() {
		$labels = array(
			'name' => __( 'side bars', THEME_NAME ),
			'singular_name' => __( 'side bar', THEME_NAME ),
			'menu_name' => __( 'side bar', THEME_NAME ),
			'add_new' => __( 'Add side bar', THEME_NAME ),
			'add_new_item' => __( 'Add New side bar', THEME_NAME ),
			'new_item' => __( 'New side bar', THEME_NAME ),
			'edit_item' => __( 'Edit side bar', THEME_NAME ),
			'view_item' => __( 'View side bar', THEME_NAME ),
			'all_items' => __( 'side bar', THEME_NAME ),
			'search_items' => __( 'Search side bar', THEME_NAME ),
			'not_found' => __( 'Not found', THEME_NAME ),
			'not_found_in_trash' => __( 'Not found anythings in the trash', THEME_NAME ),
		);

		$args = array(
			'labels' => $labels,
			'public' => true,
			'exclude_from_search' => true,
			'show_in_menu' => true,
			'menu_position' => 10,
			'show_in_nav_menus' => false,
			'show_in_admin_bar' => true,
			'show_ui' => true,
			'show_in_rest' => true,
			'rewrite' => false,
			'menu_icon' => THEME_URL . '/assets/img/sidebar.png',
			'has_archive' => false,
			'capability_type' => 'post',
			'hierarchical' => false,
			'supports' => array( 'title', 'editor' )
		);

		register_post_type( 'theme-side-bar', $args );
	}

	function register_post_type_blog() {
		$labels = array(
			'name' => __( 'blog template', THEME_NAME ),
			'singular_name' => __( 'blog template', THEME_NAME ),
			'menu_name' => __( 'blog template', THEME_NAME ),
			'add_new' => __( 'Add blog template', THEME_NAME ),
			'add_new_item' => __( 'Add New blog template', THEME_NAME ),
			'new_item' => __( 'New blog template', THEME_NAME ),
			'edit_item' => __( 'Edit blog template', THEME_NAME ),
			'view_item' => __( 'View blog template', THEME_NAME ),
			'all_items' => __( 'blog template', THEME_NAME ),
			'search_items' => __( 'Search blog template', THEME_NAME ),
			'not_found' => __( 'Not found', THEME_NAME ),
			'not_found_in_trash' => __( 'Not found anythings in the trash', THEME_NAME ),
		);

		$args = array(
			'labels' => $labels,
			'public' => true,
			'exclude_from_search' => true,
			'show_in_menu' => true,
			'menu_position' => 10,
			'show_in_nav_menus' => false,
			'show_in_admin_bar' => true,
			'show_ui' => true,
			'show_in_rest' => true,
			'rewrite' => false,
			'menu_icon' => THEME_URL . '/assets/img/blog.png',
			'has_archive' => false,
			'capability_type' => 'post',
			'hierarchical' => false,
			'supports' => array( 'title', 'editor' )
		);

		register_post_type( 'theme-blog', $args );
	}

	function register_post_type_other() {
		$labels = array(
			'name' => __( 'other template', THEME_NAME ),
			'singular_name' => __( 'other template', THEME_NAME ),
			'menu_name' => __( 'other template', THEME_NAME ),
			'add_new' => __( 'Add other template', THEME_NAME ),
			'add_new_item' => __( 'Add New other template', THEME_NAME ),
			'new_item' => __( 'New other template', THEME_NAME ),
			'edit_item' => __( 'Edit other template', THEME_NAME ),
			'view_item' => __( 'View other template', THEME_NAME ),
			'all_items' => __( 'other template', THEME_NAME ),
			'search_items' => __( 'Search other template', THEME_NAME ),
			'not_found' => __( 'Not found', THEME_NAME ),
			'not_found_in_trash' => __( 'Not found anythings in the trash', THEME_NAME ),
		);

		$args = array(
			'labels' => $labels,
			'public' => true,
			'exclude_from_search' => true,
			'show_in_menu' => true,
			'menu_position' => 10,
			'show_in_nav_menus' => false,
			'show_in_admin_bar' => true,
			'show_ui' => true,
			'show_in_rest' => true,
			'rewrite' => false,
			'menu_icon' => THEME_URL . '/assets/img/other.png',
			'has_archive' => false,
			'capability_type' => 'post',
			'hierarchical' => false,
			'supports' => array( 'title', 'editor' )
		);

		register_post_type( 'theme-other', $args );
	}

	function register_theme_category_taxonomy() {
		$post_types = theme_post_type();
		foreach ( $post_types as $post_type ) {
			$name = $post_type['name'];
			$title = $post_type['title'];
			$taxonomy_name = $name . '-category';
			$labels = array(
				'name' => __( 'Categories ', THEME_NAME ) . $title,
				'singular_name' => __( 'Category ', THEME_NAME ) . $title,
				'search_items' => __( 'Search ', THEME_NAME ) . $title . __( ' Categories', THEME_NAME ),
				'all_items' => __( 'All ', THEME_NAME ) . $title . __( ' Categories', THEME_NAME ),
				'parent_item' => __( 'Parent ', THEME_NAME ) . $title . __( ' Category', THEME_NAME ),
				'parent_item_colon' => __( 'Parent ', THEME_NAME ) . $title . __( ' Category', THEME_NAME ),
				'edit_item' => __( 'Edit ', THEME_NAME ) . $title . __( ' Category', THEME_NAME ),
				'update_item' => __( 'Update ', THEME_NAME ) . $title . __( ' Category', THEME_NAME ),
				'add_new_item' => __( 'Add New ', THEME_NAME ) . $title . __( ' Category', THEME_NAME ),
				'new_item_name' => __( 'New ', THEME_NAME ) . $title . __( ' Category name', THEME_NAME ),
				'menu_name' => __( 'Categories ', THEME_NAME ) . $title,
			);

			$args = array(
				'hierarchical' => true,
				'labels' => $labels,
				'show_ui' => true,
				'show_admin_column' => true,
				'query_var' => true,
				'rewrite' => array( 'slug' => $taxonomy_name ),
				'post_type' => $name,
			);

			$result = register_taxonomy( $taxonomy_name, $name, $args );
		}
	}

	function register_theme_post_types() {
		$post_types = theme_post_type();
		foreach ( $post_types as $post_type ) {
			$name = $post_type['name'];
			$title = $post_type['title'];
			$arg = $post_type['arg'];
			$labels = array(
				'name' => $title,
				'singular_name' => $title,
				'menu_name' => $title,
				'add_new' => __( 'Add ', THEME_NAME ) . $title,
				'add_new_item' => __( 'Add New ', THEME_NAME ) . $title,
				'new_item' => __( 'New ', THEME_NAME ) . $title,
				'edit_item' => __( 'Edit ', THEME_NAME ) . $title,
				'view_item' => __( 'View ', THEME_NAME ) . $title,
				'all_items' => __( 'All ', THEME_NAME ) . $title,
				'search_items' => __( 'Search ', THEME_NAME ) . $title,
				'not_found' => __( 'Not found', THEME_NAME ),
				'not_found_in_trash' => __( 'Not found anythings in the trash', THEME_NAME ),
			);
			$args = $arg;
			$args['labels'] = $labels;
			$args['taxonomies'] = array( $name . '-category' );
			$args['supports'] = array( 'title', 'slug', 'editor', 'trackbacks', 'custom-fields', 'revisions', 'author', 'thumbnail', 'excerpt', 'comments', 'page-attributes', 'post-formats', 'menu_order' );


			register_post_type( $name, $args );
		}
	}


	// Sets up theme defaults and registers support for various WordPress features.
	function theme_setup() {

		// Make theme available for translation.
		load_theme_textdomain( 'woocommerce', THEME_DIR . '/languages' );
		load_theme_textdomain( 'redux-framework', THEME_DIR . '/languages' );
		load_theme_textdomain( 'cmb2', THEME_DIR . '/languages' );
		load_theme_textdomain( THEME_NAME, THEME_DIR . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		// Let WordPress manage the document title.
		add_theme_support( 'title-tag' );

		// Enable woocommerce support
		add_theme_support( 'woocommerce' );
		add_theme_support( 'wc-product-gallery-zoom' );
		add_theme_support( 'wc-product-gallery-lightbox' );
		add_theme_support( 'wc-product-gallery-slider' );

		add_theme_support( 'wpforms' );

		// Enable support for Post Thumbnail
		add_theme_support( 'post-thumbnails' );

		add_image_size( 'theme-small', 400, 300, true );
		add_image_size( 'theme-small-tall', 400, 600, true );
		add_image_size( 'theme-small-square', 400, 400, true );
		add_image_size( 'theme-small-masonry', 400 );

		add_image_size( 'theme-medium', 700, 500, true );
		add_image_size( 'theme-medium-square', 700, 700, true );
		add_image_size( 'theme-medium-masonry', 700 );

		add_image_size( 'theme-large', 1000, 600, true );
		add_image_size( 'theme-large-wide', 1200, 600, true );

		// Switch default core markup for search form, comment form, and comments to output valid HTML5.
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'script',
			'style',
		) );

		// Enable support for Post Formats.
		add_theme_support( 'post-formats', array(
			'gallery',
			'video',
			'audio',
			'quote',
			'link',
		) );

		// Add support for Block Styles.
		add_theme_support( 'wp-block-styles' );

		// Add support for full and wide align images.
		add_theme_support( 'align-wide' );

		// Add support for responsive embedded content.
		add_theme_support( 'responsive-embeds' );

		register_nav_menus(
			array(
				'primary_menu' => esc_html__( 'Primary menu', THEME_NAME ),
				'mobile_menu' => esc_html__( 'Mobile menu', THEME_NAME ),
			)
		);

		// Disable Swiper 8.4
		if ( get_option( 'elementor_experiment-e_swiper_latest' ) != 'inactive' ) {
			update_option( 'elementor_experiment-e_swiper_latest', 'inactive' );
		}

		// Disable Default Colors
		if ( get_option( 'elementor_disable_color_schemes' ) != 'yes' ) {
			update_option( 'elementor_disable_color_schemes', 'yes' );
		}

		// Disable Default Fonts
		if ( get_option( 'elementor_disable_typography_schemes' ) != 'yes' ) {
			update_option( 'elementor_disable_typography_schemes', 'yes' );
		}

		// Disable extendify
		if ( get_option( 'redux-framework_extendify_plugin_notice' ) != 'hide' ) {
			update_option( 'redux-framework_extendify_plugin_notice', 'hide' );
		}

		// Site width
		$GLOBALS['content_width'] = 860;

	}

	function posts_custom_column_views( $column_name, $id ) {
		if ( $column_name === 'post_views' ) {
			echo get_post_view( get_the_ID() );
		}
	}

	function posts_column_views( $defaults ) {
		$defaults['post_views'] = esc_html__( 'Views', THEME_NAME );
		return $defaults;
	}

	function change_favicon() {
		if ( option_value( 'theme-favicon' ) ) {
			$theme_favicon = option_value( 'theme-favicon' )['url'];
			echo '<link rel="shortcut icon" href="' . esc_url( $theme_favicon ) . '" type="image/x-icon" />';
		}
		if ( option_value( 'theme-retina' ) ) {
			$theme_retina = option_value( 'theme-retina' )['url'];
			echo '<link rel="apple-touch-icon" sizes="180x180" href="' . esc_url( $theme_retina ) . '" />';
		}
	}

	function minify_css( $css ) {
		$css = preg_replace( '!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $css );
		$css = str_replace( array( "\r\n", "\r", "\n", "\t" ), '', $css );
		return $css;
	}

	// Get Custom Style
	function get_custom_style() {
		$custom_css = '';

		// Include custom CSS styles
		include_once THEME_DIR . '/assets/css/custom-style.php';
		$custom_css .= option_value( 'custom_css' );

		// Path to the CSS file
		$css_file_path = get_stylesheet_directory() . '/assets/css/user-style.css';

		// Check if the CSS file exists
		if ( file_exists( $css_file_path ) ) {
			// Delete the CSS file
			unlink( $css_file_path );
		}

		// Write custom CSS content to the file
		file_put_contents( $css_file_path, $custom_css );

		$css_dir = THEME_DIR . '/assets/css';

		// Unlink main.css if it exists
		$main_css_file = $css_dir . '/main.css';
		if ( file_exists( $main_css_file ) ) {
			unlink( $main_css_file );
		}

		// Create new main.css file
		$main_css_content = '';

		// Get all CSS files in the directory
		$css_files = glob( $css_dir . '/*.css' );
		if ( $css_files ) {
			foreach ( $css_files as $css_file ) {
				$filename = basename( $css_file );
				$current_locale = get_locale();
				if ( $current_locale === 'fa_IR' && strpos( $filename, 'rtl' ) !== false ) {
					if ( ! option_value( 'merge-css' ) ) {
						$main_css_content .= "@import url('$filename');\n";
					} else {
						// Merge CSS content directly into $main_css_content
						$file_content = file_get_contents( $css_file );
						$main_css_content .= $file_content . "\n";
					}
				} elseif ( strpos( $filename, 'rtl' ) === false ) {
					if ( ! option_value( 'merge-css' ) ) {
						$main_css_content .= "@import url('$filename');\n";
					} else {
						// Merge CSS content directly into $main_css_content
						$file_content = file_get_contents( $css_file );
						$main_css_content .= $file_content . "\n";
					}
				}
			}
			if ( option_value( 'minify-css' ) ) {
				$main_css_content = $this->minify_css( $main_css_content );
			}
			// Write the collected CSS content to main.css
			file_put_contents( $main_css_file, $main_css_content );
		}
	}

	function enable_rich_editor_for_all_users() {
		if ( ! current_user_can( 'edit_posts' ) && ! current_user_can( 'edit_pages' ) ) {
			return;
		}

		add_filter( 'user_can_richedit', '__return_true', 50 );
	}

	// Enqueues Theme Scripts And Styles.
	function theme_scripts() {
		// Theme Style
		wp_enqueue_style( 'theme-style', THEME_URL . '/assets/css/main.css', array(), false );

		// Vendor Scripts
		wp_enqueue_script( 'SmoothScroll', THEME_URL . '/assets/js/SmoothScroll.min.js', array(), '1.4.10', true );

		// Theme Scripts
		wp_enqueue_script( 'swiper', THEME_URL . '/assets/js/swiper.js', array( 'jquery' ), null );
		wp_enqueue_script( 'blog-siwper', THEME_URL . '/assets/js/blog-siwper.js', array( 'jquery', 'swiper' ), null );
		wp_enqueue_script( 'theme-main-script', THEME_URL . '/assets/js/main.js', array( 'jquery', 'swiper' ), false, true );
		wp_enqueue_script( 'gallery_tab', THEME_URL . '/assets/js/gallery_tab.js', array( 'jquery', ), false, true );
		wp_enqueue_script( 'plyr', THEME_URL . '/assets/js/plyr.js', array( 'jquery' ), null );
		wp_localize_script( 'theme-main-script', 'theme_ajax_object',
			array(
				'AjaxUrl' => admin_url( 'admin-ajax.php' ),
			)
		);

		// Comment JS
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
		if ( option_value( 'custom_js' ) ) {
			$script = option_value( 'custom_js' );

			wp_add_inline_script( 'user-custom-js', $script );
		}

	}

	// Enqueues Elementor Styles. Pre Render
	function elementor_styles() {

		if ( ! class_exists( 'Elementor\Plugin' ) ) {
			return;
		}

		if ( class_exists( '\Elementor\Plugin' ) ) {
			$elementor = \Elementor\Plugin::instance();
			$elementor->frontend->enqueue_styles();
		}

		if ( class_exists( '\ElementorPro\Plugin' ) ) {
			$elementor_pro = \ElementorPro\Plugin::instance();
			$elementor_pro->enqueue_styles();
		}

		$template_ids = array(
			get_layout( 'sidebar' ),
			get_layout( 'footer' ),
			get_layout( 'header' ),
			get_layout( 'sticky-header' ),
			get_layout( 'single-top-content' ),
			get_layout( 'single-bottom-content' ),
			get_layout( '404' ),
			get_layout( 'archive' ),
		);

		foreach ( $template_ids as $template_id ) {
			if ( $template_id ) {
				if ( class_exists( '\Elementor\Core\Files\CSS\Post' ) ) {
					$css_file = new \Elementor\Core\Files\CSS\Post( $template_id );
				} elseif ( class_exists( '\Elementor\Post_CSS_File' ) ) {
					$css_file = new \Elementor\Post_CSS_File( $template_id );
				}

				$css_file->enqueue();
			}
		}

	}

	// Register sidebars
	function theme_sidebars() {

		register_sidebar( array(
			'name' => esc_html__( 'shop Sidebar', THEME_NAME ),
			'id' => 'shop_sidebar_widgets',
			'description' => esc_html__( 'shop Sidebar Widgets', THEME_NAME ),
			'before_widget' => '<div id="%1$s" class="%2$s theme-sidebar-widget">',
			'after_widget' => '</div>',
			'before_title' => '<h3>',
			'after_title' => '</h3>',
		) );
	}

	// Function to handle admin login redirect
	function custom_login_redirect( $redirect_to, $request, $user ) {
		// Check if user roles are set and is an array
		if ( isset( $user->roles ) && is_array( $user->roles ) ) {
			// Loop through each user role
			foreach ( $user->roles as $role ) {
				// Generate the option name for the login redirect URL based on the user's role
				$option_name = $role . '_login_redirect';

				// Get the login redirect URL option value based on the user's role
				$login_redirect_url = option_value( $option_name );

				// If the login redirect URL option value is set, return it
				if ( ! empty( $login_redirect_url ) ) {
					return $login_redirect_url;
				}
			}
		}

		// If no specific login redirect URL is set for the user's role, return the default redirect URL
		return $redirect_to;
	}

	// Function to handle admin logout redirect
	function custom_logout_redirect() {
		foreach ( $user->roles as $role ) {
			// Generate the option name for the logout redirect URL based on the user's role
			$option_name = $role . '_logout_redirect';

			// Get the logout redirect URL option value based on the user's role
			$logout_redirect_url = option_value( $option_name );

			// If the logout redirect URL option value is set, return it
			if ( $logout_redirect_url ) {
				wp_safe_redirect( $logout_redirect_url );
			} else {
				wp_safe_redirect( home_url() );
			}
			exit();
		}
	}

	function custom_login_page_redirect( $login_url ) {
		$selected_page_id = option_value( 'page-login-template' );

		if ( $selected_page_id && $selected_page_id != '0' && strpos( $_SERVER['REQUEST_URI'], 'wp-login.php' ) !== false && strpos( $_SERVER['REQUEST_URI'], 'action=register' ) === false ) {
			add_action( 'login_init', function () {
				if ( isset( $_GET['action'] ) && $_GET['action'] == 'rp' ) {
					return; // Show the default reset password page
				}
				$selected_page_id = option_value( 'page-login-template' );
				if ( ! empty( $selected_page_id ) && $selected_page_id != '0' ) {
					$selected_page_permalink = get_permalink( $selected_page_id );
					if ( $selected_page_permalink ) {
						wp_redirect( $selected_page_permalink, 301 );
						// exit;
					}
				}
			} );
			add_action( 'template_redirect', function () {
				if ( isset( $_GET['action'] ) && $_GET['action'] == 'rp' ) {
					return; // Show the default reset password page
				}

				if ( is_account_page() ) {
					$selected_page_id = option_value( 'page-login-template' );
					if ( ! empty( $selected_page_id ) && $selected_page_id != '0' ) {
						$selected_page_permalink = get_permalink( $selected_page_id );
						if ( $selected_page_permalink ) {
							wp_redirect( $selected_page_permalink, 301 );
							exit;
						}
					}
				}


			} );
		} else {
			return home_url( '/wp-admin' );
		}
	}

	function redirect_woocommerce_login() {
		// Check if the current page is the WooCommerce account page and if WooCommerce is active
		if ( function_exists( 'wc_get_page_id' ) && is_account_page() && ! is_user_logged_in() ) {
			$login_page_id = get_option( 'woocommerce_myaccount_page_id' );
			$login_page_url = get_permalink( $login_page_id );

			// Exclude the "Forgot Password" page from redirection
			if ( ! is_wc_endpoint_url( 'lost-password' ) ) {
				wp_redirect( wp_login_url( $login_page_url ) );
				exit();
			}
		}
	}

	function active_classic_editor() {
		if ( option_value( 'classic-mode' ) ) {
			add_filter( 'use_block_editor_for_post', '__return_false' );
			add_action( 'wp_enqueue_scripts', function () {
				wp_dequeue_style( 'wp-block-library' );
				wp_dequeue_style( 'wp-block-library-theme' );
			} );
		}
	}

	// Define a function to convert the date to Shamsi format
	function convert_to_shamsi_date( $date ) {
		// Check if the current locale is Persian
		$current_locale = get_locale();
		if ( $current_locale === 'fa_IR' ) {
			if ( option_value( 'jdatetime' ) ) {
				// Load JDateTime library
				require_once THEME_DIR . '/inc/jdatatime.php';
				$jdate = new JDateTime();

				// Convert the date to Shamsi format
				$gregorian_date = date( 'Y-m-d', strtotime( $date ) );
				$shamsi_date = $jdate->date( "Y/m/d", strtotime( $gregorian_date ) );

				return $shamsi_date;
			} else {
				return $date;
			}
		} else {
			return $date;
		}
	}


	function customize_woocommerce_billing_fields( $fields ) {
		$billing_fields = woocommerce_billing_fields();
		$shipping_fields = woocommerce_shipping_fields();
		foreach ( $billing_fields as $field_key => $field_value ) {
			$field_active = option_value( 'billing_' . $field_key );
			$field_label = option_value( $field_key . '_label' );
			$field_required = option_value( $field_key . '_required' );
			$field_priority = option_value( $field_key . '_priority' );
			if ( $field_active ) {
				if ( $field_label != null ) {
					$fields['billing'][ $field_key ]['label'] = $field_label;
				}
				$fields['billing'][ $field_key ]['required'] = $field_required;
				$fields['billing'][ $field_key ]['priority'] = $field_priority;
			} else {
				unset( $fields['billing'][ $field_key ] );
			}
		}
		foreach ( $shipping_fields as $field_key => $field_value ) {
			$field_active = option_value( 'shipping_' . $field_key );
			$field_label = option_value( $field_key . '_label' );
			$field_required = option_value( $field_key . '_required' );
			$field_priority = option_value( $field_key . '_priority' );
			if ( $field_active ) {
				if ( $field_label != null ) {
					$fields['shipping'][ $field_key ]['label'] = $field_label;
				}
				$fields['shipping'][ $field_key ]['required'] = $field_required;
				$fields['shipping'][ $field_key ]['priority'] = $field_priority;
			} else {
				unset( $fields['shipping'][ $field_key ] );
			}
		}
		return $fields;
	}

	public function customize_woocommerce_profile() {
		$dashboard_label = option_value( 'dashboard_label' );
		if ( $dashboard_label ) {
			$dashboard_label = $dashboard_label;
		} else {
			$dashboard_label = __( 'Dashboard', THEME_NAME );
		}

		$orders_label = option_value( 'orders_label' );
		if ( $orders_label ) {
			$orders_label = $orders_label;
		} else {
			$orders_label = __( 'orders', THEME_NAME );
		}

		$downloads_label = option_value( 'downloads_label' );
		if ( $downloads_label ) {
			$downloads_label = $downloads_label;
		} else {
			$downloads_label = __( 'downloads', THEME_NAME );
		}

		$edit_address = option_value( 'edit-address_label' );
		if ( $edit_address ) {
			$edit_address = $edit_address;
		} else {
			$edit_address = __( 'edit address', THEME_NAME );
		}

		$payment_methods = option_value( 'payment_methods_label' );
		if ( $payment_methods ) {
			$payment_methods = $payment_methods;
		} else {
			$payment_methods = __( 'payment methods', THEME_NAME );
		}

		$edit_account = option_value( 'edit-account_label' );
		if ( $edit_account ) {
			$edit_account = $edit_account;
		} else {
			$edit_account = __( 'edit account', THEME_NAME );
		}

		$customer_logout = option_value( 'customer-logout_label' );
		if ( $customer_logout ) {
			$customer_logout = $customer_logout;
		} else {
			$customer_logout = __( 'Log out', THEME_NAME );
		}

		$items = array(
			'dashboard' => $dashboard_label,
			'orders' => $orders_label,
			'downloads' => $downloads_label,
			'edit-address' => $edit_address,
			'edit-account' => $edit_account,
			'payment-methods' => $payment_methods,
			'edit-account' => $edit_account,
		);

		// Add custom endpoints and their corresponding actions
		if ( option_value( 'woocommerce_profile_fields-custom-feild' ) ) {
			foreach ( option_value( 'woocommerce_profile_fields-custom-feild' ) as $index => $item ) {
				$name = option_value( $item . '_label' );
				$slug = option_value( $item . '_slug' );
				$template = option_value( $item . '_profile_template' );

				// Add the item to the menu
				$items[ $slug ] = __( $name, 'woocommerce' );

				// Check if the endpoint has been added before adding it
				if ( ! array_key_exists( 'woocommerce_account_' . $slug . '_endpoint', $GLOBALS['wp_filter'] ) ) {
					add_rewrite_endpoint( $slug, EP_PAGES );

					// Add content to your custom endpoint
					add_action( 'woocommerce_account_' . $slug . '_endpoint', function () use ($template) {
						$template = show_template( $template );
						echo ( $template );
					} );
				}
			}
		}

		// Add the 'Log out' item to the menu
		$items['customer-logout'] = $customer_logout;

		return $items;
	}

	function remove_redux_options_page() {
		remove_submenu_page( 'options-general.php', 'redux-framework' );
	}

	function custom_handle_add_to_cart() {
		if ( isset( $_POST['add-to-cart'] ) && isset( $_POST['add_to_cart_nonce'] ) && wp_verify_nonce( $_POST['add_to_cart_nonce'], 'add_to_cart' ) ) {
			$product_id = absint( $_POST['add-to-cart'] );
			if ( $product_id ) {
				// Get the product permalink
				$product_permalink = get_permalink( $product_id );

				// Redirect to the product page
				wp_safe_redirect( $product_permalink );
				exit;
			}
		}

		if ( isset( $_POST['add-to-cart'] ) && isset( $_POST['add_to_cart_nonce_single'] ) && wp_verify_nonce( $_POST['add_to_cart_nonce_single'], 'add_to_cart_single' ) ) {
			$product_id = absint( $_POST['add-to-cart'] );
			if ( $product_id ) {
				// Get the product permalink
				$product_permalink = get_permalink( $product_id );

				// Redirect to the product page
				wp_safe_redirect( $product_permalink );
				exit;
			}
		}
	}

	function add_manifest_link() {
		if ( option_value( 'pwa_enable' ) ) {
			echo '<link rel="manifest" href="' . THEME_URL . '/assets/pwa/manifest.json">';
		}
	}

	function register_service_worker() {
		if ( option_value( 'pwa_enable' ) ) {
			echo '<script>
                    if ("serviceWorker" in navigator) {
                        window.addEventListener("load", function() {
                            navigator.serviceWorker.register("' . THEME_URL . '/assets/pwa/service-worker.js")
                            .then(function() {
                                console.log("Service Worker Registered");
                            });
                        });
                    }
                </script>';
		}
	}

	function generate_manifest_file() {
		$pwa_theme_color = option_value( 'pwa_theme_color' );
		$pwa_background_color = option_value( 'pwa_background_color' );
		$pwa_icon_512 = option_value( 'pwa_icon_512', 'url' );
		$pwa_display = option_value( 'pwa_display' );
		$pwa_dir = option_value( 'pwa_dir' );
		$site_name = get_bloginfo( 'name' );
		$site_url = esc_url( home_url( '/' ) );
		$site_description = get_bloginfo( 'description' );

		$manifest = array(
			'theme_color' => $pwa_theme_color,
			'background_color' => $pwa_background_color,
			'description' => $site_description,
			'icons' => array(
					array(
						'purpose' => 'maskable',
						'sizes' => '512x512',
						'src' => $pwa_icon_512,
						'type' => 'image/png',
					),
					array(
						'purpose' => 'any',
						'sizes' => '512x512',
						'src' => $pwa_icon_512,
						'type' => 'image/png',
					),
				),
			'orientation' => 'any',
			'display' => $pwa_display,
			'dir' => $pwa_dir,
			'lang' => 'fa-IR',
			'name' => $site_name,
			'short_name' => $site_name,
			'start_url' => $site_url,
			'scope' => $site_url,
		);

		$manifest_json = json_encode( $manifest, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES );

		$manifest_file = fopen( get_template_directory() . '/assets/pwa/manifest.json', 'w' );
		fwrite( $manifest_file, $manifest_json );
		fclose( $manifest_file );
	}

}

new setup_theme();
