<?php
use handler\basic_element;

class ar_woo_wish_list extends \Elementor\Widget_Base {

    use basic_element;
    use basic_element;

	public function get_name() {
		return 'ar_woo_wish_list';
	}
	
	public function get_title() {
		return __( 'wish list', THEME_NAME );
	}
	
	public function get_categories() {
		return ['core-elementor-elements'];
	}
	
	public function get_icon(){
		return 'ar_woo_wish_list';
	}

	protected function register_style_section_1() {
        $this->start_controls_section(
            'icon',
            [
                'label' => __( 'icon', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('icon',  'i', $align=false);

        
        $this->end_controls_section();
    }

	protected function register_style_section_2() {
        $this->start_controls_section(
            'text',
            [
                'label' => __( 'text', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('text',  'span', $align=false);

        
        $this->end_controls_section();
    }

	protected function register_controls() {

        $this->register_style_section_1();
        $this->register_style_section_2();

    }
	protected function render() {
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
		if (defined ( 'YITH_WCWL' )) {
			if ($this->theme_is_edit_mode()) {
				?>
				<div class="elementor-widget-container">
					<div class="elementor-product-wishlist">
						<div class="yith-wcwl-add-to-wishlist add-to-wishlist-221 wishlist-fragment on-first-load">
							<div class="yith-wcwl-add-button">
								<a>
									<i class="yith-wcwl-icon fa fa-heart-o"></i>
									<span>افزودن به علاقه مندی</span>
								</a>
							</div>
						</div>
					</div>
				</div>
				<?php
			}
			else{
				?>
				<div class="elementor-product-wishlist">
					<?php echo do_shortcode('[yith_wcwl_add_to_wishlist]')?>
				</div>
				<?php 
			}
		}else{
			echo 'Please install and activate plugin <a href="https://wordpress.org/plugins/yith-woocommerce-wishlist/">YITH WooCommerce Wishlist</a> on your site';
		}
	}

	
}