<?php

use handler\product_Query;
use handler\Post_skin_base;
use handler\swiper;
use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

class ar_woo_testimonials extends \Elementor\Widget_Base {

    use product_Query;
    use Post_skin_base;
    use swiper;
    use basic_element;

    public function get_name() {
        return 'ar_woo_testimonials';
    }

    public function get_title() {
        return esc_html__('user testimonials', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_testimonials';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_content_section_1() {

        $this->start_controls_section(
            'section_body',
            [
                'label' => esc_html__( 'body', THEME_NAME ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

		$repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'image',
            [
                'label' => esc_html__( 'Image', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );

		$repeater->add_control(
			'name',
			[ 
				'label' => __( 'name', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);

		$repeater->add_control(
			'desc',
			[ 
				'label' => __( 'desc', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);

        $repeater->add_control(
			'star',
			[ 
				'label' => __( 'star', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);

		$repeater->add_control(
			'star-icon',
			[ 
				'label' => __( 'star icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::ICONS,
			]
		);


		$repeater->add_control(
			'body',
			[ 
				'label' => __( 'body', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
			]
		);

		$this->add_control(
			'items',
			[ 
				'label' => esc_html__( 'testimonials', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ name }}}',
			]
		);
        $this->end_controls_section();

    }

	protected function register_content_section_2() {

		$this->start_controls_section(
			'section_layout',
			[ 
				'label' => esc_html__( 'Layout', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout',
			[ 
				'label' => esc_html__( 'Layout', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [ 
					'grid' => esc_html__( 'Grid', THEME_NAME ),
					'carousel' => esc_html__( 'Carousel', THEME_NAME ),
				],
				'default' => 'grid',
			]
		);

		$this->add_responsive_control(
			'columns',
			[ 
				'label' => esc_html__( 'Columns', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '3',
				'tablet_default' => '2',
				'mobile_default' => '1',
				'options' => [ 
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
				],
				'render_type' => 'template',
				'selectors' => [ 
					'{{WRAPPER}} .theme-posts-wrapper.layout-grid' => 'grid-template-columns: repeat({{SIZE}}, 1fr);',
					'{{WRAPPER}} .theme-posts-wrapper.layout-masonry .post-item' => 'width: calc(100% / {{SIZE}});',
					'{{WRAPPER}} .theme-posts-wrapper.layout-carousel .post-item' => 'width: calc(100% / {{SIZE}});',
				],
			]
		);

		$this->add_responsive_control(
			'column_gap',
			[ 
				'label' => esc_html__( 'Column Gap', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'default' => [ 
					'size' => '20',
				],
				'range' => [ 
					'px' => [ 
						'min' => 0,
						'max' => 100,
					],
				],
				'render_type' => 'template',
				'selectors' => [ 
					'{{WRAPPER}} .theme-posts-wrapper.layout-grid' => 'column-gap: {{SIZE}}{{UNIT}};',
					'body:not(.rtl) {{WRAPPER}} .theme-posts-wrapper.layout-carousel .post-item' => 'margin-right: {{SIZE}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .theme-posts-wrapper.layout-carousel .post-item' => 'margin-left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .theme-posts-wrapper.layout-masonry' => 'margin-left: calc({{SIZE}}{{UNIT}} * -.5); margin-right: calc({{SIZE}}{{UNIT}} * -.5);',
					'{{WRAPPER}} .theme-posts-wrapper.layout-masonry .post-item' => 'padding-left: calc({{SIZE}}{{UNIT}} * .5); padding-right: calc({{SIZE}}{{UNIT}} * .5);',
				],
			]
		);

		$this->add_responsive_control(
			'row_gap',
			[ 
				'label' => esc_html__( 'Row Gap', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'default' => [ 
					'size' => '20',
				],
				'range' => [ 
					'px' => [ 
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [ 
					'{{WRAPPER}} .theme-posts-wrapper.layout-grid' => 'row-gap: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .theme-posts-wrapper.layout-masonry .post-item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'condition' => [ 
					'layout!' => 'carousel',
				],
			]
		);

		$this->end_controls_section();

	}

    protected function register_style_section_1() {

        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('style', THEME_NAME),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control(
			'container',
			[ 
				'label' => esc_html__( 'container', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'container', '.row-one' );

		$this->add_control(
			'line',
			[ 
				'label' => esc_html__( 'line', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'rec', '.rec' );

		$this->add_control(
			'avatar',
			[ 
				'label' => esc_html__( 'avatar', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_image_style( 'img', 'img' );

		$this->add_control(
			'name',
			[ 
				'label' => esc_html__( 'name', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'title', '.title' );

		$this->add_control(
			'desc',
			[ 
				'label' => esc_html__( 'desc', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'desc', '.description' );

		$this->add_control(
			'icon',
			[ 
				'label' => esc_html__( 'icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'icon', 'i' );

		$this->add_control(
			'star',
			[ 
				'label' => esc_html__( 'star', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'star', '.star' );

		$this->add_control(
			'text',
			[ 
				'label' => esc_html__( 'text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'text', '.body' );


        $this->end_controls_section();

    }


    protected function register_controls() {

        $this->register_content_section_1();
		$this->register_content_section_2();

        $this->register_carousel_controls();

        $this->register_style_section_1();

        $this->register_style_carousel_controls();

    }
    
    protected function render(){
        if ( !class_exists( 'woocommerce' ) ) {
			return false;
		}
        $settings = $this->get_settings_for_display();
		$element_id = $settings['_element_id'];
        ?>
        <div class="theme-posts-container theme-post-widget">
            <?php
            $post_wrapper_cls = '';
                if( $settings['layout'] == 'grid' ) {
                    $post_wrapper_cls = 'theme-posts-wrapper';
                }
            ?>
            <div class="<?php echo $post_wrapper_cls ?> layout-<?php echo $settings['layout'] ?>" >
                <?php $this->render_carousel_header(); ?>
                <?php
                foreach ($settings['items'] as $item) :

                    $post_item_cls = 'post-item';
                    if( $settings['layout'] == 'carousel' ) {
                        $post_item_cls = ' swiper-slide';
                    }

                    ?>
                    <div class="<?php echo esc_html($post_item_cls); ?>">
                        <div class="row row-one align-items-center">
                            <div class="rec col-1 p-0"></div>
                            <div class="col-11 d-flex justify-content-between">
                                <div class="d-flex align-items-center">
                                    <div class="img-container">
                                        <img src="<?php echo esc_url( $item['image']['url'] ); ?>">
                                    </div>
                                    <div class="name-containe">
                                        <p class="title">
                                            <?php echo esc_html( $item['name'] ); ?>
                                        </p>
                                        <p class="description">
                                            <?php echo esc_html( $item['desc'] ); ?>
                                        </p>
                                    </div>
                                </div>
                                <div class="d-flex btm-star">
                                    <div class="icon d-flex align-items-center justify-content-center">
                                        <p class="star">
                                            <?php echo esc_html( $item['star'] ); ?>
                                        </p>
                                        <?php \Elementor\Icons_Manager::render_icon( $item['star-icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                    <path d="M15.91 12.3699H20.6C20.52 17.0399 19.6 17.8099 16.73 19.5099C16.4 19.7099 16.29 20.1299 16.49 20.4699C16.69 20.7999 17.11 20.9099 17.45 20.7099C20.83 18.7099 22.01 17.4899 22.01 11.6699V6.27994C22.01 4.56994 20.62 3.18994 18.92 3.18994H15.92C14.16 3.18994 12.83 4.51994 12.83 6.27994V9.27994C12.82 11.0399 14.15 12.3699 15.91 12.3699Z" fill="#929292"/>
                                    <path d="M5.09 12.3699H9.78C9.7 17.0399 8.78 17.8099 5.91 19.5099C5.58 19.7099 5.47 20.1299 5.67 20.4699C5.87 20.7999 6.29 20.9099 6.63 20.7099C10.01 18.7099 11.19 17.4899 11.19 11.6699V6.27994C11.19 4.56994 9.8 3.18994 8.1 3.18994H5.1C3.33 3.18994 2 4.51994 2 6.27994V9.27994C2 11.0399 3.33 12.3699 5.09 12.3699Z" fill="#E8E8E8"/>
                                </svg>  
                                <p class="body">
                                    <?php echo esc_html( $item['body'] ); ?>
                                </p>
                            </div>
                        </div>
                    </div>
                <?php
				endforeach; ?>
                <?php $this->render_carousel_footer(); ?>
            </div>
        </div>
        <script>
            jQuery(document).ready(function($) {
                // Get all elements with the class '.theme-posts-carousel-wrapper'
                var carouselPosts = $('.theme-posts-carousel-wrapper');
                
                // Iterate over each carousel element
                carouselPosts.each(function() {
                    // Get settings data for the current carousel
                    var carouselSettings = $(this).data('settings');
                    
                    // Find the swiper container within the current carousel
                    var carouselContainer = $(this).find('.swiper-container')[0];
                    
                    // Initialize Swiper for the current carousel
                    var swiper<?php echo $element_id ?> = new Swiper(carouselContainer, carouselSettings);

                    $('.swiper-prev-btn<?php echo $element_id ?>').on('click', function() {
                        swiper<?php echo $element_id ?>.slidePrev();
                    });

                    $('.swiper-next-btn<?php echo $element_id ?>').on('click', function() {
                        swiper<?php echo $element_id ?>.slideNext();

                    });
                });
            });

        </script>
        <?php
    }

}