<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_product_title extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_woo_product_title';
    }

    public function get_title() {
        return esc_html__('product title', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_product_title';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_style_section_1() {
        $this->start_controls_section(
            'login_form_style_section',
            [
                'label' => esc_html__( 'product title', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('theme_product_title',  '.theme-product-title');

        $this->end_controls_section();
    } 


    protected function register_controls() {

        $this->register_style_section_1();
    }

	protected function render() {
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
		if ( $this->theme_is_edit_mode() ) {
			$first_product_id = get_posts( array(
				'post_type' => 'product',
				'posts_per_page' => 1,
				'orderby' => 'ID',
				'order' => 'ASC',
				'fields' => 'ids',
			) );
			$first_product = wc_get_product( $first_product_id[0] );
			$product_title = $first_product->get_name();

			echo '<p class="theme-product-title">' . esc_html( $product_title ) . '</p>';
		} else {
			global $post;
			$product_id = get_the_ID();
			$product = wc_get_product( $product_id );

			if ( $product ) { // Check if $product is not null and has ID property
				$product_title = get_the_title( $product->ID );
                echo '<p class="theme-product-title">' . esc_html( $product_title ) . '</p>';
			} else {
				echo '<p class="theme-product-title">';
				echo esc_html__( 'reload page to get content', THEME_NAME);
				echo '</p>';
			}
		}
	}

}