<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_product_tab extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_woo_product_tab';
    }

    public function get_title() {
        return esc_html__('product tab', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_product_tab';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_content_section_1(){
        $this->start_controls_section(
            'tab_section',
            [
                'label' => __( 'tabs', THEME_NAME ),
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'tab_name',
            [
                'label' => __( 'title', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'title', THEME_NAME ),
            ]
        );

        $repeater->add_control(
            'body_centent',
            [
                'label'     => esc_html__( 'content', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'options'   => [
                    'product_desc'              => esc_html__( 'product description', THEME_NAME ),
                    'product_attr'       => esc_html__( 'product attribute', THEME_NAME ),
                ],
            ]
        );

        $repeater->add_control(
            'show_category',
            [
                'label'       => esc_html__( 'show category', THEME_NAME ),
                'type'        => \Elementor\Controls_Manager::SWITCHER,
            ]
        );

        $repeater->add_control(
            'show_tags',
            [
                'label'       => esc_html__( 'show tags', THEME_NAME ),
                'type'        => \Elementor\Controls_Manager::SWITCHER,
            ]
        );
        
        $this->add_control(
            'tabs',
            [
                'label' => __( 'categories', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [],
                'title_field' => '{{{ tab_name }}}',
                ]
        );
            
        $this->add_control(
            'product_attr_label',
            [
                'label'     => esc_html__( 'attribute label', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'product_attr_value',
            [
                'label'     => esc_html__( 'attribute value', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::TEXT,
            ]
        );
        $this->end_controls_section();
    }

    protected function register_style_section_1() {
        
        $this->start_controls_section(
            'container_section',
            [
                'label' => esc_html__( 'container', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_container_style('gallery',  '.gallery');

        $this->add_control(
		    'top_bar_section',
		    [
			    'label'     => esc_html__( 'top bar', THEME_NAME ),
			    'type'      => \Elementor\Controls_Manager::HEADING,
			    'separator' => 'before',
		    ]
	    );

        $this->register_container_style('tabs',  '.tabs');

        $this->add_control(
		    'noraml_btn_section',
		    [
			    'label'     => esc_html__( 'normal button', THEME_NAME ),
			    'type'      => \Elementor\Controls_Manager::HEADING,
			    'separator' => 'before',
		    ]
	    );

        $this->register_text_style('normal_tab',  '.tab-btn');

        $this->add_control(
		    'active_btn_section',
		    [
			    'label'     => esc_html__( 'active button', THEME_NAME ),
			    'type'      => \Elementor\Controls_Manager::HEADING,
			    'separator' => 'before',
		    ]
	    );


        $this->register_text_style('active_btn',  '.tab-btn.active');


        $this->end_controls_section();
    } 

    protected function register_style_section_2() {
        $this->start_controls_section(
            'product_description_section',
            [
                'label' => esc_html__( 'product description', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('product_text',  '.product-description');

        $this->end_controls_section();
    } 

    protected function register_style_section_3() {
        $this->start_controls_section(
            'product_attributes_section',
            [
                'label' => esc_html__( 'product attributes', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_table_style('product_attributes',  '.theme-product-attribute');

        $this->end_controls_section();
    } 

    protected function register_style_section_4() {
        $this->start_controls_section(
            'product_category_section',
            [
                'label' => esc_html__( 'product category', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'category_title',
			[
				'label' => esc_html__( 'category title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('product_category_title',  '.product-category-title', $align=false);

        $this->add_control(
			'category',
			[
				'label' => esc_html__( 'category', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('product_category',  '.product-category', $align=false);


        $this->add_control(
			'category-box',
			[
				'label' => esc_html__( 'category box', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('product_category_box',  '.product-category-box');

        $this->end_controls_section();
    }

    protected function register_style_section_5() {
        $this->start_controls_section(
            'product_tag_section',
            [
                'label' => esc_html__( 'product tag', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'tag_title',
			[
				'label' => esc_html__( 'tag title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('product_tag_title',  '.product-tag-title', $align=false);

        $this->add_control(
			'tag',
			[
				'label' => esc_html__( 'tag', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('product_tag',  '.product-tag', $align=false);


        $this->add_control(
			'category-box',
			[
				'label' => esc_html__( 'tag box', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('product_tag_box',  '.product-tag-box');

        $this->end_controls_section();
    }

    protected function register_controls() {

        $this->register_content_section_1();
        $this->register_style_section_1();
        $this->register_style_section_2();
        $this->register_style_section_3();
        $this->register_style_section_4();
        $this->register_style_section_5();
    }

    protected function render() {
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
        $settings = $this->get_settings_for_display();
		if ( empty( $settings['tabs'] ) ) {
			echo 'ابتدا دسته بندی ها را اضافه کنید';
			return;
		}
        echo '<div class="gallery">';
            echo '<div class="tabs">';
            foreach ($settings['tabs'] as $index => $tab) {
                $tab_id = 'tab' . ($index + 1);
                $tab_name = esc_html($tab['tab_name']);
                echo '<button class="tab-btn';
                echo ($index === 0) ? ' active' : '';
                echo '" data-category="' . $tab_id . '" onclick="show_widgets.call(this, \'' . $tab_id . '\')">' . $tab_name . '</button>';
            }
            echo '</div>';
            if ($this->theme_is_edit_mode()) {
                $first_product_id = get_posts(array(
                    'post_type'      => 'product',
                    'posts_per_page' => 1,
                    'orderby'        => 'ID',
                    'order'          => 'ASC',
                    'fields'         => 'ids',
                ));
                $first_product = wc_get_product($first_product_id[0]);
                
                if ($first_product) {
                    foreach ($settings['tabs'] as $index => $tab) {
                        $tab_id = 'tab' . ($index + 1);
                        echo '<div class="content"';
                        echo ($index === 0) ? ' style="display: flex;"' : 'style="display: none;"';
                        echo 'id="' . $tab_id . '">';
                        echo '<div class="gallery-cart">';
                        
                        if ($tab['body_centent'] == 'product_desc'){
                            echo '<div class="product-description">' .  wp_kses_post($first_product->get_description()) . '</div>';
                            
                            if ($tab['show_category']) {
                                $product_categories = wp_get_post_terms( $first_product_id[0], 'product_cat', array( 'fields' => 'all' ) );
                                echo '<div class="product-category-box">';
                                echo '<span class="product-category-title">' . esc_html__( 'category', THEME_NAME ) . ': </span>';
                                if ( ! empty( $product_categories ) ) {
                                    $count = count( $product_categories );
                                    $i     = 0;
                                    foreach ( $product_categories as $category ) {
                                        $category_url = get_term_link( $category );
                                        echo '<span><a class="product-category" href="' . esc_url( $category_url ) . '">' . esc_html( $category->name ) . '</a></span>';
                                        if ( ++$i !== $count ) {
                                            echo ', ';
                                        }
                                    }
                                }
                                echo '</div>';
                            }

                            if ($tab['show_tags']) {
                                $product_categories = wp_get_post_terms( $first_product_id[0], 'product_tag', array( 'fields' => 'all' ) );
                                echo '<div class="product-tag-box">';
                                echo '<span class="product-tag-title">' . esc_html__( 'tag', THEME_NAME ) . ': </span>';
                                if ( ! empty( $product_categories ) ) {
                                    foreach ( $product_categories as $category ) {
                                        $category_url = get_term_link( $category );
                                        echo '<span><a class="product-tag" href="' . esc_url( $category_url ) . '">' . esc_html( $category->name ) . '</a></span>';
                                    }
                                }
                                echo '</div>';
                            }

                            
                        }
                        if ($tab['body_centent'] == 'product_attr') {
                           echo '<table class="theme-product-attribute">';
                           if( $settings['product_attr_label']):
                                echo '<thead>';
                                echo '<tr>';
                                echo '<th>' . $settings['product_attr_label'] . '</th>';
                                echo '<th>'. $settings['product_attr_value'] . '</th>';
                                echo '</tr>';
                                echo '</thead>';
						    endif;
                           echo '<tbody>';
                           $product_attributes = $first_product->get_attributes();
                            foreach ($product_attributes as $attribute) {         
                                $options = $attribute->get_options();
                                
                                $attribute_values = [];
                                foreach ($options as $option) {
                                    $attribute_values[] = wp_kses_post($option);
                                }
                                
                                echo '<tr>';
                                echo '<td>' . wp_kses_post($attribute->get_name()) . '</td>';
                                echo '<td>' . implode(', ', $attribute_values) . '</td>';
                                echo '</tr>';
                            }
                            foreach (option_value('page-single-product-attribute') as $index => $item) {
                                echo '<tr>';
                                echo '<td>' . $item . '</td>';
                                $attr_id =get_post_meta( $first_product->get_id(), 'product_' . $index, true );
                                echo '<td>' . $attr_id . '</td>';
                                echo '</tr>';
                            }
                            echo '</tbody>';
                            echo '</table>';

                            if ( $tab['show_category'] ) {
                                $product_categories = wp_get_post_terms( $first_product_id[0], 'product_cat', array( 'fields' => 'all' ) );
                                echo '<div class="product-category-box">';
                                echo '<span class="product-category-title">' . esc_html__( 'category', THEME_NAME ) . ': </span>';
                                if ( ! empty( $product_categories ) ) {
                                    $count = count( $product_categories );
                                    $i = 0;
                                    foreach ( $product_categories as $category ) {
                                        $category_url = get_term_link( $category );
                                        echo '<span><a class="product-category" href="' . esc_url( $category_url ) . '">' . esc_html( $category->name ) . '</a></span>';
                                        if ( ++$i !== $count ) {
                                            echo ', ';
                                        }
                                    }
                                }
                                echo '</div>';
                            }

                            if ( $tab['show_tags'] ) {
                                $product_categories = wp_get_post_terms( $first_product_id[0], 'product_tag', array( 'fields' => 'all' ) );
                                echo '<div class="product-tag-box">';
                                echo '<span class="product-tag-title">' . esc_html__( 'tag', THEME_NAME ) . ': </span>';
                                if ( ! empty( $product_categories ) ) {
                                    foreach ( $product_categories as $category ) {
                                        $category_url = get_term_link( $category );
                                        echo '<span><a class="product-tag" href="' . esc_url( $category_url ) . '">' . esc_html( $category->name ) . '</a></span>';
                                    }
                                }
                                echo '</div>';
                            }
                        }

                        echo '</div>';
                        echo '</div>'; 
                    }
                }
            }

            else {
                global $post;
                $product_slug = $post->post_name;
                $product = get_page_by_path($product_slug, OBJECT, 'product');
                if ($product) {

                    foreach ($settings['tabs'] as $index => $tab) {
                        $tab_id = 'tab' . ($index + 1);
                        echo '<div class="content"';
                        echo ($index === 0) ? ' style="display: flex;"' : 'style="display: none;"';
                        echo 'id="' . $tab_id . '">';
                        echo '<div class="gallery-cart">';
                        $product_attributes = $product ? wc_get_product($product->ID)->get_attributes() : [];
                        if ($tab['body_centent'] == 'product_desc'){
                            echo '<div class="product-description">' .  wp_kses_post($product->post_content) . '</div>';
                            
                            if ($tab['show_category']) {
                                $product_categories = wp_get_post_terms( $product->ID, 'product_cat', array( 'fields' => 'all' ) );
                                echo '<div class="product-category-box">';
                                echo '<span class="product-category-title">' . esc_html__( 'category', THEME_NAME ) . ': </span>';
                                if ( ! empty( $product_categories ) ) {
                                    $count = count( $product_categories );
                                    $i     = 0;
                                    foreach ( $product_categories as $category ) {
                                        $category_url = get_term_link( $category );
                                        echo '<span><a href="' . esc_url( $category_url ) . '">' . esc_html( $category->name ) . '</a></span>';
                                        if ( ++$i !== $count ) {
                                            echo ', ';
                                        }
                                    }
                                }
                                echo '</div>';
                            }

                            if ($tab['show_tags']) {
                                $product_categories = wp_get_post_terms( $product->ID, 'product_tag', array( 'fields' => 'all' ) );
                                echo '<div class="product-tag-box">';
                                echo '<span class="product-tag-title">' . esc_html__( 'tag', THEME_NAME ) . ': </span>';
                                if ( ! empty( $product_categories ) ) {
                                    foreach ( $product_categories as $category ) {
                                        $category_url = get_term_link( $category );
                                        echo '<span><a class="product-tag" href="' . esc_url( $category_url ) . '">' . esc_html( $category->name ) . '</a></span>';
                                    }
                                }
                                echo '</div>';
                            }
                        }
                       if ($tab['body_centent'] == 'product_attr') {
                           echo '<table class="theme-product-attribute">';
                            if ( $settings['product_attr_label'] ) :
                                echo '<thead>';
                                echo '<tr>';
                                echo '<th>' . $settings['product_attr_label'] . '</th>';
                                echo '<th>' . $settings['product_attr_value'] . '</th>';
                                echo '</tr>';
                                echo '</thead>';
						    endif;
                           echo '<tbody>';
                            foreach ($product_attributes as $attribute) {         
                                $options = $attribute->get_options();
                                
                                $attribute_values = [];
                                foreach ($options as $option) {
                                    $attribute_values[] = wp_kses_post($option);
                                }
                                
                                echo '<tr>';
                                echo '<td>' . wp_kses_post($attribute->get_name()) . '</td>';
                                echo '<td>' . implode(', ', $attribute_values) . '</td>';
                                echo '</tr>';
                            }
                            foreach (option_value('page-single-product-attribute') as $index => $item) {
                                echo '<tr>';
                                echo '<td>' . $item . '</td>';
                                $attr_id =get_post_meta( get_the_ID(), 'product_' . $index, true );
                                echo '<td>' . $attr_id . '</td>';
                                echo '</tr>';
                            }
                            echo '</tbody>';
                            echo '</table>';
                        }

                        echo '</div>';
                        echo '</div>'; 
                    }
                }
            }
        echo '</div>';
    }

}