<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_product_sku extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_woo_product_sku';
    }

    public function get_title() {
        return esc_html__('product sku', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_product_sku';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_style_section_1() {
        $this->start_controls_section(
            'login_form_style_section',
            [
                'label' => esc_html__( 'product sku', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('theme_product_sku',  '.theme-product-sku');

        $this->end_controls_section();
    } 


    protected function register_controls() {

        $this->register_style_section_1();
    }

	protected function render() {
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
		if ( $this->theme_is_edit_mode() ) {
			echo '<p class="theme-product-sku">766545678</p>';
		} else {
			global $post;
			$product_id = get_the_ID();
			$product = wc_get_product( $product_id );

			if ( $product ) { // Check if $product is not null and has ID property
				$sku = $product->get_id();
                echo '<p class="theme-product-sku">' . esc_html( $sku ) . '</p>';
			}
		}
	}

}