<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_product_short_desc extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_woo_product_short_desc';
    }

    public function get_title() {
        return esc_html__('product short description', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_product_short_desc';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }


    protected function register_style_section_1() {
        $this->start_controls_section(
            'product_price_style_section',
            [
                'label' => esc_html__( 'description', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('product_categories',  '.product-short-description');

        $this->end_controls_section();

    } 

    protected function register_controls() {

        $this->register_style_section_1();
    }

    protected function render() {
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
        if ($this->theme_is_edit_mode()) {
            // This part of the code remains the same
            $first_product_id = get_posts(array(
                'post_type'      => 'product',
                'posts_per_page' => 1,
                'orderby'        => 'ID',
                'order'          => 'ASC',
                'fields'         => 'ids',
            ));
            $first_product = wc_get_product($first_product_id[0]);

            // Output the short description
            echo '<div class="product-short-description">';
            echo $first_product->get_short_description();
            echo '</div>';
        } else {
			global $post;
			$product_id = get_the_ID();
			$product = wc_get_product( $product_id );
            if ($product) {
                // Output the short description
                echo '<div class="product-short-description">';
                echo $product->get_short_description();
                echo '</div>';
            }
        }
    }

}