<?php



use handler\Group_Control_Query;
use handler\Post_skin_base;
use handler\basic_element;
use handler\swiper;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_product_gallery_pro extends \Elementor\Widget_Base {

    use Group_Control_Query;
    use Post_skin_base;
    use basic_element;
    use swiper;

    public function get_name() {
        return 'ar_woo_product_gallery_pro';
    }

    public function get_title() {
        return esc_html__('product gallery pro', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_product_gallery_pro';
    }

    protected function get_html_wrapper_class() {
        return $this->get_name() . '-widget';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }


    protected function register_style_section_1() {
        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Style', THEME_NAME),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'thumb-gallery',
            [
                'label'     => esc_html__( 'show thumb gallery', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SWITCHER,
                'default'   => 'yes',
            ]
        );

        $this->register_image_style('slider-image', 'img' );
        $this->end_controls_section();
    }

    protected function register_controls() {

        $this->register_style_section_1();
        $this->register_carousel_controls();

        $this->register_style_carousel_controls();

    }

    protected function render(){
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
        $settings = $this->get_settings_for_display();
		$id = 'theme-carousel-' . $this->get_id();
        if ($this->theme_is_edit_mode()) {
            ?>
            <style>
                .mySwiper {
                    height: 20%;
                    box-sizing: border-box;
                    padding: 10px 0;
                }

                .mySwiper .swiper-slide {
                    width: 25%;
                    height: 100%;
                    opacity: 0.4;
                }

                .mySwiper .swiper-slide-thumb-active {
                    opacity: 1;
                }

            </style>
            <div class="layout-carousel">
                <?php $this->render_carousel_header(); ?>
                <?php
                    for ($i = 1; $i <= 4; $i++)  {?>
                        <div class="swiper-slide triger">
                            <div class="woocommerce-product-gallery__image--placeholder">
                                <?php echo sprintf( '<img src="%s" alt="%s" class="theme-product-image" />', esc_url( wc_placeholder_img_src( 'woocommerce_single' ) ), esc_html__( 'Awaiting product image', 'woocommerce' ) ); ?>
                            </div>
                        </div>
                        <?php
                    }
                ?>
                <?php $this->render_carousel_footer(); ?>
            </div>
            <?php if($settings['thumb-gallery']): ?>
                <div thumbsSlider="" class="swiper mySwiper" style="overflow: hidden;">
                    <div class="swiper-wrapper">
                        <?php
                        for ($i = 1; $i <= 4; $i++)  {?>
                            <div class="swiper-slide">
                                <div class="woocommerce-product-gallery__image--placeholder">
                                    <?php echo sprintf( '<img src="%s" alt="%s" class="theme-product-image" />', esc_url( wc_placeholder_img_src( 'woocommerce_single' ) ), esc_html__( 'Awaiting product image', 'woocommerce' ) ); ?>
                                </div>
                            </div>
                            <?php
                        }
                        ?>
                    </div>
                </div>
            <?php endif; ?>
            <div class="theme-modal" id="modal-gallery">
				<span class="close-btn">&times;</span>
				<div class="theme-modal-content" id="<?php echo $id ?>">
					<div class="swiper swiper-modal">
                        <div class="swiper-wrapper">
                            <?php
								for ( $i = 1; $i <= 4; $i++ ) { ?>
								<div class="swiper-slide">
									<div class="woocommerce-product-gallery__image--placeholder">
										<?php echo sprintf( '<img src="%s" alt="%s" class="theme-product-image" />', esc_url( wc_placeholder_img_src( 'woocommerce_single' ) ), esc_html__( 'Awaiting product image', 'woocommerce' ) ); ?>
									</div>
								</div>
								<?php
								}
								?>
                        </div>
                    </div>
                    <?php
                    if ( $settings['carousel_arrows'] ) {
                        $carousel_nav_cls = 'carousel-nav-wrapper';
                        $carousel_nav_cls .= ' theme-position-' . esc_html($settings['carousel_arrows_position']);
                        $carousel_nav_cls .= $settings['carousel_arrow_show_on_hover']? ' show-on-hover' : '';
                        $carousel_nav_cls .= $settings['carousel_hide_arrow_mobile']? ' elementor-hidden-mobile' : '';

                        ?>
                        <div class="<?php echo esc_html($carousel_nav_cls); ?>">
                            <a href="" class="carousel-nav-next">
                                <i class="<?php echo esc_html($settings['carousel_arrows_icon']); ?>"></i>
                            </a>
                            <a href="" class="carousel-nav-prev">
                                <i class="<?php echo esc_html($settings['carousel_arrows_icon']); ?>"></i>
                            </a>
                        </div>
                        <?php
                    }

                    // Pagination
                    if ( $settings['carousel_pagination'] ) {
                        $pagination_cls = 'carousel-pagination-wrapper';
                        $pagination_cls .= ' type-' . esc_html($settings['carousel_pagination_type']);
                        $pagination_cls .= ' theme-position-' . esc_html($settings['carousel_pagination_position']);

                        ?>
                        <div class="<?php echo esc_html($pagination_cls); ?>">
                            <div class="carousel-pagination"></div>
                        </div>
                        <?php
                    }
                    ?>
                </div>
            </div>
        <?php
        } else {
			global $post;
			$product_id = get_the_ID();
			$product = wc_get_product( $product_id );
            if ($product) {
                $product_image_id = get_post_thumbnail_id( $product->ID );
				$product_image_url = wp_get_attachment_image_url( $product_image_id, 'full' );
                $gallery_images = $product->get_gallery_image_ids();
                ?>
                <div class="layout-carousel">
                    <?php $this->render_carousel_header(); ?>
                    <div class="swiper-slide triger">
                        <?php echo '<img class="theme-product-image" src="' . esc_url( $product_image_url ) . '" alt="' . esc_attr( get_the_title( $product->ID ) ) . '" />'; ?>
                    </div>
                    <?php
                        foreach ($gallery_images as $image_id) { ?>
                            <div class="swiper-slide triger">
                                <?php echo wp_get_attachment_image($image_id, 'full'); ?>
                            </div>
                        <?php
                        }
                    ?>
                    <?php $this->render_carousel_footer(); ?>
                </div>
                <?php if($settings['thumb-gallery']): ?>
                    <div thumbsSlider="" class="swiper mySwiper" style="overflow: hidden;">
                        <div class="swiper-wrapper">
                            <div class="swiper-slide">
                                <?php echo '<img class="theme-product-image" src="' . esc_url( $product_image_url ) . '" alt="' . esc_attr( get_the_title( $product->ID ) ) . '" />'; ?>
                            </div>
                            <?php
                                foreach ( $gallery_images as $image_id ) { ?>
                                    <div class="swiper-slide">
                                        <?php echo wp_get_attachment_image( $image_id, 'full' ); ?>
                                    </div>
                                <?php
                                }
                            ?>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="theme-modal" id="modal-gallery">
                    <style>
                        .theme-modal-content{
                            overflow: visible;
                        }
                        .close-btn {
                            position: absolute;
                            font-size: 24px;
                            cursor: pointer;
                            padding: 0px;
                            z-index: 9999;
                            margin: -10px;
                            font-size: 50px;
                            line-height: 19px;
                            bottom: -50px;
                            right: auto;
                            left: 50%;
                            border-radius: 100%;
                            background-color: #FEC752;
                        }

                        .close-btn::before{
                            content: '';
                            width: 130%;
                            height: 130%;
                            display: block;
                            background: #FFEECB;
                            position: absolute;
                            opacity: 0.1;
                            border-radius: 100%;
                            left: -5px;
                            top: -5px;
                        }
                        .close-btn svg{
                            width: 35px;
                            height: 35px;
                        }

                        .ar_woo_product_gallery_pro-widget .swiper-slide img{
                            width:100% !important;
                        }
                    </style>
                    <div class="theme-modal-content" id="<?php echo $id ?>">
                        <span class="close-btn">
                            <svg xmlns="http://www.w3.org/2000/svg" width="46" height="46" viewBox="0 0 46 46" fill="none">
                                <path d="M16.9707 28.2842L28.2844 16.9705" stroke="#656565" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M28.2844 28.2844L16.9707 16.9707" stroke="#656565" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </span>
                        <div class="swiper swiper-modal">
                            <div class="swiper-wrapper">
                                <div class="swiper-slide">
                                    <?php echo '<img class="theme-product-image" src="' . esc_url( $product_image_url ) . '" alt="' . esc_attr( get_the_title( $product->ID ) ) . '" />'; ?>
                                </div>
                                <?php
                                    foreach ( $gallery_images as $image_id ) { ?>
                                        <div class="swiper-slide">
                                            <?php echo wp_get_attachment_image( $image_id, 'full' ); ?>
                                        </div>
                                        <?php
                                    }
                                    ?>
                                </div>
                                <?php
                                if ( $settings['carousel_arrows'] ) {
                                    $carousel_nav_cls = 'carousel-nav-wrapper';
                                    $carousel_nav_cls .= ' theme-position-' . esc_html( $settings['carousel_arrows_position'] );
                                    $carousel_nav_cls .= $settings['carousel_arrow_show_on_hover'] ? ' show-on-hover' : '';
                                    $carousel_nav_cls .= $settings['carousel_hide_arrow_mobile'] ? ' elementor-hidden-mobile' : '';

                                    ?>
                                    <div class="<?php echo esc_html( $carousel_nav_cls ); ?>">
                                        <a href="" class="carousel-nav-next">
                                            <i class="<?php echo esc_html( $settings['carousel_arrows_icon'] ); ?>"></i>
                                        </a>
                                        <a href="" class="carousel-nav-prev">
                                            <i class="<?php echo esc_html( $settings['carousel_arrows_icon'] ); ?>"></i>
                                        </a>
                                    </div>
                                    <?php
                                }

                                // Pagination
                                if ( $settings['carousel_pagination'] ) {
                                    $pagination_cls = 'carousel-pagination-wrapper';
                                    $pagination_cls .= ' type-' . esc_html( $settings['carousel_pagination_type'] );
                                    $pagination_cls .= ' theme-position-' . esc_html( $settings['carousel_pagination_position'] );

                                    ?>
                                    <div class="<?php echo esc_html( $pagination_cls ); ?>">
                                        <div class="carousel-pagination"></div>
                                    </div>
                                    <?php
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                <?php
            }   
        }
        ?>
        <script>
            jQuery(document).ready(function($) {
                <?php if($settings['thumb-gallery']): ?>
                var swiper = new Swiper(".mySwiper", {
                    loop: true,
                    spaceBetween: 10,
                    slidesPerView: 4,
                    freeMode: true,
                    watchSlidesProgress: true,
                });
                <?php endif; ?>
                var carouselPosts = $('.theme-posts-carousel-wrapper');
                carouselPosts.each(function() {
                    var carouselSettings = $(this).data('settings');
                    <?php if($settings['thumb-gallery']): ?>
                    carouselSettings.thumbs = {
                        swiper: swiper 
                    };
                    <?php endif; ?>
                    var carouselContainer = $(this).find('.swiper-container')[0];
                    var swiper2 = new Swiper(carouselContainer, carouselSettings);
                    var swiper_modal = new Swiper(".swiper-modal", carouselSettings);
                });


                $('.triger').on('click', function() {
                    const slideIndex = $(this).data('slide-index');
                    const modal = $('#modal-gallery');

                    // Add 'open' class to show the modal
                    modal.addClass('open');

                    // Close modal when clicking close button
                    modal.find('.close-btn').on('click', function() {
                        modal.removeClass('open');
                    });

                    // Close modal when clicking outside of modal content
                    modal.on('click', function(event) {
                        if ($(event.target).hasClass('modal-content')) {
                            modal.removeClass('open');
                        }
                    });
                });
            });

        </script>
        <?php
    }
}