<?php



use handler\Group_Control_Query;
use handler\Post_skin_base;
use handler\basic_element;
use handler\swiper;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly


class ar_woo_product_gallery extends \Elementor\Widget_Base {

	use Group_Control_Query;
	use Post_skin_base;
	use basic_element;
	use swiper;

	public function get_name() {
		return 'ar_woo_product_gallery';
	}

	public function get_title() {
		return esc_html__( 'product gallery', THEME_NAME );
	}

	public function get_icon() {
		return 'ar_woo_product_gallery';
	}

	protected function get_html_wrapper_class() {
		return $this->get_name() . '-widget';
	}

	public function get_categories() {
		return [ 'core-elementor-elements' ];
	}


	protected function register_content_section_1() {

		$this->start_controls_section(
			'section_layout',
			[ 
				'label' => esc_html__( 'Layout', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout',
			[ 
				'label' => esc_html__( 'Layout', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [ 
					'grid' => esc_html__( 'Grid', THEME_NAME ),
					'carousel' => esc_html__( 'Carousel', THEME_NAME ),
				],
				'default' => 'grid',
			]
		);

		$this->add_responsive_control(
			'columns',
			[ 
				'label' => esc_html__( 'Columns', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '3',
				'tablet_default' => '2',
				'mobile_default' => '1',
				'options' => [ 
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
				],
				'render_type' => 'template',
				'selectors' => [ 
					'{{WRAPPER}} .theme-posts-wrapper.layout-grid' => 'grid-template-columns: repeat({{SIZE}}, 1fr);',
					'{{WRAPPER}} .theme-posts-wrapper.layout-carousel .post-item' => 'width: calc(100% / {{SIZE}});',
				],
			]
		);

		$this->add_responsive_control(
			'column_gap',
			[ 
				'label' => esc_html__( 'Column Gap', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'default' => [ 
					'size' => '20',
				],
				'range' => [ 
					'px' => [ 
						'min' => 0,
						'max' => 100,
					],
				],
				'render_type' => 'template',
				'selectors' => [ 
					'{{WRAPPER}} .theme-posts-wrapper.layout-grid' => 'column-gap: {{SIZE}}{{UNIT}};',
					'body:not(.rtl) {{WRAPPER}} .theme-posts-wrapper.layout-carousel .post-item' => 'margin-right: {{SIZE}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .theme-posts-wrapper.layout-carousel .post-item' => 'margin-left: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'row_gap',
			[ 
				'label' => esc_html__( 'Row Gap', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'default' => [ 
					'size' => '20',
				],
				'range' => [ 
					'px' => [ 
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [ 
					'{{WRAPPER}} .theme-posts-wrapper.layout-grid' => 'row-gap: {{SIZE}}{{UNIT}};',
				],
				'condition' => [ 
					'layout!' => 'carousel',
				],
			]
		);

		$this->end_controls_section();

	}

	protected function register_style_section_1() {
		$this->start_controls_section(
			'section_style',
			[ 
				'label' => esc_html__( 'Style', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->register_image_style( 'slider-image', 'img' );
		$this->end_controls_section();
	}

	protected function register_controls() {

		$this->register_content_section_1();
		$this->register_style_section_1();
		$this->register_carousel_controls();

		$this->register_style_carousel_controls();

	}

	protected function render() {
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
		$settings = $this->get_settings_for_display();
		$cls = '';
		if ( $settings['layout'] != 'carousel' ) {
			$cls .= 'theme-posts-wrapper';
		}
		if ( $this->theme_is_edit_mode() ) {
			?>
			<div class=" <?php echo $cls . ' layout-' . $settings['layout'] ?>">
				<?php $this->render_carousel_header(); ?>
				<?php
				for ( $i = 1; $i <= 4; $i++ ) {
					$post_item_cls = '';
					if ( $settings['layout'] == 'carousel' ) {
						$post_item_cls .= ' swiper-slide';
					} ?>
					<div class="<?php echo esc_html( $post_item_cls ); ?>">
						<div class="woocommerce-product-gallery__image--placeholder">
							<?php echo sprintf( '<a href="%s" ><img src="%s" alt="%s" class="theme-product-image" /></a>', esc_url( wc_placeholder_img_src( 'woocommerce_single' ) ), esc_url( wc_placeholder_img_src( 'woocommerce_single' ) ), esc_html__( 'Awaiting product image', 'woocommerce' ) ); ?>
						</div>
					</div>
					<?php
				}
				?>
				<?php $this->render_carousel_footer(); ?>
			</div>
			<?php
		} else {
			global $post;
			$product_id = get_the_ID();
			$product = wc_get_product( $product_id );
			if ( $product ) {
				$gallery_images = $product->get_gallery_image_ids();
				?>
				<div class="<?php echo $cls . ' layout-' . $settings['layout'] ?>">
					<?php $this->render_carousel_header(); ?>
					<?php
					foreach ( $gallery_images as $image_id ) {
						$post_item_cls = '';
						if ( $settings['layout'] == 'carousel' ) {
							$post_item_cls .= ' swiper-slide';
						}
						?>
						<div class="<?php echo esc_html( $post_item_cls ); ?>">
							<?php
							$full_image_url = wp_get_attachment_image_url( $image_id, 'full' );
							echo sprintf( '<a href="%s">%s</a>', esc_url( $full_image_url ), wp_get_attachment_image( $image_id, 'full' ) );
							?>
						</div>
						<?php
					}
					?>
					<?php $this->render_carousel_footer(); ?>
				</div>
				<?php
			}
		}
        ?>
        <script>
            jQuery(document).ready(function($) {

                var carouselPosts = $('.theme-posts-carousel-wrapper');
                console.log(carouselPosts);
                carouselPosts.each(function() {
                    var carouselSettings = $(this).data('settings');
                    var carouselContainer = $(this).find('.swiper-container')[0];
                    var swiper = new Swiper(carouselContainer, carouselSettings);
                });
            });

        </script>
        <?php
	}
}