<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_product_comments_count extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_woo_product_comments_count';
    }

    public function get_title() {
        return esc_html__('product comments count', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_product_comments_count';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_content_section_1() {
        $this->start_controls_section(
            'section_general',
            [
                'label' => esc_html__( 'text', THEME_NAME ),
            ]
        );

        $this->add_control(
            'text',
            [
                'label' => esc_html__( 'Text', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->end_controls_section();

    } 
    protected function register_style_section_1() {
        $this->start_controls_section(
            'product_price_style_section',
            [
                'label' => esc_html__( 'rating', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('comment_count',  '.comment-count');

        $this->end_controls_section();

    } 

    protected function register_controls() {

        $this->register_content_section_1();
        $this->register_style_section_1();
    }

    protected function render() {
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
        $settings = $this->get_settings_for_display();

        if ($this->theme_is_edit_mode()) {
            $first_product_id = get_posts(array(
                'post_type'      => 'product',
                'posts_per_page' => 1,
                'orderby'        => 'ID',
                'order'          => 'ASC',
                'fields'         => 'ids',
            ));
            $first_product = wc_get_product($first_product_id[0]);
            $comment_count = $first_product->get_review_count(); 
            echo '<p class="comment-count">' . $comment_count . $settings['text'] . '</p>';

        } else {
			global $post;
			$product_id = get_the_ID();
			$product = wc_get_product( $product_id );
            if ($product) {
                $comment_count = wc_get_product($product)->get_review_count(); 
                echo '<p class="comment-count">' . $comment_count . $settings['text'] . '</p>';
            }
        }
    }

}