<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_product_add_to_cart_btn extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_woo_product_add_to_cart_btn';
    }

    public function get_title() {
        return esc_html__('product add to cart button', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_product_add_to_cart_btn';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }


    protected function register_content_section_1() {
        $this->start_controls_section(
            'section_general',
            [
                'label' => esc_html__( 'text', THEME_NAME ),
            ]
        );

        $this->add_control(
            'text',
            [
                'label' => esc_html__( 'Text', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->end_controls_section();

    } 

    protected function register_style_section_1() {
        $this->start_controls_section(
            'product_price_style_section',
            [
                'label' => esc_html__( 'style', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('product_categories',  '.single_add_to_cart_button', $align = false);
        
        $this->end_controls_section();

    } 

    protected function register_controls() {

        $this->register_content_section_1();
        $this->register_style_section_1();
    }


    protected function render() {
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
        $settings = $this->get_settings_for_display();

        if ($this->theme_is_edit_mode()) {
            $first_product_id = get_posts(array(
                'post_type'      => 'product',
                'posts_per_page' => 1,
                'orderby'        => 'ID',
                'order'          => 'ASC',
                'fields'         => 'ids',
            ));

            echo '<form class="cart theme-add-to-cart" method="post" enctype="multipart/form-data">';
            echo '<input type="hidden" name="add-to-cart" value="" />';
            // Output Quantity input field
            echo '<div class="quantity">';
            echo '<input type="hidden" id="quantity" class="quantity-input" name="quantity" value="1" min="1" max="999" step="1" />';
            echo '</div>';
            // Output Add to Cart button
            echo '<button type="submit" class="single_add_to_cart_button button alt">' . $settings['text'] . '</button>';
            echo '</form>';

        } else {
			global $post;
            $post_id = get_the_ID();
			$product_id = $post_id;
			$product = wc_get_product( $product_id );

            if ($product) {
                // Get product ID
                $product_id = $product_id;
                // Get product price
                $product_price = wc_get_product($product)->get_sale_price();
                $max_quantity  = wc_get_product($product)->get_stock_quantity();
                $max_quantity = $max_quantity ? $max_quantity : 999;
                // Output Add to Cart form
                echo '<form class="cart theme-add-to-cart" method="post" enctype="multipart/form-data">';
			    wp_nonce_field( 'add_to_cart_single', 'add_to_cart_nonce_single' );

				echo '<input type="hidden" name="add-to-cart" value="' . esc_attr($product_id) . '" />';
                // Output Quantity input field
                echo '<div class="quantity">';
                echo '<input type="hidden" id="quantity" class="quantity-input" name="quantity" value="1" min="1" max="' . $max_quantity . '" step="1" />';
                echo '</div>';
                // Output Add to Cart button
                echo '<button type="submit" class="single_add_to_cart_button button alt">' . $settings['text'] . '</button>';
                echo '</form>';
            }
        }
        ?>
        <?php
    }

}