<?php

use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_coupon extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_woo_coupon';
    }

    public function get_title() {
        return esc_html__('cart coupon', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_coupon';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_style_section_1() {
        $this->start_controls_section(
            'woocommerce-coupon-form-input',
            [
                'label' => __( 'coupon input', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('woocommerce-coupon-form-input',  'input');

        $this->add_control(
			'woocommerce-coupon-form-label',
			[
				'label' => esc_html__( 'labels', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('woocommerce-coupon-form-label',  'label', $align=false);
        
        $this->end_controls_section();
    }

    protected function register_style_section_2() {
        $this->start_controls_section(
            'button',
		    [
			    'label' => esc_html__('button', THEME_NAME),
			    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		    ]
	    );
        $this->register_text_style('button',  'button', $align=false);
    }

    protected function register_controls() {

        $this->register_style_section_1();
        $this->register_style_section_2();

    }
    protected function add_coupon($content, $form_class=''){
        ob_start();
        ?>
        <form class="<?php echo esc_attr($form_class)?>" action="<?php echo esc_url( wc_get_cart_url() ); ?>" method="post">
            <?php echo $content?>
        </form>
        <?php 
        return apply_filters('dhwc_elementor_cart_form_wapper_output', ob_get_clean());
    }
    protected function render(){
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
        if ( $this->theme_is_edit_mode()) {
			wc_enqueue_js('jQuery(function(n){n(document).on("click",".woocommerce-coupon-form :input[type=submit]",function(o){n(":input[type=submit]",n(o.target).parents("form")).removeAttr("clicked"),n(o.target).attr("clicked","true")}),n(document.body).on("applied_coupon",function(){n(".woocommerce-coupon-form").removeClass("processing").unblock()}),n(".woocommerce-coupon-form").on("submit",function(o){n(document.activeElement),n(":input[type=submit][clicked=true]");var e,t,c=n(o.currentTarget);(t=e=c).is(".processing")||t.parents(".processing").length||e.addClass("processing").block({message:null,overlayCSS:{background:"#fff",opacity:.6}}),n(".woocommerce-cart-form").trigger("submit"),o.preventDefault(),o.stopPropagation()})});');
            ob_start();
            ?>
            <div class="cart-coupons">
                <div class="form-row form-row-first">
                    <label><?php _e( 'Coupon', 'woocommerce' ); ?></label>
                    <input type="text" name="coupon_code" class="input-text" placeholder="<?php esc_attr_e( 'Coupon code', 'woocommerce' ); ?>" id="coupon_code" value="" />
                </div>
                <button type="submit" class="button" name="apply_coupon" value="<?php esc_attr_e( 'Apply coupon', 'woocommerce' ); ?>"><?php esc_html_e( 'Apply coupon', 'woocommerce' ); ?></button>

            </div>
            
            <div class="clear"></div>
            <?php
            echo $this->add_coupon(ob_get_clean(),'woocommerce-coupon-form');
        }
        else{
            if ( !WC()->cart->is_empty() ) {
                ob_start();
                ?>
                <div class="cart-coupons">
                    <div class="form-row form-row-first">
                        <label><?php _e( 'Coupon', 'woocommerce' ); ?></label>
                        <input type="text" name="coupon_code" class="input-text" placeholder="<?php esc_attr_e( 'Coupon code', 'woocommerce' ); ?>" id="coupon_code" value="" />
                    </div>
                    <button type="submit" class="button" name="apply_coupon" value="<?php esc_attr_e( 'Apply coupon', 'woocommerce' ); ?>"><?php esc_html_e( 'Apply coupon', 'woocommerce' ); ?></button>
        
                </div>
                
                <div class="clear"></div>
                <?php 
                echo $this->add_coupon(ob_get_clean(),'woocommerce-coupon-form');
            }
        }
     
	}
}