<?php

use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly


class ar_woo_account extends \Elementor\Widget_Base {

	use basic_element;


	public function get_name() {
		return 'ar_woo_account';
	}

	public function get_title() {
		return esc_html__( 'account', THEME_NAME );
	}

	public function get_icon() {
		return 'ar_woo_account';
	}

	public function get_categories() {
		return [ 'core-elementor-elements' ];
	}

	protected function register_style_section_1() {
		$this->start_controls_section( 'navigation_style_section',
			[ 
				'label' => esc_html__( 'navigation', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_container_style( 'navigation', '.woocommerce-MyAccount-navigation ul' );

		$this->end_controls_section();
	}

	protected function register_style_section_2() {
		$this->start_controls_section( 'top_nav_style_section',
			[ 
				'label' => esc_html__( 'top nav', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_container_style( 'top-nav', '.woocommerce-top-navigation' );

		$this->add_control(
			'avatar',
			[ 
				'label' => esc_html__( 'avatar', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_image_style( 'avatar', '.woocommerce-top-navigation img' );

		$this->add_control(
			'name',
			[ 
				'label' => esc_html__( 'name', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'name', '.name' );

		$this->add_control(
			'user_code',
			[ 
				'label' => esc_html__( 'user code', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'user_code', '.user_code', $align = false );

		$this->add_control(
			'user_code_value',
			[ 
				'label' => esc_html__( 'user code value', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'user_code_value', '.user_code_value', $align = false );


		$this->add_control(
			'edit_icon',
			[ 
				'label' => esc_html__( 'edit icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'edit_icon', '.woocommerce-top-navigation a', $align = false );


		$this->end_controls_section();
	}

	protected function register_style_section_3() {
		$this->start_controls_section(
			'section_style_items',
			[ 
				'label' => esc_html__( 'Items', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'icon-separator-items',
			[ 
				'label' => esc_html__( 'items', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_container_style( 'tabs', '.woocommerce-MyAccount-navigation-link', $align = false );

		$this->start_controls_tabs( 'tabs_item_style' );

		$this->start_controls_tab(
			'tab_item_normal',
			[ 
				'label' => esc_html__( 'Normal', THEME_NAME ),
			]
		);

		$this->register_text_style( 'normal_tab', '.woocommerce-MyAccount-navigation-link', $align = false );

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_item_hover',
			[ 
				'label' => esc_html__( 'Hover', THEME_NAME ),
			]
		);

		$this->register_text_style( 'hover_tab', '.woocommerce-MyAccount-navigation-link:hover', $align = false );


		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_item_active',
			[ 
				'label' => esc_html__( 'active', THEME_NAME ),
			]
		);


		$this->register_text_style( 'active_tab', '.woocommerce-MyAccount-navigation-link.is-active', $align = false );

		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->add_control(
			'icon-separator',
			[ 
				'label' => esc_html__( 'icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->start_controls_tabs( 'tabs_item_icons' );

		$this->start_controls_tab(
			'icon_normal',
			[ 
				'label' => esc_html__( 'normal', THEME_NAME ),
			]
		);

		$this->add_control(
			'top-icon-separator-normal',
			[ 
				'label' => esc_html__( 'top icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);
		$this->register_text_style( 'top_normal_icon_set', '.woocommerce-MyAccount-navigation-link .isax.top', $align = false );

		$this->add_control(
			'btm-icon-separator-normal',
			[ 
				'label' => esc_html__( 'icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'normal_icon_set', '.woocommerce-MyAccount-navigation-link .isax', $align = false );


		$this->end_controls_tab();

		$this->start_controls_tab(
			'icon_hover',
			[ 
				'label' => esc_html__( 'Hover', THEME_NAME ),
			]
		);

		$this->add_control(
			'top-icon-separator-hover',
			[ 
				'label' => esc_html__( 'top icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'top_hover_icon_set', '.woocommerce-MyAccount-navigation-link:hover .isax.top', $align = false );

		$this->add_control(
			'btm-icon-separator-hover',
			[ 
				'label' => esc_html__( 'icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'hover_icon_set', '.woocommerce-MyAccount-navigation-link:hover .isax', $align = false );

		$this->add_control(
			'hover_line_sep',
			[ 
				'label' => esc_html__( 'line', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_container_style( 'hover_line_set', '.woocommerce-MyAccount-navigation-link a:before' );

		$this->end_controls_tab();

		$this->start_controls_tab(
			'icon_active',
			[ 
				'label' => esc_html__( 'active', THEME_NAME ),
			]
		);

		$this->add_control(
			'top-icon-separator-active',
			[ 
				'label' => esc_html__( 'top icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'top_active_icon_set', '.woocommerce-MyAccount-navigation-link.is-active .isax.top', $align = false );

		$this->add_control(
			'btm-icon-separator-active',
			[ 
				'label' => esc_html__( 'icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'active_icon_set', '.woocommerce-MyAccount-navigation-link.is-active .isax', $align = false );

		$this->add_control(
			'active_line_sep',
			[ 
				'label' => esc_html__( 'line', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_container_style( 'active_line_set', '.woocommerce-MyAccount-navigation-link.is-active a:before' );


		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

	}

	protected function register_style_section_4() {
		$this->start_controls_section( 'MyAccount_style_section',
			[ 
				'label' => esc_html__( 'My Account box', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_container_style( 'MyAccount', '.woocommerce-MyAccount-content' );

		$this->add_control(
			'text-MyAccount',
			[ 
				'label' => esc_html__( 'text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'text-MyAccount', '.woocommerce-MyAccount-content p' );

		$this->add_control(
			'link-MyAccount',
			[ 
				'label' => esc_html__( 'link', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'link-MyAccount', '.woocommerce-MyAccount-content p a', $align = false );

		$this->end_controls_section();

	}

	protected function register_style_section_5() {
		$this->start_controls_section( 'order_style_section',
			[ 
				'label' => esc_html__( 'orders', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_table_style( 'orders', '.woocommerce-orders-table' );

		$this->add_control(
			'order-btn-separator',
			[ 
				'label' => esc_html__( 'order btn', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->start_controls_tabs( 'tabs_order-btn' );

		$this->start_controls_tab(
			'order-btn_normal',
			[ 
				'label' => esc_html__( 'Normal', THEME_NAME ),
			]
		);

		$this->register_text_style( 'order-btn', '.woocommerce-orders-table__cell.woocommerce-orders-table__cell-order-actions .woocommerce-button.button.view', $align = false );

		$this->end_controls_tab();

		$this->start_controls_tab(
			'order-btn_hover',
			[ 
				'label' => esc_html__( 'Hover', THEME_NAME ),
			]
		);

		$this->register_text_style( 'order-btn-hover', '.woocommerce-orders-table__cell.woocommerce-orders-table__cell-order-actions .woocommerce-button.button.view:hover', $align = false );

		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->end_controls_section();

	}

	protected function register_style_section_6() {
		$this->start_controls_section( 'downloads_style_section',
			[ 
				'label' => esc_html__( 'downloads', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_table_style( 'downloads', '.woocommerce-table--order-downloads' );

		$this->add_control(
			'download-product-td',
			[ 
				'label' => esc_html__( 'product container', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_container_style( 'download-product', 'td.download-product' );

		$this->add_control(
			'download-remaining-td',
			[ 
				'label' => esc_html__( 'remaining container', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_container_style( 'download-remaining', 'td.download-remaining' );

		$this->add_control(
			'download-expires-td',
			[ 
				'label' => esc_html__( 'expires container', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_container_style( 'download-expires', 'td.download-expires' );

		$this->add_control(
			'download-file-td',
			[ 
				'label' => esc_html__( 'file container', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_container_style( 'download-file', 'td.download-file' );

		$this->add_control(
			'download-btn-separator',
			[ 
				'label' => esc_html__( 'download btn', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->start_controls_tabs( 'tabs_download-btn' );

		$this->start_controls_tab(
			'download-btn_normal',
			[ 
				'label' => esc_html__( 'Normal', THEME_NAME ),
			]
		);

		$this->register_text_style( 'download-btn', '.woocommerce-MyAccount-downloads-file', $align = false );

		$this->end_controls_tab();

		$this->start_controls_tab(
			'download-btn_hover',
			[ 
				'label' => esc_html__( 'Hover', THEME_NAME ),
			]
		);

		$this->register_text_style( 'download-btn-hover', '.woocommerce-MyAccount-downloads-file:hover', $align = false );

		$this->end_controls_tab();
		$this->end_controls_tabs();



		$this->end_controls_section();
	}

	protected function register_style_section_7() {
		$this->start_controls_section( 'address_style_section',
			[ 
				'label' => esc_html__( 'address', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_container_style( 'address', '.woocommerce-Address' );

		$this->add_control(
			'address_title',
			[ 
				'label' => esc_html__( 'address title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'address_title', 'header h3' );

		$this->add_control(
			'address_icon',
			[ 
				'label' => esc_html__( 'address icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'address_icons', 'header h3::before', $align = false, $important = true );

		$this->add_control(
			'address_body',
			[ 
				'label' => esc_html__( 'address body', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'address_body', 'address' );


		$this->add_control(
			'edit_address',
			[ 
				'label' => esc_html__( 'edit address', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);


		$this->start_controls_tabs( 'edits_item_style' );

		$this->start_controls_tab(
			'edit_item_normal',
			[ 
				'label' => esc_html__( 'Normal', THEME_NAME ),
			]
		);

		$this->register_text_style( 'edit_address', '.edit', $align = false );

		$this->end_controls_tab();

		$this->start_controls_tab(
			'edit_item_hover',
			[ 
				'label' => esc_html__( 'Hover', THEME_NAME ),
			]
		);

		$this->register_text_style( 'edit_address_hover', '.edit:hover', $align = false );

		$this->end_controls_tab();

		$this->end_controls_tabs();


		$this->end_controls_section();
	}

	protected function register_style_section_8() {
		$this->start_controls_section(
			'form_style_section',
			[ 
				'label' => __( 'forms', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_text_style( 'form_inputs', 'form input' );

		$this->add_control(
			'labels',
			[ 
				'label' => esc_html__( 'labels', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'form_labels', 'form label', $align = false );

		$this->end_controls_section();
	}

	protected function register_style_section_9() {
		$this->start_controls_section( 'button_style_section',
			[ 
				'label' => esc_html__( 'buttons', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_text_style( 'btns', 'button' );

		$this->end_controls_section();
	}

	protected function register_style_section_10() {
		$this->start_controls_section(
			'order-detail_section',
			[ 
				'label' => esc_html__( 'order detail', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_table_style( 'order-detail-table', '.woocommerce-table--order-details' );


		$this->start_controls_tabs( 'address-order' );

		$this->start_controls_tab(
			'billing-address-order',
			[ 
				'label' => esc_html__( 'billing', THEME_NAME ),
			]
		);

		$this->register_container_style( 'woocommerce-table--order-details-billing', '.woocommerce-customer-details .woocommerce-column--billing-address' );

		$this->add_control(
			'billing-title',
			[ 
				'label' => esc_html__( 'title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'woocommerce-table--order-details-billing-title', '.woocommerce-customer-details .woocommerce-column--billing-address h2' );

		$this->add_control(
			'billing-address',
			[ 
				'label' => esc_html__( 'address', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'woocommerce-table--order-details-billing-address', '.woocommerce-customer-details .woocommerce-column--billing-address address' );

		$this->add_control(
			'billing-phone',
			[ 
				'label' => esc_html__( 'phone', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'woocommerce-table--order-details-billing-address-phone', '.woocommerce-customer-details .woocommerce-column--billing-address address .woocommerce-customer-details--phone' );


		$this->add_control(
			'billing-email',
			[ 
				'label' => esc_html__( 'email', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'woocommerce-table--order-details-billing-address-email', '.woocommerce-customer-details .woocommerce-column--billing-address address .woocommerce-customer-details--email' );



		$this->end_controls_tab();

		$this->start_controls_tab(
			'shipping-address-order',
			[ 
				'label' => esc_html__( 'shipping', THEME_NAME ),
			]
		);

		$this->register_container_style( 'woocommerce-table--order-details', '.woocommerce-customer-details .woocommerce-column--shipping-address' );

		$this->add_control(
			'shipping-title',
			[ 
				'label' => esc_html__( 'title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'woocommerce-table--order-details-shipping-title', '.woocommerce-customer-details .woocommerce-column--shipping-address h2' );

		$this->add_control(
			'shipping-address',
			[ 
				'label' => esc_html__( 'address', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'woocommerce-table--order-details-shipping-address', '.woocommerce-customer-details .woocommerce-column--shipping-address address' );

		$this->add_control(
			'shipping-phone',
			[ 
				'label' => esc_html__( 'phone', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'woocommerce-table--order-details-shipping-address-phone', '.woocommerce-customer-details .woocommerce-column--shipping-address address .woocommerce-customer-details--phone' );


		$this->add_control(
			'shipping-email',
			[ 
				'label' => esc_html__( 'email', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'woocommerce-table--order-details-shipping-address-email', '.woocommerce-customer-details .woocommerce-column--shipping-address address .woocommerce-customer-details--email' );


		$this->end_controls_tab();
		$this->end_controls_tabs();



		$this->end_controls_section();
	}

	protected function register_style_section_11() {
		$this->start_controls_section( 'section_style_image',
			[ 
				'label' => esc_html__( 'message', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'sep-body',
			[ 
				'label' => esc_html__( 'body', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'body', '.woocommerce-info' );

		$this->add_control(
			'sep-text',
			[ 
				'label' => esc_html__( 'text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'text', '.woocommerce-info' );

		$this->add_control(
			'sep-btn',
			[ 
				'label' => esc_html__( 'button', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'button', '.wc-forward', $align = false );

		$this->add_control(
			'sep-icon',
			[ 
				'label' => esc_html__( 'icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'icon', '.woocommerce-info::before ', $align = false );

		$this->end_controls_section();
	}

	protected function register_controls() {

		$this->register_style_section_1();
		$this->register_style_section_2();
		$this->register_style_section_3();
		$this->register_style_section_4();
		$this->register_style_section_5();
		$this->register_style_section_6();
		$this->register_style_section_7();
		$this->register_style_section_8();
		$this->register_style_section_9();
		$this->register_style_section_10();
		$this->register_style_section_11();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
		if ( $this->theme_is_edit_mode() ) {
			?>

			<div class="woocommerce woocommerce-account-page">
				<nav class="woocommerce-MyAccount-navigation">
					<ul>
						<div class="woocommerce-top-navigation">
							<img alt="" src="http://2.gravatar.com/avatar/8ce7473a1a51a088d24e2d2a766d4dc7?s=96&amp;d=mm&amp;r=g"
								srcset="http://2.gravatar.com/avatar/8ce7473a1a51a088d24e2d2a766d4dc7?s=192&amp;d=mm&amp;r=g 2x"
								class="avatar avatar-96 photo" height="96" width="96">
							<div class="ms-myaccount-avatar-name-code">
								<p class="name">admin</p>
								<div>
									<span class="user_code">کد کاربر:</span>
									<span class="user_code_value">1 #</span>
								</div>
							</div>
							<a href="/my-account/edit-account/">
								<i class="isax isax-edit"></i>
							</a>
						</div>
						<li class="woocommerce-MyAccount-navigation-link woocommerce-MyAccount-navigation-link--dashboard">
							<i class="isax top isax isax-user"></i>
							<a href="http://mega.test/my-account/">پنل کاربری </a>
							<i class="isax isax-arrow-down-14"></i>
						</li>
						<li class="woocommerce-MyAccount-navigation-link woocommerce-MyAccount-navigation-link--orders">
							<i class="isax top isax isax-shopping-cart"></i>
							<a href="http://mega.test/my-account/orders/">سفارش ها </a>
							<i class="isax isax-arrow-down-14"></i>
						</li>
						<li class="woocommerce-MyAccount-navigation-link woocommerce-MyAccount-navigation-link--downloads">
							<i class="isax top isax isax-receive-square4"></i>
							<a href="http://mega.test/my-account/downloads/">دانلود ها </a>
							<i class="isax isax-arrow-down-14"></i>
						</li>
						<li class="woocommerce-MyAccount-navigation-link woocommerce-MyAccount-navigation-link--edit-address">
							<i class="isax top isax isax-location4"></i>
							<a href="http://mega.test/my-account/edit-address/">ویرایش آدرس </a>
							<i class="isax isax-arrow-down-14"></i>
						</li>
						<li
							class="woocommerce-MyAccount-navigation-link woocommerce-MyAccount-navigation-link--edit-account is-active">
							<i class="isax top isax isax-message-edit"></i>
							<a href="http://mega.test/my-account/edit-account/">ویرایش حساب </a>
							<i class="isax isax-arrow-down-14"></i>
						</li>
						<li class="woocommerce-MyAccount-navigation-link woocommerce-MyAccount-navigation-link--wish-list">
							<i class="isax top isax isax-message-edit"></i>
							<a href="http://mega.test/my-account/wish-list/">لیست علاقه مندی ها </a>
							<i class="isax isax-arrow-down-14"></i>
						</li>
						<li class="woocommerce-MyAccount-navigation-link woocommerce-MyAccount-navigation-link--customer-logout">
							<i class="isax top isax isax-export-34"></i>
							<a href="http://mega.test/my-account/customer-logout/?_wpnonce=8a11040ff3">خروج </a>
							<i class="isax isax-arrow-down-14"></i>
						</li>
					</ul>
				</nav>


				<div class="woocommerce-MyAccount-content">
					<div class="woocommerce-notices-wrapper"></div>
					<p>
						سلام <strong>admin</strong> (<strong>admin</strong> نیستید؟ <a
							href="http://brand.test/my-account/customer-logout/?_wpnonce=54966d3ad7">خارج شوید</a>)</p>
					<p>
						از طریق پیشخوان حساب کاربری&zwnj;تان، می&zwnj;توانید <a
							href="http://brand.test/my-account/orders/">سفارش&zwnj;های اخیرتان</a> را مشاهده، <a
							href="http://brand.test/my-account/edit-address/">آدرس&zwnj;های حمل و نقل و صورتحساب&zwnj;تان</a> را
						مدیریت و <a href="http://brand.test/my-account/edit-account/">جزییات حساب کاربری و کلمه عبور خود را ویرایش
							کنید</a>.</p>
					<div class="woocommerce-info">
		هیچ سفارشی هنوز ثبت نشده است. <a class="woocommerce-Button wc-forward button" href="http://mega.test/shop/">مرور محصولات</a>	</div>
				</div>
			</div>

			<h2><?php echo __( 'this part just show for edit and not display in front', THEME_NAME ) ?></h2>

			<div class="woocommerce-MyAccount-content">
				<div class="woocommerce-notices-wrapper"></div>

				<table
					class="woocommerce-orders-table woocommerce-MyAccount-orders shop_table shop_table_responsive my_account_orders account-orders-table">
					<thead>
						<tr>
							<th class="woocommerce-orders-table__header woocommerce-orders-table__header-order-number"><span
									class="nobr">سفارش</span></th>
							<th class="woocommerce-orders-table__header woocommerce-orders-table__header-order-date"><span
									class="nobr">تاریخ</span></th>
							<th class="woocommerce-orders-table__header woocommerce-orders-table__header-order-status"><span
									class="nobr">وضعیت</span></th>
							<th class="woocommerce-orders-table__header woocommerce-orders-table__header-order-total"><span
									class="nobr">مجموع</span></th>
							<th class="woocommerce-orders-table__header woocommerce-orders-table__header-order-actions"><span
									class="nobr">عملیات&zwnj;ها</span></th>
						</tr>
					</thead>

					<tbody>
						<tr class="woocommerce-orders-table__row woocommerce-orders-table__row--status-processing order">
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-number"
								data-title="سفارش">
								<a href="http://brand.test/my-account/view-order/3934/"> #3934 </a>
							</td>
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-date" data-title="تاریخ">
								<time datetime="2024-04-25T18:23:10+00:00">2024-04-25</time>
							</td>
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-status"
								data-title="وضعیت">
								در حال انجام
							</td>
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-total"
								data-title="مجموع">
								<span class="woocommerce-Price-amount amount">0&nbsp;<span
										class="woocommerce-Price-currencySymbol">تومان</span></span> برای 1 مورد
							</td>
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-actions"
								data-title="عملیات&zwnj;ها">
								<a href="http://brand.test/my-account/view-order/3934/"
									class="woocommerce-button button view">مشاهده</a>
							</td>
						</tr>
						<tr class="woocommerce-orders-table__row woocommerce-orders-table__row--status-processing order">
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-number"
								data-title="سفارش">
								<a href="http://brand.test/my-account/view-order/3894/"> #3894 </a>
							</td>
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-date" data-title="تاریخ">
								<time datetime="2024-04-25T18:10:06+00:00">2024-04-25</time>
							</td>
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-status"
								data-title="وضعیت">
								در حال انجام
							</td>
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-total"
								data-title="مجموع">
								<span class="woocommerce-Price-amount amount">0&nbsp;<span
										class="woocommerce-Price-currencySymbol">تومان</span></span> برای 1 مورد
							</td>
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-actions"
								data-title="عملیات&zwnj;ها">
								<a href="http://brand.test/my-account/view-order/3894/"
									class="woocommerce-button button view">مشاهده</a>
							</td>
						</tr>
						<tr class="woocommerce-orders-table__row woocommerce-orders-table__row--status-processing order">
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-number"
								data-title="سفارش">
								<a href="http://brand.test/my-account/view-order/3878/"> #3878 </a>
							</td>
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-date" data-title="تاریخ">
								<time datetime="2024-04-25T17:59:16+00:00">2024-04-25</time>
							</td>
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-status"
								data-title="وضعیت">
								در حال انجام
							</td>
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-total"
								data-title="مجموع">
								<span class="woocommerce-Price-amount amount">0&nbsp;<span
										class="woocommerce-Price-currencySymbol">تومان</span></span> برای 1 مورد
							</td>
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-actions"
								data-title="عملیات&zwnj;ها">
								<a href="http://brand.test/my-account/view-order/3878/"
									class="woocommerce-button button view">مشاهده</a>
							</td>
						</tr>
						<tr class="woocommerce-orders-table__row woocommerce-orders-table__row--status-processing order">
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-number"
								data-title="سفارش">
								<a href="http://brand.test/my-account/view-order/1561/"> #1561 </a>
							</td>
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-date" data-title="تاریخ">
								<time datetime="2024-03-29T21:02:32+00:00">2024-03-29</time>
							</td>
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-status"
								data-title="وضعیت">
								در حال انجام
							</td>
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-total"
								data-title="مجموع">
								<span class="woocommerce-Price-amount amount">10،000&nbsp;<span
										class="woocommerce-Price-currencySymbol">تومان</span></span> برای 1 مورد
							</td>
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-actions"
								data-title="عملیات&zwnj;ها">
								<a href="http://brand.test/my-account/view-order/1561/"
									class="woocommerce-button button view">مشاهده</a>
							</td>
						</tr>
						<tr class="woocommerce-orders-table__row woocommerce-orders-table__row--status-on-hold order">
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-number"
								data-title="سفارش">
								<a href="http://brand.test/my-account/view-order/1541/"> #1541 </a>
							</td>
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-date" data-title="تاریخ">
								<time datetime="2024-03-29T19:30:30+00:00">2024-03-29</time>
							</td>
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-status"
								data-title="وضعیت">
								در انتظار بررسی
							</td>
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-total"
								data-title="مجموع">
								<span class="woocommerce-Price-amount amount">10،000&nbsp;<span
										class="woocommerce-Price-currencySymbol">تومان</span></span> برای 1 مورد
							</td>
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-actions"
								data-title="عملیات&zwnj;ها">
								<a href="http://brand.test/my-account/view-order/1541/"
									class="woocommerce-button button view">مشاهده</a>
							</td>
						</tr>
						<tr class="woocommerce-orders-table__row woocommerce-orders-table__row--status-processing order">
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-number"
								data-title="سفارش">
								<a href="http://brand.test/my-account/view-order/1424/"> #1424 </a>
							</td>
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-date" data-title="تاریخ">
								<time datetime="2024-03-28T23:29:21+00:00">2024-03-28</time>
							</td>
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-status"
								data-title="وضعیت">
								در حال انجام
							</td>
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-total"
								data-title="مجموع">
								<span class="woocommerce-Price-amount amount">40،000&nbsp;<span
										class="woocommerce-Price-currencySymbol">تومان</span></span> برای 4 مورد
							</td>
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-actions"
								data-title="عملیات&zwnj;ها">
								<a href="http://brand.test/my-account/view-order/1424/"
									class="woocommerce-button button view">مشاهده</a>
							</td>
						</tr>
						<tr class="woocommerce-orders-table__row woocommerce-orders-table__row--status-processing order">
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-number"
								data-title="سفارش">
								<a href="http://brand.test/my-account/view-order/1062/"> #1062 </a>
							</td>
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-date" data-title="تاریخ">
								<time datetime="2024-03-26T14:57:28+00:00">2024-03-26</time>
							</td>
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-status"
								data-title="وضعیت">
								در حال انجام
							</td>
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-total"
								data-title="مجموع">
								<span class="woocommerce-Price-amount amount">320،000&nbsp;<span
										class="woocommerce-Price-currencySymbol">تومان</span></span> برای 32 مورد
							</td>
							<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-order-actions"
								data-title="عملیات&zwnj;ها">
								<a href="http://brand.test/my-account/view-order/1062/"
									class="woocommerce-button button view">مشاهده</a>
							</td>
						</tr>
					</tbody>
				</table>
			</div>

			<div class="woocommerce-MyAccount-content">
				<div class="woocommerce-notices-wrapper"></div>

				<section class="woocommerce-order-downloads">
					<table
						class="woocommerce-table woocommerce-table--order-downloads shop_table shop_table_responsive order_details">
						<thead>
							<tr>
								<th class="download-product"><span class="nobr">محصول</span></th>
								<th class="download-remaining"><span class="nobr">دانلودهای باقی مونده</span></th>
								<th class="download-expires"><span class="nobr">انقضا</span></th>
								<th class="download-file"><span class="nobr">دانلود</span></th>
							</tr>
						</thead>

						<tbody>
							<tr>
								<td class="download-product" data-title="محصول">
									<a
										href="http://brand.test/product/%d9%be%d8%a7%d8%af%da%a9%d8%b3%d8%aa-%d9%85%d8%af%db%8c%d8%b1%db%8c%d8%aa-%d8%b2%d9%85%d8%a7%d9%86/">پادکست
										مدیریت زمان</a>
								</td>
								<td class="download-remaining" data-title="دانلودهای باقی مونده">
									∞
								</td>
								<td class="download-expires" data-title="انقضا">
									هرگز
								</td>
								<td class="download-file" data-title="دانلود">
									<a href="http://brand.test/?download_file=3773&amp;order=wc_order_7sYxgHo1k8iZ7&amp;email=ali110arman%40gmail.com&amp;key=e1b62a3d-815f-498d-9fc3-cb97cfcfe428"
										class="woocommerce-MyAccount-downloads-file button alt">
										فایل اول
									</a>
								</td>
							</tr>
							<tr>
								<td class="download-product" data-title="محصول">
									<a
										href="http://brand.test/product/%d8%a2%d9%85%d9%88%d8%b2%d8%b4-%d9%87%d9%88%d8%b4-%d8%aa%d8%ac%d8%a7%d8%b1%db%8c/">آموزش
										هوش تجاری</a>
								</td>
								<td class="download-remaining" data-title="دانلودهای باقی مونده">
									∞
								</td>
								<td class="download-expires" data-title="انقضا">
									هرگز
								</td>
								<td class="download-file" data-title="دانلود">
									<a href="http://brand.test/?download_file=3777&amp;order=wc_order_G89URLx6jKSu8&amp;email=ali110arman%40gmail.com&amp;key=2fec2a11-b629-4d78-b799-ceb7f2058494"
										class="woocommerce-MyAccount-downloads-file button alt">
										دانلود پادکست
									</a>
								</td>
							</tr>
							<tr>
								<td class="download-product" data-title="محصول">
									<a
										href="http://brand.test/product/%d8%a2%d9%85%d9%88%d8%b2%d8%b4-%d9%87%d9%88%d8%b4-%d8%aa%d8%ac%d8%a7%d8%b1%db%8c/">آموزش
										هوش تجاری</a>
								</td>
								<td class="download-remaining" data-title="دانلودهای باقی مونده">
									∞
								</td>
								<td class="download-expires" data-title="انقضا">
									هرگز
								</td>
								<td class="download-file" data-title="دانلود">
									<a href="http://brand.test/?download_file=3777&amp;order=wc_order_G89URLx6jKSu8&amp;email=ali110arman%40gmail.com&amp;key=0b0be164-757b-449b-b800-a84a4b2157c7"
										class="woocommerce-MyAccount-downloads-file button alt">
										دانلود فایل لایسنس
									</a>
								</td>
							</tr>
							<tr>
								<td class="download-product" data-title="محصول">
									<a
										href="http://brand.test/product/%d8%a2%d9%85%d9%88%d8%b2%d8%b4-%d9%87%d9%88%d8%b4-%d8%aa%d8%ac%d8%a7%d8%b1%db%8c/">آموزش
										هوش تجاری</a>
								</td>
								<td class="download-remaining" data-title="دانلودهای باقی مونده">
									2
								</td>
								<td class="download-expires" data-title="انقضا">
									<time datetime="2024-05-02" title="1714608000">2024-05-02</time>
								</td>
								<td class="download-file" data-title="دانلود">
									<a href="http://brand.test/?download_file=3777&amp;order=wc_order_yjWX7LW6LNz6E&amp;email=ali110arman%40gmail.com&amp;key=2fec2a11-b629-4d78-b799-ceb7f2058494"
										class="woocommerce-MyAccount-downloads-file button alt">
										دانلود پادکست
									</a>
								</td>
							</tr>
							<tr>
								<td class="download-product" data-title="محصول">
									<a
										href="http://brand.test/product/%d8%a2%d9%85%d9%88%d8%b2%d8%b4-%d9%87%d9%88%d8%b4-%d8%aa%d8%ac%d8%a7%d8%b1%db%8c/">آموزش
										هوش تجاری</a>
								</td>
								<td class="download-remaining" data-title="دانلودهای باقی مونده">
									2
								</td>
								<td class="download-expires" data-title="انقضا">
									<time datetime="2024-05-02" title="1714608000">2024-05-02</time>
								</td>
								<td class="download-file" data-title="دانلود">
									<a href="http://brand.test/?download_file=3777&amp;order=wc_order_yjWX7LW6LNz6E&amp;email=ali110arman%40gmail.com&amp;key=0b0be164-757b-449b-b800-a84a4b2157c7"
										class="woocommerce-MyAccount-downloads-file button alt">
										دانلود فایل لایسنس
									</a>
								</td>
							</tr>
						</tbody>
					</table>
				</section>
			</div>

			<div class="woocommerce-MyAccount-content">
				<div class="woocommerce-notices-wrapper"></div>

				<p>
					آدرس&zwnj;های زیر به طور پیش&zwnj;فرض در صفحه پرداخت مورد استفاده قرار مي&zwnj;گیرد.
				</p>

				<div class="u-columns woocommerce-Addresses col2-set addresses">
					<div class="u-column1 col-1 woocommerce-Address">
						<header class="woocommerce-Address-title title">
							<h3>آدرس صورتحساب</h3>
							<a href="http://brand.test/my-account/edit-address/%d8%b5%d9%88%d8%b1%d8%aa-%d8%ad%d8%b3%d8%a7%d8%a8/"
								class="edit">ویرایش</a>
						</header>
						<address>
							نام ادرس<br />
							نشانی<br />
							اصفهان<br />
							اصفهان<br />
							123456789
						</address>
					</div>

					<div class="u-column2 col-2 woocommerce-Address">
						<header class="woocommerce-Address-title title">
							<h3>آدرس حمل و نقل</h3>
							<a href="http://brand.test/my-account/edit-address/%d8%ad%d9%85%d9%84-%d9%88-%d9%86%d9%82%d9%84/"
								class="edit">ویرایش</a>
						</header>
						<address>
							نام ادرس<br />
							نشانی<br />
							اصفهان<br />
							اصفهان<br />
							123456789
						</address>
					</div>
				</div>
			</div>

			<div class="woocommerce-MyAccount-content">
				<div class="woocommerce-notices-wrapper"></div>

				<form method="post">
					<h3>آدرس صورتحساب</h3>
					<div class="woocommerce-address-fields">
						<div class="woocommerce-address-fields__field-wrapper">
							<p class="form-row form-row-first validate-required" id="billing_first_name_field" data-priority="10">
								<label for="billing_first_name" class="">نام&nbsp;<abbr class="required"
										title="ضروری">*</abbr></label>
								<span class="woocommerce-input-wrapper"><input type="text" class="input-text"
										name="billing_first_name" id="billing_first_name" placeholder="" value=""
										autocomplete="given-name" /></span>
							</p>
							<p class="form-row form-row-last validate-required" id="billing_last_name_field" data-priority="20">
								<label for="billing_last_name" class="">نام خانوادگی&nbsp;<abbr class="required"
										title="ضروری">*</abbr></label>
								<span class="woocommerce-input-wrapper"><input type="text" class="input-text"
										name="billing_last_name" id="billing_last_name" placeholder="" value=""
										autocomplete="family-name" /></span>
							</p>
							<p class="form-row form-row-wide" id="billing_company_field" data-priority="30">
								<label for="billing_company" class="">نام شرکت&nbsp;<span class="optional">(اختیاری)</span></label>
								<span class="woocommerce-input-wrapper"><input type="text" class="input-text" name="billing_company"
										id="billing_company" placeholder="" value="" autocomplete="organization" /></span>
							</p>
							<p class="form-row form-row-wide address-field update_totals_on_change validate-required"
								id="billing_country_field" data-priority="40">
								<label for="billing_country" class="">کشور / منطقه&nbsp;<abbr class="required"
										title="ضروری">*</abbr></label>
								<span class="woocommerce-input-wrapper"><strong>ایران</strong><input type="hidden"
										name="billing_country" id="billing_country" value="IR" autocomplete="country"
										class="country_to_state" readonly="readonly" /></span>
							</p>
							<p class="form-row address-field validate-required validate-state form-row-wide"
								id="billing_state_field" data-priority="50"
								data-o_class="form-row form-row-wide address-field validate-required validate-state">
								<label for="billing_state" class="">استان&nbsp;<abbr class="required" title="ضروری">*</abbr></label>
								<span class="woocommerce-input-wrapper">
									<select name="billing_state" id="billing_state" class="state_select select2-hidden-accessible"
										autocomplete="address-level1" data-placeholder="یک گزینه انتخاب نمائید…"
										data-input-classes="" data-label="استان" tabindex="-1" aria-hidden="true">
										<option value="">یک گزینه انتخاب نمائید…</option>
										<option value="KHZ">خوزستان</option>
										<option value="THR">تهران</option>
										<option value="ILM">ایلام</option>
										<option value="BHR">بوشهر</option>
										<option value="ADL">اردبیل</option>
										<option value="ESF">اصفهان</option>
										<option value="YZD">یزد</option>
										<option value="KRH">کرمانشاه</option>
										<option value="KRN">کرمان</option>
										<option value="HDN">همدان</option>
										<option value="GZN">قزوین</option>
										<option value="ZJN">زنجان</option>
										<option value="LRS">لرستان</option>
										<option value="ABZ">البرز</option>
										<option value="EAZ">آذربایجان شرقی</option>
										<option value="WAZ">آذربایجان غربی</option>
										<option value="CHB">چهارمحال و بختیاری</option>
										<option value="SKH">خراسان جنوبی</option>
										<option value="RKH">خراسان رضوی</option>
										<option value="NKH">خراسان شمالی</option>
										<option value="SMN">سمنان</option>
										<option value="FRS">فارس</option>
										<option value="QHM">قم</option>
										<option value="KRD">کردستان</option>
										<option value="KBD">کهگیلویه و بویراحمد</option>
										<option value="GLS">گلستان</option>
										<option value="GIL">گیلان</option>
										<option value="MZN">مازندران</option>
										<option value="MKZ">مرکزی</option>
										<option value="HRZ">هرمزگان</option>
										<option value="SBN">سیستان و بلوچستان</option>
									</select>
									<span class="select2 select2-container select2-container--default" dir="rtl"
										style="width: 100%;">
										<span class="selection">
											<span class="select2-selection select2-selection--single" aria-haspopup="true"
												aria-expanded="false" tabindex="0" aria-label="استان" role="combobox">
												<span class="select2-selection__rendered" id="select2-billing_state-container"
													role="textbox" aria-readonly="true" title="اصفهان">اصفهان</span>
												<span class="select2-selection__arrow" role="presentation"><b
														role="presentation"></b></span>
											</span>
										</span>
										<span class="dropdown-wrapper" aria-hidden="true"></span>
									</span>
								</span>
							</p>
							<p class="form-row address-field validate-required form-row-wide" id="billing_city_field"
								data-priority="60" data-o_class="form-row form-row-wide address-field validate-required">
								<label for="billing_city" class="">شهر&nbsp;<abbr class="required" title="ضروری">*</abbr></label>
								<span class="woocommerce-input-wrapper"><input type="text" class="input-text" name="billing_city"
										id="billing_city" placeholder="" value="اصفهان" autocomplete="address-level2" /></span>
							</p>
							<p class="form-row address-field validate-required form-row-wide" id="billing_address_1_field"
								data-priority="70">
								<label for="billing_address_1" class="">آدرس خیابان&nbsp;<abbr class="required"
										title="ضروری">*</abbr></label>
								<span class="woocommerce-input-wrapper">
									<input type="text" class="input-text" name="billing_address_1" id="billing_address_1"
										placeholder="نام خیابان و پلاک خانه" value="" autocomplete="address-line1"
										data-placeholder="نام خیابان و پلاک خانه" />
								</span>
							</p>
							<p class="form-row address-field form-row-wide" id="billing_address_2_field" data-priority="80"
								style="display: block;">
								<label for="billing_address_2" class="screen-reader-text">آپارتمان، مجتمع، واحد و...&nbsp;<span
										class="optional">(اختیاری)</span></label>
								<span class="woocommerce-input-wrapper">
									<input type="text" class="input-text" name="billing_address_2" id="billing_address_2"
										placeholder="آپارتمان، مجتمع، واحد و... (اختیاری)" value="" autocomplete="address-line2"
										data-placeholder="آپارتمان، مجتمع، واحد و... (اختیاری)" />
								</span>
							</p>
							<p class="form-row address-field validate-required validate-postcode form-row-wide"
								id="billing_postcode_field" data-priority="90"
								data-o_class="form-row form-row-wide address-field validate-required validate-postcode">
								<label for="billing_postcode" class="">کدپستی (بدون فاصله و با اعداد انگلیسی)&nbsp;<abbr
										class="required" title="ضروری">*</abbr></label>
								<span class="woocommerce-input-wrapper"><input type="text" class="input-text"
										name="billing_postcode" id="billing_postcode" placeholder="" value=""
										autocomplete="postal-code" /></span>
							</p>
							<p class="form-row form-row-wide validate-required validate-phone" id="billing_phone_field"
								data-priority="100">
								<label for="billing_phone" class="">تلفن&nbsp;<abbr class="required" title="ضروری">*</abbr></label>
								<span class="woocommerce-input-wrapper"><input type="tel" class="input-text" name="billing_phone"
										id="billing_phone" placeholder="" value="" autocomplete="tel" /></span>
							</p>
							<p class="form-row form-row-wide validate-required validate-email" id="billing_email_field"
								data-priority="110">
								<label for="billing_email" class="">آدرس ایمیل&nbsp;<abbr class="required"
										title="ضروری">*</abbr></label>
								<span class="woocommerce-input-wrapper"><input type="email" class="input-text" name="billing_email"
										id="billing_email" placeholder="" value="" autocomplete="email username" /></span>
							</p>
						</div>

						<p>
							<button type="submit" class="button" name="save_address" value="ذخیره آدرس">ذخیره آدرس</button>
							<input type="hidden" id="woocommerce-edit-address-nonce" name="woocommerce-edit-address-nonce"
								value="1b743927c3" />
							<input type="hidden" name="_wp_http_referer"
								value="/my-account/edit-address/%d8%b5%d9%88%d8%b1%d8%aa-%d8%ad%d8%b3%d8%a7%d8%a8/" /> <input
								type="hidden" name="action" value="edit_address" />
						</p>
					</div>
				</form>
			</div>

			<div class="woocommerce-MyAccount-content">
				<div class="woocommerce-notices-wrapper"></div>
				<p>سفارش #<mark class="order-number">1062</mark> در تاریخ <mark class="order-date">2024-03-26</mark> ثبت شده است و
					در حال حاضر در وضعیت <mark class="order-status">در حال انجام</mark> می&zwnj;باشد.</p>

				<section class="woocommerce-order-details">
					<h2 class="woocommerce-order-details__title">مشخصات سفارش</h2>

					<table class="woocommerce-table woocommerce-table--order-details shop_table order_details" style="">
						<thead>
							<tr>
								<th class="woocommerce-table__product-name product-name" style="">محصول</th>
								<th class="woocommerce-table__product-table product-total">مجموع</th>
							</tr>
						</thead>

						<tbody>
							<tr class="woocommerce-table__line-item order_item">
								<td class="woocommerce-table__product-name product-name"><a
										href="http://brand.test/product/test-slug/">test name</a> <strong
										class="product-quantity">×&nbsp;32</strong></td>

								<td class="woocommerce-table__product-total product-total">
									<span class="woocommerce-Price-amount amount">
										<bdi>320،000&nbsp;<span class="woocommerce-Price-currencySymbol">تومان</span></bdi>
									</span>
								</td>
							</tr>
						</tbody>

						<tfoot>
							<tr>
								<th scope="row">جمع جزء:</th>
								<td>
									<span class="woocommerce-Price-amount amount">320،000&nbsp;<span
											class="woocommerce-Price-currencySymbol">تومان</span></span>
								</td>
							</tr>
							<tr>
								<th scope="row">حمل و نقل:</th>
								<td>Free shipping</td>
							</tr>
							<tr>
								<th scope="row">روش پرداخت:</th>
								<td>پرداخت هنگام دریافت</td>
							</tr>
							<tr>
								<th scope="row">قیمت نهایی:</th>
								<td>
									<span class="woocommerce-Price-amount amount">320،000&nbsp;<span
											class="woocommerce-Price-currencySymbol">تومان</span></span>
								</td>
							</tr>
						</tfoot>
					</table>
				</section>

				<section class="woocommerce-customer-details">
					<section class="woocommerce-columns woocommerce-columns--2 woocommerce-columns--addresses col2-set addresses">
						<div class="woocommerce-column woocommerce-column--1 woocommerce-column--billing-address col-1" style="">
							<h2 class="woocommerce-column__title">آدرس صورتحساب</h2>

							<address>
								نام<br />
								ادرس<br />
								اصفهان<br />
								اصفهان<br />
								132456789
								<p class="woocommerce-customer-details--phone">0913111111</p>

								<p class="woocommerce-customer-details--email">test@gmail.com</p>
							</address>
						</div>
						<!-- /.col-1 -->

						<div class="woocommerce-column woocommerce-column--2 woocommerce-column--shipping-address col-2">
							<h2 class="woocommerce-column__title">آدرس حمل و نقل</h2>
							<address>
								نام<br />
								ادرس<br />
								اصفهان<br />
								اصفهان<br />
								132456789
								<p class="woocommerce-customer-details--phone">0913111111</p>

								<p class="woocommerce-customer-details--email">test@gmail.com</p>
							</address>
						</div>
						<!-- /.col-2 -->
					</section>
					<!-- /.col2-set -->
				</section>
			</div>

			<?php
		} else {
			echo do_shortcode( '[woocommerce_my_account]' );
		}
	}
}