<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_show_template extends \Elementor\Widget_Base {

    use basic_element;

    public function get_name() {
        return 'ar_show_template';
    }

    public function get_title() {
        return esc_html__('show template', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_show_template';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

	protected function get_template() {
		$attributes = array();

		$post_type_name = 'theme-other';

		$args = array(
			'post_type' => $post_type_name,
			'posts_per_page' => -1, // Retrieve all posts of this post type
			'post_status' => 'publish',
		);

		$query = new WP_Query( $args );

		if ( $query->have_posts() ) {
			while ( $query->have_posts() ) {
				$query->the_post();
				$post_id = get_the_ID();
				$post_title = get_the_title();

				// Add post attributes to the array
				$attributes[ $post_id ] = esc_html( $post_title );
			}
			wp_reset_postdata(); // Restore global post data
		}

		return $attributes;
	}


	protected function register_content_section_1() {
        $this->start_controls_section(
            'post_style_section',
            [
                'label' => esc_html__( 'template', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control(
			'template_id',
			[ 
				'label' => esc_html__( 'template', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => $this->get_template(),
				'default' => 'post',
			]
		);

        $this->end_controls_section();

    } 

    protected function register_controls() {

        $this->register_content_section_1();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
		$template = show_template( $settings['template_id'] );
		echo ( $template );
    }

}