<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_profile_btn extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_profile_btn';
    }

    public function get_title() {
        return esc_html__('profile button', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_profile_btn';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_content_section_1(){

        $this->start_controls_section(
            'section_content_layout',
            [
                'label' => esc_html__( 'Layout', THEME_NAME ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'btn_title',
            [
                'label' => esc_html__( 'Button Title', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
			'icon',
			[
				'label' => esc_html__( 'Button Icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::ICONS,
			]
		);

		$this->add_control(
			'link',
			[ 
				'label' => esc_html__( 'link', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::URL,
			]
		);


		$this->end_controls_section();

    } 

    protected function register_style_section_1() {
        $this->start_controls_section(
            'btn-text',
            [
                'label' => esc_html__( 'text', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

		$this->register_text_style( 'btn_box', 'a', $align = false );

        $this->add_control(
            'text',
            [
                'label'     => esc_html__( 'text', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
            ]
        );

		$this->register_text_style( 'btn_text', 'a p', $align = false );

		$this->add_control(
			'icon',
			[ 
				'label' => esc_html__( 'icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

        $this->register_text_style('btn_icon',  'a i', $align=false);

        $this->end_controls_section();

    } 

    protected function register_controls() {
        $this->register_content_section_1();
        $this->register_style_section_1();
    }

    protected function render() {
		$settings = $this->get_settings_for_display();
		if ( is_user_logged_in() ) {
			$current_user = wp_get_current_user();
			?>
				<a href="<?php echo wc_get_account_endpoint_url( 'edit-account' ); ?>" class="d-flex align-items-center">
					<p class="user-text"><?php echo esc_html__(  'Hi ', THEME_NAME) . $current_user->display_name ; ?></p>
				</a>
				<?php
		} else {
			?>
            <a href="<?php echo esc_url( $settings['link']['url'] ); ?>" class="d-flex align-items-center">
                <?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                <p class="user-text"><?php echo esc_html( $settings['btn_title'] ); ?></p>
            </a>
            <?php
		}
	}
}