<?php



use handler\Group_Control_Query;
use handler\Post_skin_base;
use handler\swiper;
use handler\wavesurfer;
use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_post_sound extends \Elementor\Widget_Base {


    use Group_Control_Query;
    use Post_skin_base;
    use swiper;
    use basic_element;
    use wavesurfer;

    public function get_name() {
        return 'ar_post_sound';
    }

    public function get_title() {
        return esc_html__('Posts audio', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_post_sound';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function get_layout_source() {
        global $post;

        $current_page_id = $post->ID;

        $posts = get_posts(array(
            'post_type'      => 'theme-blog',
            'posts_per_page' => -1, 
            'exclude'        => $current_page_id,
        ));

        $options = array();
        foreach ($posts as $post) {
            $options[$post->ID] = $post->post_title;
        }

        return $options;
    }

    protected function register_content_section_1() {
        $this->start_controls_section(
            'section_layout',
            [
                'label' => esc_html__( 'Layout', THEME_NAME ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout',
            [
                'label'     => esc_html__( 'Layout', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'options'   => [
                    'grid'     => esc_html__( 'Grid', THEME_NAME ),
                    'carousel' => esc_html__( 'Carousel', THEME_NAME ),
                ],
                'default'   => 'grid',
            ]
        );


        $this->add_responsive_control(
            'columns',
            [
                'label'              => esc_html__( 'Columns', THEME_NAME ),
                'type'               => \Elementor\Controls_Manager::SELECT,
                'default'            => '3',
                'tablet_default'     => '2',
                'mobile_default'     => '1',
                'options'            => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'render_type'    => 'template',
                'selectors' => [
                    '{{WRAPPER}} .theme-posts-wrapper.layout-grid' => 'grid-template-columns: repeat({{SIZE}}, 1fr);',
                    '{{WRAPPER}} .theme-posts-wrapper.layout-masonry .post-item' => 'width: calc(100% / {{SIZE}});',
                    '{{WRAPPER}} .theme-posts-wrapper.layout-carousel .post-item' => 'width: calc(100% / {{SIZE}});',
                ],
            ]
        );

        $this->add_responsive_control(
            'column_gap',
            [
                'label'     => esc_html__( 'Column Gap', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SLIDER,
                'default'   => [
                    'size' => '20',
                ],
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'render_type'    => 'template',
                'selectors' => [
                    '{{WRAPPER}} .theme-posts-wrapper.layout-grid' => 'column-gap: {{SIZE}}{{UNIT}};',
                    'body:not(.rtl) {{WRAPPER}} .theme-posts-wrapper.layout-carousel .post-item' => 'margin-right: {{SIZE}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .theme-posts-wrapper.layout-carousel .post-item' => 'margin-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .theme-posts-wrapper.layout-masonry' => 'margin-left: calc({{SIZE}}{{UNIT}} * -.5); margin-right: calc({{SIZE}}{{UNIT}} * -.5);',
                    '{{WRAPPER}} .theme-posts-wrapper.layout-masonry .post-item' => 'padding-left: calc({{SIZE}}{{UNIT}} * .5); padding-right: calc({{SIZE}}{{UNIT}} * .5);',
                ],
            ]
        );

        $this->add_responsive_control(
            'row_gap',
            [
                'label'     => esc_html__( 'Row Gap', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SLIDER,
                'default'   => [
                    'size' => '20',
                ],
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .theme-posts-wrapper.layout-grid' => 'row-gap: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .theme-posts-wrapper.layout-masonry .post-item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'layout!' => 'carousel',
                ],
            ]
        );

		$this->add_control(
			'audio_icon',
			[ 
				'label' => esc_html__( 'audio Icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::ICONS,
			]
		);

        $this->end_controls_section();

    }

    protected function register_style_section_1() {
        $this->start_controls_section(
            'post_price_style_section',
            [
                'label' => esc_html__( 'style', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

		$this->register_container_style( 'audio-body', '.audio-body');

		$this->add_control(
			'button_style_section',
			[ 
				'label' => esc_html__( 'button', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('waveform-btn',  '.waveform-btn', $align = false);

		$this->add_control(
			'top_icon',
			[ 
				'label' => esc_html__( 'top icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'top-icon', '.d-flex i', $align = false );

		$this->add_control(
			'title',
			[ 
				'label' => esc_html__( 'title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'title', '.audio-title', $align = false );

		$this->add_control(
			'time',
			[ 
				'label' => esc_html__( 'time', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('audio-time',  '.audio-time');

		$this->add_control(
			'price',
			[ 
				'label' => esc_html__( 'price', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'product-price', '.woocommerce-Price-amount');

		$this->add_control(
			'icon-bottom',
			[ 
				'label' => esc_html__( 'icon bottom', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'icon-bottom', '.icon-bottom i' );



        $this->end_controls_section();

    } 

    protected function register_controls() {

        $this->register_query_builder_controls();
        $this->register_content_section_1();
        $this->register_vawe_controls();
        $this->register_style_section_1();
		$this->register_carousel_controls();
		$this->register_style_carousel_controls();
	}


    protected function render()
    {
        $settings = $this->get_settings_for_display();
		$element_id = $settings['_element_id'];
        $query = $this->get_query_result();

		if ( ! $query->found_posts ) {

            ?>
            <div class="nothing-show">
                <h2><?php esc_html_e('Nothing found!', THEME_NAME); ?></h2>
                <p><?php esc_html_e('It looks like nothing was found here!', THEME_NAME); ?></p>
            </div>
            <?php

            return;
        }

		?>
        <div class="theme-posts-container theme-post-widget">
            <?php
            $post_wrapper_cls = '';
                if( $settings['layout'] == 'grid' ) {
                    $post_wrapper_cls = 'theme-posts-wrapper';
                }
            ?>
            <div class="<?php echo $post_wrapper_cls ?> layout-<?php echo $settings['layout'] ?>" >
                <?php $this->render_carousel_header(); ?>
                <script>
                    function formatTime(seconds) {
                        const minutes = Math.floor(seconds / 60);
                        const remainingSeconds = Math.floor(seconds % 60);
                        const formattedSeconds = remainingSeconds < 10 ? `0${remainingSeconds}` : remainingSeconds;
                        return `${minutes}:${formattedSeconds}`;
                    }

                    function getTotalAudioDuration(audioUrl, callback) {
                        const audio = new Audio(audioUrl);

                        audio.addEventListener('loadedmetadata', function() {
                            // Duration is in seconds
                            const duration = audio.duration;
                            const formattedDuration = formatTime(duration);
                            callback(formattedDuration);
                        });

                        // In case of an error loading the audio
                        audio.addEventListener('error', function() {
                            console.error('Error loading audio:', audioUrl);
                            callback(null);
                        });

                        // Load the audio
                        audio.preload = 'metadata';
                        audio.load();
                    }

                </script>
                <?php
                if ( $query->have_posts() ) :
                    while ( $query->have_posts() ) :
                        $query->the_post();

                        $post_item_cls = 'post-item';
                        if( $settings['layout'] == 'carousel' ) {
                            $post_item_cls = ' swiper-slide';
                        }
                        $post_kind = get_post_type();
                        $audi_file = get_post_meta(get_the_ID(), $post_kind . '_single_audio_file', true );
                        
						if($audi_file){
                            $post_title = get_the_title( get_the_ID());

                            if ( $post_kind == 'product' && class_exists( 'WooCommerce' ) && function_exists( 'wc_get_product' ) ) {
                                $product = wc_get_product( get_the_ID() );
                                if ( $product && $product->get_price() !== '' ) {
                                    $product_price = $product->get_price();
                                }
                            }

                            ?>
                            <div class="<?php echo esc_html( $post_item_cls ); ?>">
                                <div class="audio-body row">
                                    <div class="post-title d-flex align-items-center col-12">
                                        <?php \Elementor\Icons_Manager::render_icon( $settings['audio_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                        <a class="audio-title" href="<?php echo esc_url(get_permalink( get_the_ID())) ?>"><?php echo esc_html($post_title) ?></a>
                                    </div>
                                    <div class="col-12 py-3">
                                        <article>
                                            <?php $this->render_wave($audi_file);?>
                                        </article>
                                    </div>
                                    <div class="col-6">
                                        <div class="audio-time" id="audio-<?php echo get_the_ID() ?>">
                                        </div>
                                        <script>
                                            audioUrl = "<?php echo $audi_file; ?>";
                                            getTotalAudioDuration(audioUrl, function(duration) {
                                                if (duration !== null) {
                                                    document.getElementById("audio-<?php echo get_the_ID() ?>" ).innerHTML = duration + ' دقیقه ';

                                                }
                                            });
                                        </script>
                                    </div>
                                    <div class="col-6 d-flex justify-content-end" style="text-align: end;">
                                        <?php if ( $post_kind == 'product' ) :
                                            if ( $product->get_price() !== '0') {
												echo wc_price( $product_price ); ?><?php echo $product->get_price_suffix(); ?>
												<a class="icon-bottom" href="<?php echo esc_url( get_permalink( get_the_ID() ) ) ?>">
													<i aria-hidden="true" class="isax isax-add4"></i>
												</a>
												<?php
											} else {
                                                echo __( 'Free', THEME_NAME );
											}

                                        endif; ?>
                                    </div>
                                </div>
                            </div>
                            <?php
                        }
                    endwhile;
                endif;
                wp_reset_postdata();
                ?>
                <?php $this->render_carousel_footer(); ?>
            </div>
        </div>
        <script>
            jQuery(document).ready(function($) {
                // Get all elements with the class '.theme-posts-carousel-wrapper'
                var carouselPosts = $('.theme-posts-carousel-wrapper');
                
                // Iterate over each carousel element
                carouselPosts.each(function() {
                    // Get settings data for the current carousel
                    var carouselSettings = $(this).data('settings');
                    
                    // Find the swiper container within the current carousel
                    var carouselContainer = $(this).find('.swiper-container')[0];
                    
                    // Initialize Swiper for the current carousel
                    var swiper<?php echo $element_id ?> = new Swiper( carouselContainer, carouselSettings );

					$( '.swiper-prev-btn<?php echo $element_id ?>' ).on( 'click', function ()
					{
						swiper<?php echo $element_id ?>.slidePrev();
					} );

					$( '.swiper-next-btn<?php echo $element_id ?>' ).on( 'click', function ()
					{
						swiper<?php echo $element_id ?>.slideNext();

                    } );
                } );
            } );

        </script>
        
        <?php
    }

}