<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_post_author_image extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_post_author_image';
    }

    public function get_title() {
        return esc_html__('post author image', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_post_author_image';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }


    protected function register_style_section_1() {
        $this->start_controls_section(
            'post_style_section',
            [
                'label' => esc_html__( 'style', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_image_style('post_categories',  '.post-author img', $algin=false);

        $this->end_controls_section();

    } 

    protected function register_controls() {

        $this->register_style_section_1();
    }

    protected function render() {
        global $post;
        $author_id = $post->post_author;
        // Get the author's avatar
        $author_avatar = get_avatar( $author_id, 96 ); // 96 is the size of the avatar

        echo '<div class="post-author">';
        echo '<a href="' . esc_url( get_author_posts_url( $author_id ) ) . '">' . $author_avatar . '</a>';
        echo '</div>';
    }

}