<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_page_breadcrumb extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_page_breadcrumb';
    }

    public function get_title() {
        return esc_html__('page breadcrumb', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_page_breadcrumb';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_content_section_1() {
        $this->start_controls_section(
            'label',
            [
                'label' => __( 'home Labels', THEME_NAME ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,

            ]
        );

        $this->add_control(
            'home',
            [
                'label' => __( 'home', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'home', THEME_NAME ),
            ]
        );

        $this->add_control(
            'separator',
            [
                'label' => __( 'separator', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( ' > ', THEME_NAME ),
            ]
        );

        $this->end_controls_section();

    } 
    protected function register_style_section_1() {
        $this->start_controls_section(
            'home_style_section',
            [
                'label' => esc_html__( 'home', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('home',  '.home', $align=false);

        $this->end_controls_section();

    } 

    protected function register_style_section_2() {
        $this->start_controls_section(
            'separator_style_section',
            [
                'label' => esc_html__( 'separator', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('separator',  '.separator', $align=false);

        $this->end_controls_section();
    } 

    protected function register_style_section_3() {
        $this->start_controls_section(
            'current_style_section',
            [
                'label' => esc_html__( 'current', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('current',  '.current', $align=false);

        $this->end_controls_section();
    } 

    protected function register_controls() {

        $this->register_content_section_1();

        $this->register_style_section_1();
        $this->register_style_section_2();
        $this->register_style_section_3();
    }

    protected function render(){
		$settings = $this->get_settings_for_display();
		$breadcrumbs = array();
        $current_page_id = get_the_ID();

        $breadcrumbs[] = '<a class="home" href="' . esc_url(home_url('/')) . '">' . $settings['home'] . '</a>';

        $parent_page_ids = get_post_ancestors($current_page_id);
        if ($parent_page_ids) {
            foreach (array_reverse($parent_page_ids) as $parent_page_id) {
                $breadcrumbs[] = '<a class="perma" href="' . esc_url(get_permalink($parent_page_id)) . '">' . esc_html(get_the_title($parent_page_id)) . '</a>';
            }
        }
		$page_title = wp_title( '', false );
        $breadcrumbs[] = '<span class="current">' . esc_html( $page_title ) . '</span>';
		$separator = '<span class="separator">' . esc_html( $settings['separator'] ) . '</span>';

		echo '<div class="breadcrumbs">' . implode($separator, $breadcrumbs) . '</div>';
	}
}