<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_icon_box extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_icon_box';
    }

    public function get_title() {
        return esc_html__('icon box', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_icon_box';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_content_section_1(){

        $this->start_controls_section(
            'section_content_layout',
            [
                'label' => esc_html__( 'Layout', THEME_NAME ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );

		$this->add_control(
			'icon',
			[ 
				'label' => esc_html__( 'icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::ICONS,

			]
		);

		$this->add_control(
			'link',
			[ 
				'label' => esc_html__( 'Link', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::URL,
			]
		);

		$this->end_controls_section();

    } 

    protected function register_style_section_1() {
        $this->start_controls_section(
            'style',
            [
                'label' => esc_html__( 'style', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs( 'btn-text-style' );

        $this->start_controls_tab(
            'text-normal',
            [
                'label' => esc_html__( 'normal', THEME_NAME ),
            ]
        );

		$this->add_control(
			'container_style',
			[ 
				'label' => esc_html__( 'container', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);
        $this->register_container_style('container',  'a.container');

		$this->add_control(
			'icon_style',
			[ 
				'label' => esc_html__( 'icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'icon', 'a i' );

		$this->add_control(
			'text_style',
			[ 
				'label' => esc_html__( 'text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'text', 'p.text' );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'text-hover',
            [
                'label' => esc_html__( 'hover', THEME_NAME ),
            ]
        );

		$this->add_control(
			'container_style_hover',
			[ 
				'label' => esc_html__( 'container', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);
		$this->register_container_style( 'container_hover', 'a:hover' );

		$this->add_control(
			'icon_style_hover',
			[ 
				'label' => esc_html__( 'icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'icon_hover', 'a:hover i' );

		$this->add_control(
			'text_style_hover',
			[ 
				'label' => esc_html__( 'text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'text_hover', 'a:hover p.text' );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

    } 

    protected function register_controls() {
        $this->register_content_section_1();
        $this->register_style_section_1();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <a class="d-flex align-items-center flex-column container" href="<?php echo esc_attr( $settings['link']['url'] ); ?>">
            <?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
            <p class="text"><?php echo esc_html($settings['title']);?></p>
        </a>
        <?php
    }
}