<?php

use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_category_box extends \Elementor\Widget_Base {

    use basic_element;

    public function get_name() {
        return 'ar_category_box';
    }

    public function get_title() {
        return esc_html__('Category Box', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_category_box';
    }

    protected function get_html_wrapper_class() {
        return $this->get_name() . '-widget';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

	protected function register_content_section_1() {
		$this->start_controls_section(
            'section_layout',
            [
                'label' => esc_html__( 'Layout', THEME_NAME ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_responsive_control(
            'columns',
            [
                'label'              => esc_html__( 'Columns', THEME_NAME ),
                'type'               => \Elementor\Controls_Manager::SELECT,
                'default'            => '4',
                'tablet_default'     => '2',
                'mobile_default'     => '2',
                'options'            => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'selectors' => [
                    '{{WRAPPER}} .theme-categories-box' => 'grid-template-columns: repeat({{SIZE}}, 1fr);',
                ],
            ]
        );

        $this->add_responsive_control(
            'column_gap',
            [
                'label'     => esc_html__( 'Column Gap', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SLIDER,
                'default'   => [
                    'size' => '20',
                ],
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .theme-categories-box' => 'column-gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'row_gap',
            [
                'label'     => esc_html__( 'Row Gap', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SLIDER,
                'default'   => [
                    'size' => '20',
                ],
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .theme-categories-box' => 'row-gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
	}

	protected function register_content_section_2() {
		$this->start_controls_section(
            'section_categories',
            [
                'label' => esc_html__( 'Categories', THEME_NAME ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

		$taxonomies = array( 'category', 'post_tag' );

		$terms_list = array();

		foreach ( $taxonomies as $taxonomy ) {
			$terms = get_terms( array(
				'taxonomy' => $taxonomy,
				'hide_empty' => true, 
			) );

			foreach ( $terms as $term ) {
				$terms_list[ $term->term_id ] = $term->name;
			}
		}

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'category',
            [
                'label'         => esc_html__( 'Category', THEME_NAME ),
                'description'   => esc_html__( 'Select a category.', THEME_NAME ),
                'type'          => \Elementor\Controls_Manager::SELECT,
                'options'       => $terms_list,
            ]
        );

        $repeater->add_control(
            'category_image',
            [
                'label' => esc_html__( 'Image', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'category_items',
            [
                'label' => esc_html__( 'Category Items', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->end_controls_section();
	}

	protected function register_content_section_3() {
		$this->start_controls_section(
            'section_settings',
            [
                'label' => esc_html__( 'Settings', THEME_NAME ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

		$this->add_control(
		    'title_tag',
		    [
			    'label'     => esc_html__( 'Title HTML Tag', THEME_NAME ),
			    'type'      => \Elementor\Controls_Manager::SELECT,
			    'default'   => 'h3',
			    'options'   => theme_title_tag(),
		    ]
	    );

		$this->add_control(
		    'item_animation',
		    [
			    'label'   => esc_html__( 'Animation Style', THEME_NAME ),
			    'type'    => \Elementor\Controls_Manager::SELECT,
			    'default' => 'none',
			    'options' => [
				    'none'             => esc_html__( 'None', THEME_NAME ),
				    'scale-up'         => esc_html__( 'Scale Up', THEME_NAME ),
				    'move-up'          => esc_html__( 'Move Up', THEME_NAME ),
			    ],
		    ]
	    );

	    $this->add_group_control(
		    \Elementor\Group_Control_Image_Size::get_type(),
		    [
			    'name' => 'thumbnail',
			    'exclude' => ['custom'],
			    'default' => 'medium',
			    'dynamic' => [
				    'active' => true,
			    ]
		    ]
	    );

	    $this->add_responsive_control(
		    'image_height',
		    [
			    'label'     => esc_html__( 'Image Height', THEME_NAME ),
			    'type'      => \Elementor\Controls_Manager::SLIDER,
			    'size_units'=> [ 'px', '%' ],
			    'range'     => [
				    'px' => [
					    'min' => 50,
					    'max' => 400,
				    ],
				    '%' => [
					    'min' => 10,
					    'max' => 150,
				    ],
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .image-wrapper::before' => 'padding-top: {{SIZE}}{{UNIT}};',
			    ],
		    ]
	    );

	    $this->add_control(
		    'content_position',
		    [
			    'label'   => esc_html__( 'Content Position', THEME_NAME ),
			    'type'    => \Elementor\Controls_Manager::SELECT,
			    'default' => 'outside',
			    'options' => [
				    'inside'             => esc_html__( 'Inside', THEME_NAME ),
				    'outside'            => esc_html__( 'Outside', THEME_NAME ),
			    ],
			    'render_type'    => 'template',
			    'prefix_class' => 'content-position-',
		    ]
	    );

	    $this->add_control(
		    'content_v_align',
		    [
			    'label'   => esc_html__( 'Content Vertical Align', THEME_NAME ),
			    'type'    => \Elementor\Controls_Manager::SELECT,
			    'default' => 'center',
			    'options' => [
				    'top'               => esc_html__( 'Top', THEME_NAME ),
				    'center'            => esc_html__( 'Center', THEME_NAME ),
				    'bottom'            => esc_html__( 'Bottom', THEME_NAME ),
			    ],
			    'condition' => [
				    'content_position' => 'inside'
			    ]
		    ]
	    );

	    $this->add_control(
		    'content_align',
		    [
			    'label' => esc_html__( 'Alignment', THEME_NAME ),
			    'type' => \Elementor\Controls_Manager::CHOOSE,
			    'options' => [
					'right' => [
					    'title' => esc_html__( 'Right', THEME_NAME ),
					    'icon' => 'eicon-text-align-right',
				    ],
				    'center' => [
					    'title' => esc_html__( 'Center', THEME_NAME ),
					    'icon' => 'eicon-text-align-center',
				    ],
				    'left' => [
					    'title' => esc_html__( 'Left', THEME_NAME ),
					    'icon' => 'eicon-text-align-left',
				    ],
			    ],
			    'default' => 'left',
			    'selectors' => [
				    '{{WRAPPER}} .content-wrapper' => 'text-align: {{VALUE}};'
			    ]
		    ]
	    );

		$this->add_control(
            'open_link_new_tab',
            [
                'label'     => esc_html__( 'Open Link In New Tab', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SWITCHER,
            ]
        );

	
        $this->add_control(
            'show_count',
            [
                'label'     => esc_html__( 'Show Posts Count', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'category_count_text',
            [
                'label'     => esc_html__( 'Count Text', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( ' Posts' , THEME_NAME ),
                'condition' => [
                    'show_count' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();
	}

	protected function register_style_section_1() {
		$this->start_controls_section('section_style_cat_item',
		    [
			    'label' => esc_html__('Category Item', THEME_NAME),
			    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		    ]);


	    $this->start_controls_tabs('tabs_cat_item_style');

	    $this->start_controls_tab('tab_cat_item_normal',
		    [
			    'label' => esc_html__('Normal', THEME_NAME),
		    ]);

		$this->register_container_style('normal_box', '.cat-item');

	    $this->end_controls_tab();

	    $this->start_controls_tab('tab_cat_item_hover',
		    [
			    'label' => esc_html__('Hover', THEME_NAME),
		    ]);

		$this->register_container_style('hover_box', '.cat-item:hover');


	    $this->end_controls_tab();
	    $this->end_controls_tabs();

	    $this->end_controls_section();

	}
	
	protected function register_style_section_2() {
		$this->start_controls_section('section_style_image',
		    [
			    'label' => esc_html__('Image', THEME_NAME),
			    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		    ]
	    );

	    $this->start_controls_tabs('tabs_image_style');

	    $this->start_controls_tab('tab_image_normal',
		    [
			    'label' => esc_html__('Normal', THEME_NAME),
		    ]);

		$this->register_image_style('normal_img', '.image-wrapper img');
	    
	    $this->end_controls_tab();

	    $this->start_controls_tab('tab_image_hover',
		    [
			    'label' => esc_html__('Hover', THEME_NAME),
		    ]);

	    $this->register_image_style('hover_img', '.image-wrapper:hover img');

	    $this->end_controls_tab();
	    $this->end_controls_tabs();

	    $this->end_controls_section();
	}

	protected function register_style_section_3() {
		$this->start_controls_section('section_style_content',[
			'label' => esc_html__('Content', THEME_NAME),
			'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		]);

			
		$this->start_controls_tabs(
			'title_style_tabs'
	    );

	    $this->start_controls_tab(
		    'title_style_normal_tab',
		    [
			    'label' => esc_html__( 'Normal', THEME_NAME ),
		    ]
	    );
		
		$this->register_text_style('title_wrapper',  '.title-wrapper .title a', $align=false);
	    
	    $this->end_controls_tab();

	    $this->start_controls_tab(
		    'title_style_hover_tab',
		    [
			    'label' => esc_html__( 'Hover', THEME_NAME ),
		    ]
	    );

		$this->register_text_style('title_wrapper_hover',  '.title-wrapper .title a:hover', $align=false);

	    $this->end_controls_tab();
	    $this->end_controls_tabs();


	    $this->add_control(
		    'count_heading',
		    [
			    'label'     => esc_html__( 'Count', THEME_NAME ),
			    'type'      => \Elementor\Controls_Manager::HEADING,
			    'separator' => 'before',
			    'condition' => [
				    'show_count' => 'yes'
			    ]
		    ]
	    );

	    $this->start_controls_tabs(
			'count_style_tabs'
	    );

	    $this->start_controls_tab(
		    'count_style_normal_tab',
		    [
			    'label' => esc_html__( 'Normal', THEME_NAME ),
		    ]
	    );
		
		$this->register_text_style('count_wrapper',  '.count-wrapper');
	    
	    $this->end_controls_tab();

	    $this->start_controls_tab(
		    'count_style_hover_tab',
		    [
			    'label' => esc_html__( 'Hover', THEME_NAME ),
		    ]
	    );

		$this->register_text_style('count_wrapper_hover',  '.count-wrapper:hover');

	    $this->end_controls_tab();
	    $this->end_controls_tabs();


	    $this->end_controls_section();
	}
    protected function register_controls() {

   
		$this->register_content_section_1();
		$this->register_content_section_2();
		$this->register_content_section_3();

        $this->register_style_section_1();
        $this->register_style_section_2();
        $this->register_style_section_3();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();


		$cls = ($settings['item_animation'] != 'none')? 'cat-animation-' . $settings['item_animation'] : '';
		$v_align = $settings['content_v_align']? ' theme-position-' . $settings['content_v_align'] : '';
		?>
		<div class="theme-categories-box <?php echo esc_html($cls); ?>">
		<?php
		foreach (  $settings['category_items'] as $category_item ) {

			if(!$category_item['category'] || !$category_item['category_image']['id'])
				continue;

			$category = get_category($category_item['category']);

			if(!$category)
				continue;
			?>
			<div class="cat-item term-id-<?php echo intval($category->cat_ID); ?>">
				<div class="image-wrapper">
					<?php
					echo wp_get_attachment_image( $category_item['category_image']['id'], $settings['thumbnail_size'] );
					?>
					<a class="img-link " <?php if( $settings['open_link_new_tab'] ) echo 'target="_blank"'; ?> href="<?php echo esc_url(get_category_link($category->cat_ID)); ?>"></a>
				</div>
				<div class="content-wrapper<?php echo esc_html($v_align); ?>">
					<div class="title-wrapper">
						<<?php echo esc_attr($settings['title_tag']); ?> class="title">
						<a <?php if( $settings['open_link_new_tab'] ) echo 'target="_blank"'; ?> href="<?php echo esc_url(get_category_link($category->cat_ID)); ?>" title="<?php echo esc_html($category->name); ?>">
							<?php echo esc_html($category->name); ?>
						</a>
					</<?php echo esc_attr($settings['title_tag']); ?>>
					</div>
					<?php if( $settings['show_count'] ): ?>
						<div class="count-wrapper">
							<span class="count"><?php echo intval($category->count) .  esc_html($settings['category_count_text']); ?></span>
						</div>
					<?php endif; ?>
				</div>
			</div>
			<?php
		}
		?>
		</div>
		<?php
    }

}