<?php
namespace handler;

if ( ! defined( 'ABSPATH' ) ) { exit; } 


trait wavesurfer {

    protected function render_wave($audi_file) {
        $settings = $this->get_settings_for_display();
        ?>
        <style>
            .wave-body{
                position: relative;
            }
            .waveform-btn{
                position: absolute;
                display: flex;
                z-index: 4;
                left: 0;
                top: 40%;
                float:left;
            }
        </style>
        <div class="wave-body" id="waveform-<?php echo (get_the_ID())?>">
            <a class="waveform-btn button<?php echo (get_the_ID())?>"><i class="isax isax-play"></i></a>
        </div>
        <script>
            const wavesurfer<?php echo (get_the_ID())?> = WaveSurfer.create({
                container: '#waveform-<?php echo (get_the_ID())?>',
                waveColor: '#4F4A85',
                progressColor: '#383351',
                url: '<?php echo($audi_file);?>',
                interact: '<?php echo ($settings['interact']) ? 'true' : 'false'; ?>',
                dragToSeek: '<?php echo ($settings['dragToSeek']) ? 'true' : 'false'; ?>',
                normalize: '<?php echo ($settings['normalize']) ? 'true' : 'false'; ?>',
                cursorWidth: '<?php echo !empty($settings['cursorWidth']['size']) ? $settings['cursorWidth']['size'] : '2'; ?>',
                barWidth: '<?php echo !empty($settings['barWidth']['size']) ? $settings['barWidth']['size'] : '1'; ?>',
                barGap: '<?php echo !empty($settings['barGap']['size']) ? $settings['barGap']['size'] : '0'; ?>',
                barHeight: '<?php echo !empty($settings['barHeight']['size']) ? $settings['barHeight']['size'] : '2'; ?>',
                height: '<?php echo !empty($settings['height']['size']) ? $settings['height']['size'] : '150'; ?>',
                waveColor: '<?php echo !empty($settings['waveColor']['value']) ? $settings['waveColor']['value'] : '#929292'; ?>',
                progressColor: '<?php echo !empty($settings['progressColor']['value']) ? $settings['progressColor']['value'] : '#D9D9D9'; ?>',
                cursorColor: '<?php echo !empty($settings['cursorColor']['value']) ? $settings['cursorColor']['value'] : '#232332'; ?>',
            })

            document.querySelector('.button<?php echo (get_the_ID())?>').addEventListener('click', () => {
            const button = document.querySelector('.button<?php echo (get_the_ID())?>');
            const icon = button.querySelector('i');

            if (icon.classList.contains('isax-play')) {
                icon.classList.remove('isax-play');
                icon.classList.add('isax-pause');
                button.style.backgroundColor = '#F14647';
                wavesurfer<?php echo (get_the_ID())?>.play();
            } else {
                icon.classList.remove('isax-pause');
                icon.classList.add('isax-play');
                button.style.backgroundColor = '#232332';
                wavesurfer<?php echo (get_the_ID())?>.pause();
            }
        });

        </script>
    <?php
    }

    protected function register_vawe_controls() {

        $this->start_controls_section(
            'section_vawe_settings', [
                'label' => esc_html__( 'vawe Settings', THEME_NAME ) ,
                'tab'   => \Elementor\Controls_Manager::TAB_LAYOUT,
            ] 
        );

        $this->add_control(
			'interact',
			[ 
				'label' => esc_html__( 'interact', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

        $this->add_control(
			'dragToSeek',
			[ 
				'label' => esc_html__( 'dragToSeek', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

        $this->add_control(
			'normalize',
			[ 
				'label' => esc_html__( 'normalize', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

        $this->add_control(
		    'width',
		    [
                'label' => esc_html__('Width', THEME_NAME),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1400,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
				'selectors' => [ 
					'{{WRAPPER}} .wave-body' => 'width: {{SIZE}}{{UNIT}};',
				],
            ]
	    );

        $this->add_control(
		    'height',
		    [
                'label' => esc_html__('height', THEME_NAME),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1400,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
            ]
	    );

        $this->add_control(
		    'cursorWidth',
		    [
                'label' => esc_html__('cursor Width', THEME_NAME),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1400,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
            ]
	    );

        $this->add_control(
		    'barWidth',
		    [
                'label' => esc_html__('bar Width', THEME_NAME),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1400,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
            ]
	    );

        $this->add_control(
		    'barGap',
		    [
                'label' => esc_html__('bar Gap', THEME_NAME),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1400,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
            ]
	    );

        $this->add_control(
		    'barHeight',
		    [
                'label' => esc_html__('bar Height', THEME_NAME),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1400,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
            ]
	    );

        $this->add_control(
			'waveColor',
			[
				'label' => esc_html__( 'waveColor', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::COLOR,
			]
		);

        $this->add_control(
			'progressColor',
			[
				'label' => esc_html__( 'progressColor', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::COLOR,
			]
		);

        $this->add_control(
			'cursorColor',
			[
				'label' => esc_html__( 'cursorColor', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::COLOR,
			]
		);

        $this->end_controls_section();
    }

}