<?php

use sellect_control\Ajax_Select2;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

if ( ! did_action( 'elementor/loaded' ) ) {
    return false;
}

// Controls
require_once THEME_DIR . '/elementor/controls/ajax-select2.php';


// Traits
require_once THEME_DIR . '/elementor/traits/basic_element.php';
require_once THEME_DIR . '/elementor/traits/swiper.php';
require_once THEME_DIR . '/elementor/traits/group-control-query.php';
require_once THEME_DIR . '/elementor/traits/product-query.php';
require_once THEME_DIR . '/elementor/traits/post-skin-base.php';
require_once THEME_DIR . '/elementor/traits/video.php';
require_once THEME_DIR . '/elementor/traits/wavesurfer.php';
require_once THEME_DIR . '/elementor/helper.php';
require_once THEME_DIR . '/elementor/icons/iconsax.php';
require_once THEME_DIR . '/elementor/icons/persian.php';


// Create an instance of the elementor_helper class
$helper_instance = elementor_helper::get_instance();

add_action('elementor/elements/categories_registered', [$helper_instance, 'add_elementor_widget_categories']);
add_action('elementor/controls/register', [$helper_instance, 'register_controls']);
add_action('elementor/widgets/register', [$helper_instance, 'register_widgets'], 1); 

