(function($){

    'use strict';


    function isScrolledIntoViewport(elem) {
        var docViewTop = $(window).scrollTop();
        var docViewBottom = docViewTop + $(window).height();

        var elemTop = $(elem).offset().top;
        var elemBottom = elemTop + $(elem).height();

        return ((elemBottom <= docViewBottom) && (elemTop >= docViewTop));
    }

    // Site Preload & Fix transitions on load
    $(window).on('load', function() {
        $("body").addClass("site-loaded");
    });


    // Smooth Scroll
    if( typeof SmoothScroll == 'function' && $('body').hasClass('theme-smooth-scroll') ) {
        SmoothScroll({ keyboardSupport: false });
    }


    // Post Reading Progress Indicator
    if($('.post-reading-progress-indicator').length) {
        $(window).on('scroll', function () {
            let docHeight = $("body").height();
            let winHeight = $(window).height();
            let viewport = docHeight - winHeight;
            let scrollPos = $(window).scrollTop();
            let scrollPercent = (scrollPos / viewport) * 100;
            $(".post-reading-progress-indicator span").css("width", scrollPercent + "%");

        });
    }

    // Offcanvas
    $('.offcanvas-container').on('click', function (e) {
        e.stopPropagation();
    });
    $('body').on('click', '.offcanvas-opener', function (e) {
        e.stopPropagation();
        $(this).closest('.theme-offcanvas').find('.offcanvas-wrapper').addClass('open');
    });

    $('body, .offcanvas-closer').on('click', function (e) {
        $('.offcanvas-wrapper').removeClass('open');
    });

    // Popup Search
    $('body').on('click', '.popup-search-opener', function (e) {
        e.stopPropagation();
        $(this).closest('.popup-search-wrapper').find('.popup-search').addClass('open');
    });

    $('.popup-search-container').on('click', function (e) {
        e.stopPropagation();
    });

    $('body, .popup-search-closer').on('click', function (e) {
        $('.popup-search').removeClass('open');
    });

    // Sticky Header
    $(window).on('scroll', function () {

        if ( $('#site-sticky-header').length == 0 ) { // Check sticky header is enabled
            return;
        }

        var stickyPos = $('#site-header').outerHeight() + 300;
        var scroll = $(window).scrollTop();

        if( scroll > stickyPos ) {
            $('#site-sticky-header').addClass('fixed');
        }
        else {
            $('#site-sticky-header').removeClass('fixed');
            $('#site-sticky-header .popup-search').removeClass('open');
            $('#site-sticky-header .offcanvas-wrapper').removeClass('open');
        }
    });
	
	
	// Header Nav prevent # jump
	$('.theme-header-nav li > a[href="#"]').on('click', function (e) {
        e.preventDefault();
    });
	

    // Header Vertical Nav
    $('.header-vertical-nav li.menu-item-has-children > a').on('click', function (e) {
        e.preventDefault();
        $(this).siblings('.sub-menu').slideToggle();
    });

    // Header Mega Menu
	$('.theme-header-nav .sub-menu.mega-menu-content').css('display', 'block');
    $('.theme-header-nav li.theme-mega-menu-4-col > .sub-menu').css('display', 'flex');
    $('body').on('mouseenter', '.theme-header-nav li.theme-mega-menu-item, .theme-header-nav li.theme-mega-menu-4-col', function() {
        var megaMenuWidth = $(this).closest('.elementor-container').width();

        // No need for default header.
        if(megaMenuWidth === undefined)
            return;

        var subMenu = $(this).children('.sub-menu');
        subMenu.css('width', megaMenuWidth);

        var menuPos = $(this).closest('.theme-header-nav').offset().left;
        var elementorContainerPos = $(this).closest('.elementor-container').offset().left;

        if( $('body').hasClass('rtl') ) {
            var menuRightPos = menuPos + $(this).closest('.theme-header-nav').width();
            var elementorContainerRightPos = elementorContainerPos + megaMenuWidth;

            subMenu.css('right', parseInt(menuRightPos - elementorContainerRightPos));

        }
        else {
            subMenu.css('left', parseInt(elementorContainerPos - menuPos));
        }


    });

    // Back to Top Button
    $(window).on('scroll', function (e) {

        var showPos = $('#site-header').outerHeight() + 200;
        var scroll = $(window).scrollTop();

        if( scroll > showPos ) {
            $('#scroll-up').addClass('show');
        }
        else {
            $('#scroll-up').removeClass('show');
        }

    });

    $('#scroll-up').click(function(e) {
        $('body,html').animate({scrollTop:0},800);
    });


    // Footer Canvas Menu
    $('.footer-canvas-menu-btn').click(function(e) {
        if( $(this).hasClass('active') ) {
            $(this).removeClass('active');
            $('body').removeClass('footer-canvas-menu-active');
        }
        else {
            $(this).addClass('active');
            $('body').addClass('footer-canvas-menu-active');
        }

    });

    // Sticky Sidebar
    if( $('#site-sticky-header').length ) {
        $('.sidebar-container.sticky .sidebar-container-inner').css('top', $('#site-sticky-header').outerHeight() + 10);
    }

    // Comments Area Collapsable
    $('.comments-list-collapse-btn').on('click', function (e) {
        var commentsArea = $('.comments-area');
        var btn = $(this);

        if( commentsArea.hasClass('collapsed') ) {
            commentsArea.slideDown();
            commentsArea.removeClass('collapsed');
            btn.text( btn.data('hide') );
        }
        else {
            commentsArea.slideUp();
            commentsArea.addClass('collapsed');
            btn.text( btn.data('show') );
        }
    });

    // Single Post Share Link Box
    $(".share-box-link .share-link-btn").on('click', function(){
        // Get the text to copy
        var textToCopy = $(".share-box-link .share-link-text").val();

        // Create a temporary input element
        var tempInput = document.createElement("input");
        tempInput.style.position = "absolute";
        tempInput.style.left = "-9999px"; // Move off-screen
        tempInput.value = textToCopy;

        // Append the input element to the body
        document.body.appendChild(tempInput);

        // Select the input element's value
        tempInput.select();

        // Execute the copy command
        document.execCommand('copy');

        // Remove the temporary input element
        document.body.removeChild(tempInput);

        // Show copied popup text
        $('.share-box-link .copied-popup-text').addClass('show');
        setTimeout(function () {
            $('.share-box-link .copied-popup-text').removeClass('show');
        }, 2000);
    });



    // Infinite Scroll Load More
    $(window).on('scroll', function () {

        $( ".theme-post-load-more.infinite-scroll" ).each(function( index ) {

            if( isScrolledIntoViewport($(this)) ) {
                $(this).trigger("click");
            }

        });

    });	
    
    var PostsHandler = function( $scope, $ ) {
        // Single Post Gallery Hero
        if ( $('.single-hero-gallery-container').length ){
            if( $('.single-hero-inside .single-hero-gallery-container').length ) {
                var gallerySettings = {
                    slidesPerView: 1,
                    slidesPerGroup: 1,
                    centeredSlides: true,
                    loop: true,
                    autoplay: true,
                    spaceBetween: 30,
                    a11y: {
                        enabled: false,
                    },
                    navigation: {
                        nextEl: ".single-hero-gallery-container .swiper-button-next",
                        prevEl: ".single-hero-gallery-container .swiper-button-prev",
                    }
                };
            }
            else {
                var gallerySettings = {
                    slidesPerView: 1,
                    slidesPerGroup: 1,
                    centeredSlides: true,
                    loop: true,
                    autoplay: true,
                    spaceBetween: 30,
                    a11y: {
                        enabled: false,
                    },
                    navigation: {
                        nextEl: ".single-hero-gallery-container .swiper-button-next",
                        prevEl: ".single-hero-gallery-container .swiper-button-prev",
                    },
                    breakpoints: {
                        576: {
                            slidesPerView: 2,
                        },
                        992: {
                            slidesPerView: 2,
                        }
                    }
                };
            }

            var carouselContainer = $('.single-hero-gallery-container .swiper-container');

            if ( 'undefined' === typeof Swiper ) {
                const asyncSwiper = elementorFrontend.utils.swiper;

                new asyncSwiper( carouselContainer, gallerySettings ).then( ( newSwiperInstance ) => {
                    var swiper = newSwiperInstance;
                } );
            } else {
                var swiper = new Swiper(carouselContainer, gallerySettings);
            }

        }



        // Post Stellar
        if( $scope.find('.theme-stellar-wrapper').length ) {

            var wrapper = $scope.find('.theme-stellar-wrapper');

            wrapper.find('.post-item').on('mouseenter click', function() {
                if( $(this).hasClass('active') )
                    return;

                var id = $(this).data('id');
                wrapper.find('.post-item').removeClass('active');
                $(this).addClass('active');

                wrapper.find('.image-item').removeClass('active');
                wrapper.find('.image-item[data-id="' + id + '"]').addClass('active');

            });
        }

    }
    
    // Elementor Widgets
    $( window ).on( 'elementor/frontend/init', function () {

        elementorFrontend.hooks.addAction( 'frontend/element_ready/widget', PostsHandler );

    } );
    
    $(window).on('load', function() {
        // Get all elements with the .plyr class
        const plyrElements = document.querySelectorAll('.plyr');

        // Iterate over each plyr element and initialize Plyr.js
        plyrElements.forEach(function(element) {
            const player = new Plyr(element);
        });
    });

    $('.qty').each(function() {
        $(this).before('<button type="button" class="plus">+</button>');
        $(this).after('<button type="button" class="minus">-</button>');
    });

    
    // Plus button click event
    $(document).on('click', '.plus', function() {
        var quantityInput = $(this).siblings('.qty');
        var currentValue = parseInt(quantityInput.val());
        quantityInput.val( currentValue + 1 ).change();
    } );
    
    $('.woocommerce-cart-form').on('submit', function(e) {
        e.preventDefault(); // Prevent default form submission

        // Perform AJAX request
        $.ajax({
            url: $(this).attr('action'), // Form action URL
            type: 'POST', // Form submission method
            data: $(this).serialize(), // Serialize form data
            success: function(response) {
                // Handle successful AJAX response
                setTimeout(function() {
                    location.reload(); // Reload the current page
                }, 0);
                // Additional actions after form submission...
            },
            error: function(xhr, status, error) {
                // Handle AJAX errors
            }
        } );
    });

    // Minus button click event
    $(document).on('click', '.minus', function() {
        var quantityInput = $(this).siblings('.qty');
        var currentValue = parseInt(quantityInput.val());
        if (currentValue > 1) {
            quantityInput.val(currentValue - 1).change();
        }
    });
    
    $(document).on('change', '.qty', function() {
        // Trigger form submission when quantity changes
        // $(this).closest('form').submit();
    } );

    // $('.single-share-box-container').on('change', 'input.qty', function(){
    //     console.log( this );
    //     $(this).closest('form').submit();
    //     $("[name='update_cart']").trigger("click");
    // });
    
   
})( jQuery );
